/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import gregtech.api.block.BuiltInRenderBlock;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.cover.IFacadeCover;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.IBlockAppearance;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.ItemBlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.integration.ctm.IFacadeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockPipe<PipeType extends Enum<PipeType>, NodeDataType, WorldPipeNetType extends WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends BuiltInRenderBlock
implements ITileEntityProvider,
IFacadeWrapper,
IBlockAppearance {
    protected final ThreadLocal<IPipeTile<PipeType, NodeDataType>> tileEntities = new ThreadLocal();

    public BlockPipe() {
        super(Material.field_151573_f);
        this.func_149663_c("pipe");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(3.0f);
        this.func_149713_g(0);
        this.func_149649_H();
    }

    public static Cuboid6 getSideBox(EnumFacing side, float thickness) {
        Cuboid6 cuboid;
        float min = (1.0f - thickness) / 2.0f;
        float max = min + thickness;
        float faceMin = 0.0f;
        float faceMax = 1.0f;
        if (side == null) {
            return new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        switch (side) {
            case WEST: {
                cuboid = new Cuboid6((double)faceMin, (double)min, (double)min, (double)min, (double)max, (double)max);
                break;
            }
            case EAST: {
                cuboid = new Cuboid6((double)max, (double)min, (double)min, (double)faceMax, (double)max, (double)max);
                break;
            }
            case NORTH: {
                cuboid = new Cuboid6((double)min, (double)min, (double)faceMin, (double)max, (double)max, (double)min);
                break;
            }
            case SOUTH: {
                cuboid = new Cuboid6((double)min, (double)min, (double)max, (double)max, (double)max, (double)faceMax);
                break;
            }
            case UP: {
                cuboid = new Cuboid6((double)min, (double)max, (double)min, (double)max, (double)faceMax, (double)max);
                break;
            }
            case DOWN: {
                cuboid = new Cuboid6((double)min, (double)faceMin, (double)min, (double)max, (double)min, (double)max);
                break;
            }
            default: {
                cuboid = new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
            }
        }
        return cuboid;
    }

    public static Cuboid6 getCoverSideBox(EnumFacing side, float thickness) {
        Cuboid6 cuboid = BlockPipe.getSideBox(side, thickness);
        if (side != null) {
            cuboid.setSide(side, side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 0.001 : 0.999);
        }
        return cuboid;
    }

    public abstract Class<PipeType> getPipeTypeClass();

    public abstract WorldPipeNetType getWorldPipeNet(World var1);

    public abstract TileEntityPipeBase<PipeType, NodeDataType> createNewTileEntity(boolean var1);

    public abstract NodeDataType createProperties(IPipeTile<PipeType, NodeDataType> var1);

    public abstract NodeDataType createItemProperties(ItemStack var1);

    public abstract ItemStack getDropItem(IPipeTile<PipeType, NodeDataType> var1);

    protected abstract NodeDataType getFallbackType();

    public abstract PipeType getItemPipeType(ItemStack var1);

    public abstract void setTileEntityData(TileEntityPipeBase<PipeType, NodeDataType> var1, ItemStack var2);

    public abstract void func_149666_a(@NotNull CreativeTabs var1, @NotNull NonNullList<ItemStack> var2);

    public void func_180663_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            pipeTile.getCoverableImplementation().dropAllCovers();
            this.tileEntities.set(pipeTile);
        }
        super.func_180663_b(worldIn, pos, state);
        ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).removeNode(pos);
    }

    public void func_176213_c(World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, 1);
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            int activeConnections = pipeTile.getConnections();
            boolean isActiveNode = activeConnections != 0;
            ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).addNode(pos, this.createProperties(pipeTile), 0, activeConnections, isActiveNode);
            this.onActiveModeChange(worldIn, pos, isActiveNode, true);
        }
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityLivingBase placer, @NotNull ItemStack stack) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            this.setTileEntityData((TileEntityPipeBase)pipeTile, stack);
            if (placer instanceof EntityPlayer) {
                ItemStack offhand = placer.func_184592_cb();
                for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                    if (!offhand.func_77969_a(MetaItems.SPRAY_CAN_DYES[i].getStackForm())) continue;
                    MetaItems.SPRAY_CAN_DYES[i].getBehaviours().get(0).onItemUse((EntityPlayer)placer, worldIn, pos, EnumHand.OFF_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                    break;
                }
            }
        }
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        if (worldIn.field_72995_K) {
            return;
        }
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null) {
            pipeTile.getCoverableImplementation().updateInputRedstoneSignals();
            EnumFacing facing = GTUtility.getFacingToNeighbor(pos, fromPos);
            if (facing == null) {
                return;
            }
            pipeTile.onNeighborChanged(facing);
            if (!ConfigHolder.machines.gt6StylePipesCables) {
                boolean canConnect;
                boolean open = pipeTile.isConnected(facing);
                boolean bl = canConnect = pipeTile.getCoverableImplementation().getCoverAtSide(facing) != null || this.canConnect(pipeTile, facing);
                if (!open && canConnect && state.func_177230_c() != blockIn) {
                    pipeTile.setConnection(facing, true, false);
                }
                if (open && !canConnect) {
                    pipeTile.setConnection(facing, false, false);
                }
                this.updateActiveNodeStatus(worldIn, pos, pipeTile);
            }
        }
    }

    public void onNeighborChange(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull BlockPos neighbor) {
        EnumFacing facing;
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        if (pipeTile != null && (facing = GTUtility.getFacingToNeighbor(pos, neighbor)) != null) {
            pipeTile.onNeighborChanged(facing);
        }
    }

    public void observedNeighborChange(@NotNull IBlockState observerState, @NotNull World world, @NotNull BlockPos observerPos, @NotNull Block changedBlock, @NotNull BlockPos changedBlockPos) {
        Object net = ((WorldPipeNet)((Object)this.getWorldPipeNet(world))).getNetFromPos(observerPos);
        if (net != null) {
            ((PipeNet)net).onNeighbourUpdate(changedBlockPos);
        }
    }

    public boolean canConnectRedstone(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable EnumFacing side) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        return pipeTile != null && pipeTile.getCoverableImplementation().canConnectRedstone(side);
    }

    public boolean shouldCheckWeakPower(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        return false;
    }

    public int func_180656_a(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(blockAccess, pos);
        return pipeTile == null ? 0 : pipeTile.getCoverableImplementation().getOutputRedstoneSignal(side.func_176734_d());
    }

    public void updateActiveNodeStatus(@NotNull World worldIn, BlockPos pos, IPipeTile<PipeType, NodeDataType> pipeTile) {
        int activeConnections;
        boolean isActiveNodeNow;
        boolean modeChanged;
        if (worldIn.field_72995_K) {
            return;
        }
        Object pipeNet = ((WorldPipeNet)((Object)this.getWorldPipeNet(worldIn))).getNetFromPos(pos);
        if (pipeNet != null && pipeTile != null && (modeChanged = ((PipeNet)pipeNet).markNodeAsActive(pos, isActiveNodeNow = (activeConnections = pipeTile.getConnections()) != 0))) {
            this.onActiveModeChange(worldIn, pos, isActiveNodeNow, false);
        }
    }

    @Nullable
    public TileEntity func_149915_a(@NotNull World worldIn, int meta) {
        return this.createNewTileEntity(false);
    }

    protected void onActiveModeChange(World world, BlockPos pos, boolean isActiveNow, boolean isInitialChange) {
    }

    @NotNull
    public ItemStack getPickBlock(@NotNull IBlockState state, @NotNull RayTraceResult target, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)world, pos);
        if (pipeTile == null) {
            return ItemStack.field_190927_a;
        }
        if (target instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult result = (CuboidRayTraceResult)target;
            Object object = result.cuboid6.data;
            if (object instanceof CoverRayTracer.CoverSideData) {
                CoverRayTracer.CoverSideData coverSideData = (CoverRayTracer.CoverSideData)object;
                EnumFacing coverSide = coverSideData.side;
                Cover cover = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
                return cover == null ? ItemStack.field_190927_a : cover.getPickItem();
            }
        }
        return this.getDropItem(pipeTile);
    }

    public boolean func_180639_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        CuboidRayTraceResult rayTraceResult = this.getServerCollisionRayTrace(playerIn, pos, worldIn);
        if (rayTraceResult == null || pipeTile == null) {
            return false;
        }
        return this.onPipeActivated(worldIn, state, pos, playerIn, hand, facing, rayTraceResult, pipeTile);
    }

    public boolean onPipeActivated(World world, IBlockState state, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, EnumFacing side, CuboidRayTraceResult hit, IPipeTile<PipeType, NodeDataType> pipeTile) {
        Cover cover;
        EnumFacing coverSide;
        IBlockState blockStateAtSide;
        BlockFrame frameBlock;
        ItemStack itemStack = entityPlayer.func_184586_b(hand);
        if (pipeTile.getFrameMaterial() == null && pipeTile instanceof TileEntityPipeBase && ((IPipeType)pipeTile.getPipeType()).getThickness() < 1.0f && (frameBlock = BlockFrame.getFrameBlockFromItem(itemStack)) != null) {
            ((TileEntityPipeBase)pipeTile).setFrameMaterial(frameBlock.getGtMaterial(itemStack));
            SoundType type = frameBlock.getSoundType(itemStack);
            world.func_184133_a(entityPlayer, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        if (itemStack.func_77973_b() instanceof ItemBlockPipe && (blockStateAtSide = world.func_180495_p(pos.func_177972_a(side))).func_177230_c() instanceof BlockFrame) {
            ItemBlockPipe itemBlockPipe = (ItemBlockPipe)itemStack.func_77973_b();
            if (itemBlockPipe.blockPipe.getItemPipeType(itemStack) == this.getItemPipeType(itemStack)) {
                BlockFrame frameBlock2 = (BlockFrame)blockStateAtSide.func_177230_c();
                boolean wasPlaced = frameBlock2.replaceWithFramedPipe(world, pos.func_177972_a(side), blockStateAtSide, entityPlayer, itemStack, side);
                if (wasPlaced) {
                    pipeTile.setConnection(side, true, false);
                }
                return wasPlaced;
            }
        }
        if ((coverSide = CoverRayTracer.traceCoverSide((RayTraceResult)hit)) == null) {
            return this.activateFrame(world, state, pos, entityPlayer, hand, hit, pipeTile);
        }
        if (!(hit.cuboid6.data instanceof CoverRayTracer.CoverSideData)) {
            switch (this.onPipeToolUsed(world, pos, itemStack, coverSide, pipeTile, entityPlayer, hand)) {
                case SUCCESS: {
                    return true;
                }
                case FAIL: {
                    return false;
                }
            }
        }
        if ((cover = pipeTile.getCoverableImplementation().getCoverAtSide(coverSide)) == null) {
            return this.activateFrame(world, state, pos, entityPlayer, hand, hit, pipeTile);
        }
        if (itemStack.func_77973_b().getToolClasses(itemStack).contains("mallet") && cover.onSoftMalletClick(entityPlayer, hand, hit) == EnumActionResult.SUCCESS) {
            ToolHelper.damageItem(itemStack, (EntityLivingBase)entityPlayer);
            ToolHelper.playToolSound(itemStack, entityPlayer);
            return true;
        }
        if ((itemStack.func_190926_b() && entityPlayer.func_70093_af() || itemStack.func_77973_b().getToolClasses(itemStack).contains("screwdriver")) && cover.onScrewdriverClick(entityPlayer, hand, hit) == EnumActionResult.SUCCESS) {
            if (!itemStack.func_190926_b()) {
                ToolHelper.damageItem(itemStack, (EntityLivingBase)entityPlayer);
                ToolHelper.playToolSound(itemStack, entityPlayer);
            }
            return true;
        }
        if (itemStack.func_77973_b().getToolClasses(itemStack).contains("crowbar") && !world.field_72995_K) {
            pipeTile.getCoverableImplementation().removeCover(coverSide);
            ToolHelper.damageItem(itemStack, (EntityLivingBase)entityPlayer);
            ToolHelper.playToolSound(itemStack, entityPlayer);
            return true;
        }
        EnumActionResult result = cover.onRightClick(entityPlayer, hand, hit);
        if (result == EnumActionResult.PASS) {
            if (this.activateFrame(world, state, pos, entityPlayer, hand, hit, pipeTile)) {
                return true;
            }
            return entityPlayer.func_70093_af() && entityPlayer.func_184614_ca().func_190926_b() && cover.onScrewdriverClick(entityPlayer, hand, hit) != EnumActionResult.PASS;
        }
        return true;
    }

    private boolean activateFrame(World world, IBlockState state, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, CuboidRayTraceResult hit, IPipeTile<PipeType, NodeDataType> pipeTile) {
        if (pipeTile.getFrameMaterial() != null && !(entityPlayer.func_184586_b(hand).func_77973_b() instanceof ItemBlockPipe)) {
            BlockFrame blockFrame = MetaBlocks.FRAMES.get(pipeTile.getFrameMaterial());
            return blockFrame.func_180639_a(world, pos, state, entityPlayer, hand, hit.field_178784_b, (float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
        }
        return false;
    }

    public EnumActionResult onPipeToolUsed(World world, BlockPos pos, ItemStack stack, EnumFacing coverSide, IPipeTile<PipeType, NodeDataType> pipeTile, EntityPlayer entityPlayer, EnumHand hand) {
        if (this.isPipeTool(stack)) {
            if (!entityPlayer.field_70170_p.field_72995_K) {
                if (entityPlayer.func_70093_af() && pipeTile.canHaveBlockedFaces()) {
                    boolean isBlocked = pipeTile.isFaceBlocked(coverSide);
                    pipeTile.setFaceBlocked(coverSide, !isBlocked);
                    ToolHelper.playToolSound(stack, entityPlayer);
                } else {
                    boolean isOpen = pipeTile.isConnected(coverSide);
                    pipeTile.setConnection(coverSide, !isOpen, false);
                    if (isOpen != pipeTile.isConnected(coverSide)) {
                        ToolHelper.playToolSound(stack, entityPlayer);
                    }
                }
                ToolHelper.damageItem(stack, (EntityLivingBase)entityPlayer);
                return EnumActionResult.SUCCESS;
            }
            entityPlayer.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected boolean isPipeTool(@NotNull ItemStack stack) {
        return ToolHelper.isTool(stack, "wrench");
    }

    public void func_180649_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull EntityPlayer playerIn) {
        Cover cover;
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        if (pipeTile == null || rayTraceResult == null) {
            return;
        }
        EnumFacing coverSide = CoverRayTracer.traceCoverSide((RayTraceResult)rayTraceResult);
        Cover cover2 = cover = coverSide == null ? null : pipeTile.getCoverableImplementation().getCoverAtSide(coverSide);
        if (cover != null) {
            cover.onLeftClick(playerIn, rayTraceResult);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null && pipeTile.getFrameMaterial() != null) {
            BlockFrame blockFrame = MetaBlocks.FRAMES.get(pipeTile.getFrameMaterial());
            blockFrame.func_180634_a(worldIn, pos, state, entityIn);
        }
    }

    public void func_180657_a(@NotNull World worldIn, @NotNull EntityPlayer player, @NotNull BlockPos pos, @NotNull IBlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        this.tileEntities.set(te == null ? this.tileEntities.get() : (IPipeTile<PipeType, NodeDataType>)te);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.tileEntities.remove();
    }

    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        IPipeTile<PipeType, NodeDataType> pipeTile;
        IPipeTile<PipeType, NodeDataType> iPipeTile = pipeTile = this.tileEntities.get() == null ? this.getPipeTileEntity(world, pos) : this.tileEntities.get();
        if (pipeTile == null) {
            return;
        }
        if (pipeTile.getFrameMaterial() != null) {
            BlockFrame blockFrame = MetaBlocks.FRAMES.get(pipeTile.getFrameMaterial());
            drops.add((Object)blockFrame.getItem(pipeTile.getFrameMaterial()));
        }
        drops.add((Object)this.getDropItem(pipeTile));
    }

    public void func_185477_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull AxisAlignedBB entityBox, @NotNull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity((IBlockAccess)worldIn, pos);
        if (pipeTile != null && pipeTile.getFrameMaterial() != null) {
            AxisAlignedBB box = BlockFrame.COLLISION_BOX.func_186670_a(pos);
            if (box.func_72326_a(entityBox)) {
                collidingBoxes.add(box);
            }
            return;
        }
        for (Cuboid6 cuboid6 : this.getCollisionBox((IBlockAccess)worldIn, pos, entityIn)) {
            AxisAlignedBB offsetBox = cuboid6.aabb().func_186670_a(pos);
            if (!offsetBox.func_72326_a(entityBox)) continue;
            collidingBoxes.add(offsetBox);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(@NotNull IBlockState blockState, World worldIn, @NotNull BlockPos pos, @NotNull Vec3d start, @NotNull Vec3d end) {
        if (worldIn.field_72995_K) {
            return this.getClientCollisionRayTrace(worldIn, pos, start, end);
        }
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, this.getCollisionBox((IBlockAccess)worldIn, pos, null));
    }

    @SideOnly(value=Side.CLIENT)
    public RayTraceResult getClientCollisionRayTrace(World worldIn, @NotNull BlockPos pos, @NotNull Vec3d start, @NotNull Vec3d end) {
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, this.getCollisionBox((IBlockAccess)worldIn, pos, (Entity)Minecraft.func_71410_x().field_71439_g));
    }

    @Nullable
    public CuboidRayTraceResult getServerCollisionRayTrace(EntityPlayer playerIn, BlockPos pos, World worldIn) {
        return RayTracer.rayTraceCuboidsClosest((Vec3d)RayTracer.getStartVec((EntityPlayer)playerIn), (Vec3d)RayTracer.getEndVec((EntityPlayer)playerIn), (BlockPos)pos, this.getCollisionBox((IBlockAccess)worldIn, pos, (Entity)playerIn));
    }

    @NotNull
    public BlockFaceShape func_193383_a(@NotNull IBlockAccess worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(worldIn, pos);
        if (pipeTile != null && pipeTile.getCoverableImplementation().getCoverAtSide(face) != null) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean recolorBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, @NotNull EnumDyeColor color) {
        IPipeTile<PipeType, NodeDataType> tileEntityPipe = this.getPipeTileEntity((IBlockAccess)world, pos);
        if (tileEntityPipe != null && tileEntityPipe.getPipeType() != null && ((IPipeType)tileEntityPipe.getPipeType()).isPaintable() && tileEntityPipe.getPaintingColor() != color.field_193351_w) {
            tileEntityPipe.setPaintingColor(color.field_193351_w);
            return true;
        }
        return false;
    }

    protected boolean isThisPipeBlock(Block block) {
        return block != null && block.getClass().isAssignableFrom(this.getClass());
    }

    public IPipeTile<PipeType, NodeDataType> getPipeTileEntity(IBlockAccess world, BlockPos selfPos) {
        TileEntity tileEntityAtPos = world.func_175625_s(selfPos);
        return this.getPipeTileEntity(tileEntityAtPos);
    }

    @Nullable
    public IPipeTile<PipeType, NodeDataType> getPipeTileEntity(TileEntity tileEntityAtPos) {
        if (tileEntityAtPos instanceof IPipeTile && this.isThisPipeBlock(((IPipeTile)tileEntityAtPos).getPipeBlock())) {
            return (IPipeTile)tileEntityAtPos;
        }
        return null;
    }

    public boolean canConnect(IPipeTile<PipeType, NodeDataType> selfTile, EnumFacing facing) {
        if (selfTile.getPipeWorld().func_180495_p(selfTile.getPipePos().func_177972_a(facing)).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        Cover cover = selfTile.getCoverableImplementation().getCoverAtSide(facing);
        if (cover != null && !cover.canPipePassThrough()) {
            return false;
        }
        TileEntity other = selfTile.getNeighbor(facing);
        if (other instanceof IPipeTile) {
            cover = ((IPipeTile)other).getCoverableImplementation().getCoverAtSide(facing.func_176734_d());
            if (cover != null && !cover.canPipePassThrough()) {
                return false;
            }
            return this.canPipesConnect(selfTile, facing, (IPipeTile)other);
        }
        return this.canPipeConnectToBlock(selfTile, facing, other);
    }

    public abstract boolean canPipesConnect(IPipeTile<PipeType, NodeDataType> var1, EnumFacing var2, IPipeTile<PipeType, NodeDataType> var3);

    public abstract boolean canPipeConnectToBlock(IPipeTile<PipeType, NodeDataType> var1, EnumFacing var2, @Nullable TileEntity var3);

    private List<IndexedCuboid6> getCollisionBox(IBlockAccess world, BlockPos pos, @Nullable Entity entityIn) {
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        if (pipeTile == null) {
            return Collections.emptyList();
        }
        if (pipeTile.getFrameMaterial() != null) {
            return Collections.singletonList(MetaTileEntity.FULL_CUBE_COLLISION);
        }
        PipeType pipeType = pipeTile.getPipeType();
        if (pipeType == null) {
            return Collections.emptyList();
        }
        int actualConnections = pipeTile.getVisualConnections();
        float thickness = ((IPipeType)pipeType).getThickness();
        ArrayList<IndexedCuboid6> result = new ArrayList<IndexedCuboid6>();
        PipeCoverableImplementation coverHolder = pipeTile.getCoverableImplementation();
        boolean usingGrid = this.hasPipeCollisionChangingItem(world, pos, entityIn);
        if (usingGrid) {
            result.add(MetaTileEntity.FULL_CUBE_COLLISION);
        }
        result.add(new IndexedCuboid6((Object)new CoverRayTracer.PrimaryBoxData(usingGrid), BlockPipe.getSideBox(null, thickness)));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if ((actualConnections & 1 << side.func_176745_a()) <= 0) continue;
            result.add(new IndexedCuboid6((Object)new PipeConnectionData(side), BlockPipe.getSideBox(side, thickness)));
        }
        coverHolder.addCoverCollisionBoundingBox(result);
        return result;
    }

    public boolean hasPipeCollisionChangingItem(IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.hasPipeCollisionChangingItem(world, pos, ((EntityPlayer)entity).func_184586_b(EnumHand.MAIN_HAND)) || this.hasPipeCollisionChangingItem(world, pos, ((EntityPlayer)entity).func_184586_b(EnumHand.OFF_HAND)) || entity.func_70093_af() && this.isHoldingPipe((EntityPlayer)entity);
        }
        return false;
    }

    public abstract boolean isHoldingPipe(EntityPlayer var1);

    public boolean hasPipeCollisionChangingItem(IBlockAccess world, BlockPos pos, ItemStack stack) {
        if (this.isPipeTool(stack)) {
            return true;
        }
        IPipeTile<PipeType, NodeDataType> pipeTile = this.getPipeTileEntity(world, pos);
        if (pipeTile == null) {
            return false;
        }
        PipeCoverableImplementation coverable = pipeTile.getCoverableImplementation();
        boolean hasAnyCover = coverable.hasAnyCover();
        if (hasAnyCover && ToolHelper.isTool(stack, "screwdriver")) {
            return true;
        }
        boolean acceptsCovers = coverable.acceptsCovers();
        return GTUtility.isCoverBehaviorItem(stack, () -> hasAnyCover, coverDef -> acceptsCovers);
    }

    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        return true;
    }

    @Override
    @NotNull
    public IBlockState getFacade(@NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable EnumFacing side, @NotNull BlockPos otherPos) {
        return this.getFacade(world, pos, side);
    }

    @Override
    @NotNull
    public IBlockState getFacade(@NotNull IBlockAccess world, @NotNull BlockPos pos, EnumFacing side) {
        Cover cover;
        IPipeTile<PipeType, NodeDataType> pipeTileEntity = this.getPipeTileEntity(world, pos);
        if (pipeTileEntity != null && side != null && (cover = pipeTileEntity.getCoverableImplementation().getCoverAtSide(side)) instanceof IFacadeCover) {
            return ((IFacadeCover)((Object)cover)).getVisualState();
        }
        return world.func_180495_p(pos);
    }

    @Override
    @NotNull
    public IBlockState getVisualState(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        return this.getFacade(world, pos, side);
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }

    public static class PipeConnectionData {
        public final EnumFacing side;

        public PipeConnectionData(EnumFacing side) {
            this.side = side;
        }
    }
}

