/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.RelativeDirection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

public class MultiblockShapeInfo {
    private final BlockInfo[][][] blocks;

    public MultiblockShapeInfo(BlockInfo[][][] blocks) {
        this.blocks = blocks;
    }

    public BlockInfo[][][] getBlocks() {
        return this.blocks;
    }

    public static Builder builder() {
        return MultiblockShapeInfo.builder(RelativeDirection.RIGHT, RelativeDirection.DOWN, RelativeDirection.BACK);
    }

    public static Builder builder(RelativeDirection ... structureDir) {
        if (structureDir.length != 3) {
            throw new IllegalArgumentException("Must have exactly 3 directions!");
        }
        return new Builder(structureDir[0], structureDir[1], structureDir[2]);
    }

    public static class Builder {
        private final RelativeDirection[] structureDir = new RelativeDirection[3];
        private List<String[]> shape = new ArrayList<String[]>();
        private Map<Character, BlockInfo> symbolMap = new HashMap<Character, BlockInfo>();

        @Deprecated
        public Builder(RelativeDirection ... structureDir) {
            this(structureDir[0], structureDir[1], structureDir[2]);
        }

        @Deprecated
        public Builder(@NotNull RelativeDirection one, @NotNull RelativeDirection two, @NotNull RelativeDirection three) {
            this.structureDir[0] = Objects.requireNonNull(one);
            this.structureDir[1] = Objects.requireNonNull(two);
            this.structureDir[2] = Objects.requireNonNull(three);
            int flags = 0;
            block5: for (int i = 0; i < this.structureDir.length; ++i) {
                switch (this.structureDir[i]) {
                    case UP: 
                    case DOWN: {
                        flags |= 1;
                        continue block5;
                    }
                    case LEFT: 
                    case RIGHT: {
                        flags |= 2;
                        continue block5;
                    }
                    case FRONT: 
                    case BACK: {
                        flags |= 4;
                    }
                }
            }
            if (flags != 7) {
                throw new IllegalArgumentException("The directions must be on different axes!");
            }
        }

        public Builder aisle(String ... data) {
            this.shape.add(data);
            return this;
        }

        public Builder where(char symbol, BlockInfo value) {
            this.symbolMap.put(Character.valueOf(symbol), value);
            return this;
        }

        public Builder where(char symbol, IBlockState blockState) {
            return this.where(symbol, new BlockInfo(blockState));
        }

        public Builder where(char symbol, IBlockState blockState, TileEntity tileEntity) {
            return this.where(symbol, new BlockInfo(blockState, tileEntity));
        }

        public Builder where(char symbol, MetaTileEntity tileEntity, EnumFacing frontSide) {
            MetaTileEntityHolder holder = new MetaTileEntityHolder();
            holder.setMetaTileEntity(tileEntity);
            holder.getMetaTileEntity().onPlacement();
            holder.getMetaTileEntity().setFrontFacing(frontSide);
            return this.where(symbol, new BlockInfo(tileEntity.getBlock().func_176223_P(), holder));
        }

        public Builder where(char symbol, Supplier<?> partSupplier, EnumFacing frontSideIfTE) {
            Object part = partSupplier.get();
            if (part instanceof IBlockState) {
                return this.where(symbol, (IBlockState)part);
            }
            if (part instanceof MetaTileEntity) {
                return this.where(symbol, (MetaTileEntity)part, frontSideIfTE);
            }
            throw new IllegalArgumentException("Supplier must supply either a MetaTileEntity or an IBlockState! Actual: " + part.getClass());
        }

        @NotNull
        private BlockInfo[][][] bakeArray() {
            int maxZ = this.shape.size();
            int maxY = this.shape.get(0).length;
            int maxX = this.shape.get(0)[0].length();
            BlockPos end = RelativeDirection.setActualRelativeOffset(maxX, maxY, maxZ, EnumFacing.SOUTH, EnumFacing.UP, true, this.structureDir);
            BlockPos addition = new BlockPos(end.func_177958_n() < 0 ? -end.func_177958_n() - 1 : 0, end.func_177956_o() < 0 ? -end.func_177956_o() - 1 : 0, end.func_177952_p() < 0 ? -end.func_177952_p() - 1 : 0);
            BlockPos bound = new BlockPos(Math.abs(end.func_177958_n()), Math.abs(end.func_177956_o()), Math.abs(end.func_177952_p()));
            BlockInfo[][][] blockInfos = new BlockInfo[bound.func_177958_n()][bound.func_177956_o()][bound.func_177952_p()];
            for (int z = 0; z < maxZ; ++z) {
                String[] aisleEntry = this.shape.get(z);
                for (int y = 0; y < maxY; ++y) {
                    String columnEntry = aisleEntry[y];
                    for (int x = 0; x < maxX; ++x) {
                        BlockInfo info = this.symbolMap.getOrDefault(Character.valueOf(columnEntry.charAt(x)), BlockInfo.EMPTY);
                        TileEntity tileEntity = info.getTileEntity();
                        if (tileEntity instanceof MetaTileEntityHolder) {
                            MetaTileEntityHolder holder = (MetaTileEntityHolder)tileEntity;
                            MetaTileEntity mte = holder.getMetaTileEntity();
                            holder = new MetaTileEntityHolder();
                            holder.setMetaTileEntity(mte);
                            holder.getMetaTileEntity().onPlacement();
                            holder.getMetaTileEntity().setFrontFacing(mte.getFrontFacing());
                            info = new BlockInfo(info.getBlockState(), holder);
                        } else if (tileEntity != null) {
                            info = new BlockInfo(info.getBlockState(), tileEntity);
                        }
                        BlockPos pos = RelativeDirection.setActualRelativeOffset(x, y, z, EnumFacing.SOUTH, EnumFacing.UP, true, this.structureDir).func_177971_a((Vec3i)addition);
                        blockInfos[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = info;
                    }
                }
            }
            return blockInfos;
        }

        public Builder shallowCopy() {
            Builder builder = new Builder(this.structureDir);
            builder.shape = new ArrayList<String[]>(this.shape);
            builder.symbolMap = new HashMap<Character, BlockInfo>(this.symbolMap);
            return builder;
        }

        public MultiblockShapeInfo build() {
            return new MultiblockShapeInfo(this.bakeArray());
        }
    }
}

