/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.network;

import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

public class PacketDataList {
    private int[] discriminators = new int[4];
    private byte[][] data = new byte[4][];
    private int size = 0;

    private void ensureSize(int s) {
        if (this.discriminators.length < s) {
            int n = this.discriminators.length;
            int newCapacity = Math.max(n + 2, s);
            int[] temp = new int[newCapacity];
            byte[][] temp2 = new byte[newCapacity][];
            System.arraycopy(this.discriminators, 0, temp, 0, n);
            System.arraycopy(this.data, 0, temp2, 0, n);
            this.discriminators = temp;
            this.data = temp2;
        }
    }

    public void add(int discriminator, byte[] data) {
        this.ensureSize(this.size + 1);
        this.discriminators[this.size] = discriminator;
        this.data[this.size] = data;
        ++this.size;
    }

    public void addAll(PacketDataList dataList) {
        this.ensureSize(this.size + dataList.size);
        System.arraycopy(dataList.discriminators, 0, this.discriminators, this.size, dataList.size);
        System.arraycopy(dataList.data, 0, this.data, this.size, dataList.size);
        this.size += dataList.size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.discriminators, 0);
        Arrays.fill((Object[])this.data, null);
        this.size = 0;
    }

    @NotNull
    public NBTTagList dumpToNbt() {
        NBTTagList listTag = new NBTTagList();
        for (int i = 0; i < this.size; ++i) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74773_a(Integer.toString(this.discriminators[i]), this.data[i]);
            listTag.func_74742_a((NBTBase)entryTag);
            this.data[i] = null;
        }
        this.size = 0;
        return listTag;
    }
}

