/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui.widget;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.layout.Grid;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.client.utils.TooltipHelper;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GhostCircuitSlotWidget
extends ItemSlot {
    private static final int SYNC_CIRCUIT_INDEX = 10;
    @Nullable
    private IPanelHandler selectorPanel;
    private GhostCircuitSyncHandler syncHandler;

    public GhostCircuitSlotWidget() {
        this.tooltipBuilder(this::getCircuitSlotTooltip);
    }

    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (!this.isSelectorPanelOpen()) {
            if (mouseButton == 0 && TooltipHelper.isShiftDown()) {
                this.getSelectorPanel().openPanel();
            } else {
                MouseData mouseData = MouseData.create((int)mouseButton);
                this.getSyncHandler().syncToServer(2, arg_0 -> ((MouseData)mouseData).writeToPacket(arg_0));
            }
        }
        return Interactable.Result.SUCCESS;
    }

    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.isSelectorPanelOpen()) {
            return true;
        }
        MouseData mouseData = MouseData.create((int)scrollDirection.modifier);
        this.getSyncHandler().syncToServer(3, arg_0 -> ((MouseData)mouseData).writeToPacket(arg_0));
        return true;
    }

    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        this.syncHandler = (GhostCircuitSyncHandler)((Object)this.castIfTypeElseNull(syncHandler, GhostCircuitSyncHandler.class));
        if (this.syncHandler == null) {
            return false;
        }
        return super.isValidSyncHandler(syncHandler);
    }

    public ItemSlot slot(ModularSlot slot) {
        this.syncHandler = new GhostCircuitSyncHandler(slot);
        this.isValidSyncHandler((SyncHandler)this.syncHandler);
        this.setSyncHandler((SyncHandler)this.syncHandler);
        return this;
    }

    protected void getCircuitSlotTooltip(@NotNull RichTooltip tooltip) {
        int value = this.syncHandler.getCircuitValue();
        String configString = value == -1 ? IKey.lang((String)"gregtech.gui.configurator_slot.no_value").get() : String.valueOf(value);
        tooltip.clearText();
        tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.gui.configurator_slot.tooltip", (Object[])new Object[]{configString}));
    }

    public void onMouseDrag(int mouseButton, long timeSinceClick) {
    }

    public boolean onMouseRelease(int mouseButton) {
        return true;
    }

    private boolean isSelectorPanelOpen() {
        return this.getSelectorPanel().isPanelOpen();
    }

    @NotNull
    private IPanelHandler getSelectorPanel() {
        if (this.selectorPanel == null) {
            this.selectorPanel = IPanelHandler.simple((ModularPanel)this.getPanel(), (mainPanel, player) -> {
                ItemDrawable circuitPreview = new ItemDrawable(this.syncHandler.getCircuitStack());
                return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPopupPanel("circuit_selector", 176, 120).child((IWidget)IKey.lang((String)"metaitem.circuit.integrated.gui").asWidget().pos(5, 5))).child((IWidget)((Widget)((Widget)((Widget)new Widget().size(18)).top(19)).alignX(0.5f)).overlay(new IDrawable[]{circuitPreview.asIcon().margin(1)}).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.INT_CIRCUIT_OVERLAY}))).child((IWidget)((Grid)((Grid)((Grid)((Grid)new Grid().left(7)).right(7)).top(41)).height(72)).mapTo(9, 33, value -> ((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18)).background(new IDrawable[]{GTGuiTextures.SLOT, new ItemDrawable(IntCircuitIngredient.getIntegratedCircuit(value)).asIcon()})).disableHoverBackground()).onMousePressed(mouseButton -> {
                    this.getSyncHandler().syncToServer(10, buf -> buf.writeShort(value));
                    circuitPreview.setItem(IntCircuitIngredient.getIntegratedCircuit(value));
                    if (Interactable.hasShiftDown()) {
                        this.selectorPanel.closePanel();
                    }
                    return true;
                })).minColWidth(18).minRowHeight(18).minElementMargin(0, 0));
            }, (boolean)true);
        }
        return this.selectorPanel;
    }

    private static class GhostCircuitSyncHandler
    extends ItemSlotSH {
        public GhostCircuitSyncHandler(ModularSlot slot) {
            super(slot);
        }

        protected void phantomClick(MouseData mouseData) {
            if (mouseData.mouseButton == 0) {
                this.setCircuitValue(this.getNextCircuitValue(1));
            } else if (mouseData.mouseButton == 1 && mouseData.shift) {
                this.setCircuitValue(-1);
            } else if (mouseData.mouseButton == 1) {
                this.setCircuitValue(this.getNextCircuitValue(-1));
            }
        }

        protected void phantomScroll(MouseData mouseData) {
            this.setCircuitValue(this.getNextCircuitValue(mouseData.mouseButton));
        }

        private void setCircuitValue(int value) {
            GhostCircuitItemStackHandler handler = this.getGhostCircuitHandler();
            if (handler.getCircuitValue() != value) {
                handler.setCircuitValue(value);
                this.syncToClient(1, buf -> {
                    buf.writeBoolean(false);
                    buf.func_150788_a(handler.getStackInSlot(0));
                    buf.writeBoolean(false);
                });
            }
        }

        public int getCircuitValue() {
            return this.getGhostCircuitHandler().getCircuitValue();
        }

        public ItemStack getCircuitStack() {
            return this.getSlot().func_75211_c();
        }

        public void readOnServer(int id, PacketBuffer buf) throws IOException {
            if (id == 10) {
                this.setCircuitValue(buf.readShort());
            } else {
                super.readOnServer(id, buf);
            }
        }

        private int getNextCircuitValue(int delta) {
            GhostCircuitItemStackHandler handler = this.getGhostCircuitHandler();
            if (!handler.hasCircuitValue()) {
                return delta == 1 ? 1 : 32;
            }
            if (handler.getCircuitValue() + delta > 32) {
                return -1;
            }
            if (handler.getCircuitValue() + delta < 1) {
                return -1;
            }
            return handler.getCircuitValue() + delta;
        }

        public GhostCircuitItemStackHandler getGhostCircuitHandler() {
            IItemHandler handler = this.getSlot().getItemHandler();
            if (!(handler instanceof GhostCircuitItemStackHandler)) {
                throw new IllegalStateException("GhostCircuitSyncHandler has IItemHandler that is not GhostCircuitItemStackHandler");
            }
            GhostCircuitItemStackHandler ghostHandler = (GhostCircuitItemStackHandler)handler;
            return ghostHandler;
        }
    }
}

