/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui.sync;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.utils.BooleanConsumer;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.common.covers.filter.readers.SimpleFluidFilterReader;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTFluidSyncHandler
extends SyncHandler {
    public static final int TRY_CLICK_CONTAINER = 1;
    public static final int UPDATE_TANK = 2;
    public static final int UPDATE_AMOUNT = 3;
    public static final int PHANTOM_SCROLL = 4;
    public static final int LOCK_FLUID = 5;
    private final IFluidTank tank;
    private Consumer<FluidStack> jeiHandler;
    private BooleanConsumer lockHandler;
    private Supplier<FluidStack> lockedFluid;
    private FluidStack lastFluid;
    private FluidStack phantomFluid;
    private boolean canDrainSlot = true;
    private boolean canFillSlot = true;
    private boolean phantom;
    private BooleanSupplier showAmountInTooltip = () -> true;
    private BooleanSupplier showAmountOnSlot = () -> true;
    private BooleanSupplier drawAlwaysFull = () -> true;

    public GTFluidSyncHandler(IFluidTank tank) {
        this.tank = tank;
    }

    public void detectAndSendChanges(boolean init) {
        FluidStack current = this.getFluid();
        if (init || current == null || this.lastFluid == null || current.isFluidEqual(this.lastFluid)) {
            this.lastFluid = current == null ? null : current.copy();
            this.syncToClient(2, buffer -> NetworkUtils.writeFluidStack((PacketBuffer)buffer, (FluidStack)current));
        } else if (this.lastFluid != null && current.amount != this.lastFluid.amount) {
            this.lastFluid.amount = current.amount;
            this.syncToClient(3, buffer -> buffer.writeInt(current.amount));
        }
    }

    public void lockFluid(FluidStack stack, boolean sync) {
        if (!this.canLockFluid()) {
            return;
        }
        this.jeiHandler.accept(stack);
        if (sync) {
            this.sync(5, buffer -> {
                buffer.writeBoolean(stack != null);
                NetworkUtils.writeFluidStack((PacketBuffer)buffer, (FluidStack)stack);
            });
        }
    }

    public void lockFluid(boolean locked, boolean sync) {
        this.lockHandler.accept(locked);
        if (sync) {
            this.sync(5, buffer -> {
                buffer.writeBoolean(locked);
                NetworkUtils.writeFluidStack((PacketBuffer)buffer, null);
            });
        }
    }

    public GTFluidSyncHandler handleLocking(Supplier<FluidStack> lockedFluid, Consumer<FluidStack> jeiHandler, BooleanConsumer lockHandler) {
        this.lockedFluid = lockedFluid;
        this.jeiHandler = jeiHandler;
        this.lockHandler = lockHandler;
        return this;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public void setFluid(FluidStack fluid) {
        IFluidTank iFluidTank = this.tank;
        if (iFluidTank instanceof FluidTank) {
            FluidTank fluidTank = (FluidTank)iFluidTank;
            fluidTank.setFluid(fluid);
        } else {
            this.tank.drain(Integer.MAX_VALUE, true);
            if (fluid != null) {
                this.tank.fill(fluid, true);
            }
        }
        if (!this.isPhantom() || fluid == null) {
            return;
        }
        if (this.phantomFluid == null || this.phantomFluid.getFluid() != fluid.getFluid()) {
            this.phantomFluid = fluid;
        }
    }

    public void setAmount(int amount) {
        IFluidTank iFluidTank = this.tank;
        if (iFluidTank instanceof SimpleFluidFilterReader.WritableFluidTank) {
            SimpleFluidFilterReader.WritableFluidTank writableFluidTank = (SimpleFluidFilterReader.WritableFluidTank)iFluidTank;
            writableFluidTank.setFluidAmount(amount);
            return;
        }
        FluidStack stack = this.getFluid();
        if (stack == null) {
            return;
        }
        stack.amount = amount;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public GTFluidSyncHandler accessibility(boolean canDrain, boolean canFill) {
        this.canDrainSlot = canDrain;
        this.canFillSlot = canFill;
        return this;
    }

    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    public GTFluidSyncHandler phantom(boolean phantom) {
        this.phantom = phantom;
        if (phantom && this.tank.getFluid() != null) {
            this.phantomFluid = this.tank.getFluid().copy();
        }
        return this;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public GTFluidSyncHandler showAmountInTooltip(boolean showAmount) {
        this.showAmountInTooltip = () -> showAmount;
        return this;
    }

    public GTFluidSyncHandler showAmountInTooltip(BooleanSupplier showAmount) {
        this.showAmountInTooltip = showAmount;
        return this;
    }

    public boolean showAmountInTooltip() {
        if (!this.isPhantom() && this.phantomFluid != null) {
            return false;
        }
        return this.showAmountInTooltip.getAsBoolean();
    }

    public GTFluidSyncHandler showAmountOnSlot(boolean showAmount) {
        this.showAmountOnSlot = () -> showAmount;
        return this;
    }

    public GTFluidSyncHandler showAmountOnSlot(BooleanSupplier showAmount) {
        this.showAmountOnSlot = showAmount;
        return this;
    }

    public boolean showAmountOnSlot() {
        if (!this.isPhantom() && this.phantomFluid != null) {
            return false;
        }
        return this.showAmountOnSlot.getAsBoolean();
    }

    public GTFluidSyncHandler drawAlwaysFull(boolean drawAsFull) {
        this.drawAlwaysFull = () -> drawAsFull;
        return this;
    }

    public GTFluidSyncHandler drawAlwaysFull(BooleanSupplier drawAsFull) {
        this.drawAlwaysFull = drawAsFull;
        return this;
    }

    public boolean drawAlwaysFull() {
        return this.drawAlwaysFull.getAsBoolean();
    }

    @NotNull
    public String getFormattedFluidAmount() {
        FluidStack tankFluid = this.tank.getFluid();
        return String.format("%,d", tankFluid == null ? 0 : tankFluid.amount);
    }

    public int getFluidAmount() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid == null ? 0 : tankFluid.amount;
    }

    @Nullable
    public String getFluidLocalizedName() {
        FluidStack tankFluid = this.tank.getFluid();
        if (tankFluid == null && this.canLockFluid()) {
            tankFluid = this.lockedFluid.get();
        }
        return tankFluid == null ? null : tankFluid.getLocalizedName();
    }

    @NotNull
    public IKey getFluidNameKey() {
        FluidStack tankFluid = this.tank.getFluid();
        if (tankFluid == null && this.canLockFluid()) {
            tankFluid = this.lockedFluid.get();
        }
        return tankFluid == null ? IKey.EMPTY : KeyUtil.fluid(tankFluid);
    }

    public void handleTooltip(@NotNull RichTooltip tooltip) {
        FluidStack tankFluid;
        tooltip.addLine((IDrawable)this.getFluidNameKey());
        if (this.showAmountInTooltip()) {
            tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.fluid.amount", (Object[])new Object[]{this.getFluidAmount(), this.getCapacity()}));
        }
        if (this.isPhantom() && this.showAmountInTooltip()) {
            tooltip.addLine((IDrawable)IKey.lang((String)"modularui.fluid.phantom.control"));
        }
        if ((tankFluid = this.getFluid()) == null) {
            tankFluid = this.getLockedFluid();
        }
        if (tankFluid != null) {
            FluidTooltipUtil.handleFluidTooltip(tooltip, tankFluid);
            if (this.showAmountInTooltip()) {
                FluidTooltipUtil.addIngotMolFluidTooltip(tooltip, tankFluid);
            }
        }
    }

    public void readOnClient(int id, PacketBuffer buf) {
        switch (id) {
            case 1: {
                this.replaceCursorItemStack(NetworkUtils.readItemStack((PacketBuffer)buf));
                break;
            }
            case 2: {
                this.setFluid(NetworkUtils.readFluidStack((PacketBuffer)buf));
                break;
            }
            case 3: {
                this.setAmount(buf.readInt());
                break;
            }
            case 5: {
                this.lockFluid(NetworkUtils.readFluidStack((PacketBuffer)buf), false);
            }
        }
    }

    public void handlePhantomScroll(MouseData data) {
        this.syncToServer(4, arg_0 -> ((MouseData)data).writeToPacket(arg_0));
    }

    public void handleClick(MouseData data) {
        this.syncToServer(1, arg_0 -> ((MouseData)data).writeToPacket(arg_0));
    }

    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 1) {
            MouseData data = MouseData.readPacket((PacketBuffer)buf);
            if (this.isPhantom()) {
                this.tryClickPhantom(data);
            } else {
                ItemStack stack = this.tryClickContainer(data.mouseButton == 0);
                if (!stack.func_190926_b()) {
                    this.syncToClient(1, buffer -> NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)stack));
                }
            }
        } else if (id == 2) {
            FluidStack fluid = NetworkUtils.readFluidStack((PacketBuffer)buf);
            this.setFluid(fluid);
        } else if (id == 4) {
            this.tryScrollPhantom(MouseData.readPacket((PacketBuffer)buf));
        } else if (id == 5) {
            boolean locked = buf.readBoolean();
            FluidStack fluidStack = NetworkUtils.readFluidStack((PacketBuffer)buf);
            if (fluidStack == null) {
                this.lockHandler.accept(locked);
            } else {
                this.jeiHandler.accept(fluidStack);
            }
        }
    }

    public void tryClickPhantom(MouseData data) {
        EntityPlayer player = this.getSyncManager().getPlayer();
        ItemStack currentStack = player.field_71071_by.func_70445_o();
        FluidStack currentFluid = this.tank.getFluid();
        if (currentStack.func_190916_E() > 1) {
            currentStack = GTUtility.copy(1, currentStack);
        }
        IFluidHandlerItem fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)currentStack);
        switch (data.mouseButton) {
            case 0: {
                if (currentStack.func_190926_b() || fluidHandlerItem == null) {
                    if (!this.canDrainSlot()) break;
                    this.tank.drain(data.shift ? Integer.MAX_VALUE : 1000, true);
                    break;
                }
                FluidStack cellFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
                if ((this.showAmountOnSlot.getAsBoolean() || currentFluid == null) && cellFluid != null) {
                    if (!this.canFillSlot()) break;
                    if (!this.showAmountOnSlot.getAsBoolean()) {
                        cellFluid.amount = 1;
                    }
                    if (this.tank.fill(cellFluid, true) <= 0) break;
                    this.phantomFluid = cellFluid.copy();
                    break;
                }
                if (!this.canDrainSlot()) break;
                this.tank.drain(data.shift ? Integer.MAX_VALUE : 1000, true);
                break;
            }
            case 1: {
                if (!this.canFillSlot()) break;
                if (currentFluid != null) {
                    if (!this.showAmountOnSlot.getAsBoolean()) break;
                    FluidStack toFill = currentFluid.copy();
                    toFill.amount = 1000;
                    this.tank.fill(toFill, true);
                    break;
                }
                if (this.phantomFluid == null) break;
                FluidStack toFill = this.phantomFluid.copy();
                toFill.amount = this.showAmountOnSlot.getAsBoolean() ? 1 : toFill.amount;
                this.tank.fill(toFill, true);
                break;
            }
            case 2: {
                if (currentFluid == null || !this.canDrainSlot()) break;
                this.tank.drain(data.shift ? Integer.MAX_VALUE : 1000, true);
            }
        }
    }

    public void tryScrollPhantom(MouseData mouseData) {
        FluidStack currentFluid = this.tank.getFluid();
        int amount = mouseData.mouseButton;
        if (!this.showAmountOnSlot()) {
            int newAmt;
            int n = newAmt = amount == 1 ? 1 : 0;
            if (newAmt == 0) {
                this.setFluid(null);
            } else if (currentFluid != null && currentFluid.amount != newAmt) {
                this.setAmount(newAmt);
            }
            return;
        }
        if (mouseData.shift) {
            amount *= 10;
        }
        if (mouseData.ctrl) {
            amount *= 100;
        }
        if (mouseData.alt) {
            amount *= 1000;
        }
        if (currentFluid == null) {
            if (amount > 0 && this.phantomFluid != null) {
                FluidStack toFill = this.phantomFluid.copy();
                toFill.amount = this.showAmountOnSlot() ? amount : 1;
                this.tank.fill(toFill, true);
            }
            return;
        }
        if (amount > 0) {
            FluidStack toFill = currentFluid.copy();
            toFill.amount = amount;
            this.tank.fill(toFill, true);
        } else if (amount < 0) {
            this.tank.drain(-amount, true);
        }
    }

    public ItemStack tryClickContainer(boolean tryFillAll) {
        ItemStack playerHeldStack = this.getSyncManager().getCursorItem();
        if (playerHeldStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack useStack = GTUtility.copy(1, playerHeldStack);
        IFluidHandlerItem fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)useStack);
        if (fluidHandlerItem == null) {
            return ItemStack.field_190927_a;
        }
        FluidStack tankFluid = this.tank.getFluid();
        FluidStack heldFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
        if (tankFluid == null && heldFluid == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnable = ItemStack.field_190927_a;
        if (this.canFillSlot && tankFluid == null) {
            returnable = this.fillTankFromStack(fluidHandlerItem, heldFluid, tryFillAll);
        } else if (this.canDrainSlot && heldFluid == null) {
            returnable = this.drainTankIntoStack(fluidHandlerItem, tankFluid, tryFillAll);
        } else if (this.canFillSlot && this.tank.getFluidAmount() < this.tank.getCapacity() && heldFluid != null) {
            returnable = this.fillTankFromStack(fluidHandlerItem, heldFluid, tryFillAll);
        }
        this.syncToClient(2, buffer -> NetworkUtils.writeFluidStack((PacketBuffer)buffer, (FluidStack)this.tank.getFluid()));
        return returnable;
    }

    private ItemStack fillTankFromStack(IFluidHandlerItem fluidHandler, @NotNull FluidStack heldFluid, boolean tryFillAll) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        FluidStack currentFluid = this.tank.getFluid();
        if (currentFluid != null && !currentFluid.isFluidEqual(heldFluid)) {
            return ItemStack.field_190927_a;
        }
        int freeSpace = this.tank.getCapacity() - this.tank.getFluidAmount();
        if (freeSpace <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStackEmptied = ItemStack.field_190927_a;
        int fluidAmountTaken = 0;
        FluidStack drained = fluidHandler.drain(freeSpace, true);
        if (drained != null && drained.amount > 0) {
            itemStackEmptied = fluidHandler.getContainer();
            fluidAmountTaken = drained.amount;
        }
        if (itemStackEmptied == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        int additional = tryFillAll ? Math.min(freeSpace / fluidAmountTaken, heldItem.func_190916_E()) : 1;
        FluidStack copiedFluidStack = heldFluid.copy();
        copiedFluidStack.amount = fluidAmountTaken * additional;
        this.tank.fill(copiedFluidStack, true);
        itemStackEmptied.func_190920_e(additional);
        this.replaceCursorItemStack(itemStackEmptied);
        this.playSound(heldFluid, true);
        return itemStackEmptied;
    }

    private ItemStack drainTankIntoStack(IFluidHandlerItem fluidHandler, FluidStack tankFluid, boolean tryFillAll) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack fluidContainer = ItemStack.field_190927_a;
        int filled = fluidHandler.fill(tankFluid, false);
        int stored = tankFluid.amount;
        if (filled > 0) {
            fluidHandler.fill(tankFluid, true);
            this.tank.drain(filled, true);
            fluidContainer = fluidHandler.getContainer();
            if (tryFillAll) {
                int additional = Math.min(heldItem.func_190916_E(), stored / filled) - 1;
                this.tank.drain(filled * additional, true);
                fluidContainer.func_190917_f(additional);
            }
            this.replaceCursorItemStack(fluidContainer);
            this.playSound(tankFluid, false);
        }
        return fluidContainer;
    }

    private void replaceCursorItemStack(ItemStack resultStack) {
        int resultStackSize = resultStack.func_77976_d();
        ItemStack playerStack = this.getSyncManager().getCursorItem();
        if (!this.getSyncManager().isClient()) {
            this.syncToClient(1, buffer -> NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)resultStack));
        }
        while (resultStack.func_190916_E() > resultStackSize) {
            playerStack.func_190918_g(resultStackSize);
            this.addItemToPlayerInventory(resultStack.func_77979_a(resultStackSize));
        }
        if (playerStack.func_190916_E() == resultStack.func_190916_E()) {
            this.getSyncManager().setCursorItem(resultStack);
        } else {
            playerStack.func_190918_g(resultStack.func_190916_E());
            this.getSyncManager().setCursorItem(playerStack);
            this.addItemToPlayerInventory(resultStack);
        }
    }

    private void addItemToPlayerInventory(ItemStack stack) {
        EntityItem dropItem;
        if (stack == null) {
            return;
        }
        EntityPlayer player = this.getSyncManager().getPlayer();
        if (!player.field_71071_by.func_70441_a(stack) && !player.field_70170_p.field_72995_K && (dropItem = player.func_70099_a(stack, 0.0f)) != null) {
            dropItem.func_174867_a(0);
        }
    }

    private void playSound(FluidStack fluid, boolean fill) {
        if (fluid == null) {
            return;
        }
        SoundEvent soundEvent = fill ? fluid.getFluid().getFillSound(fluid) : fluid.getFluid().getEmptySound(fluid);
        EntityPlayer player = this.getSyncManager().getPlayer();
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundEvent, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public FluidStack getPhantomFluid() {
        return this.isPhantom() ? this.phantomFluid : null;
    }

    public FluidStack getLockedFluid() {
        return !this.isPhantom() && this.canLockFluid() ? this.lockedFluid.get() : null;
    }

    public boolean canLockFluid() {
        return this.jeiHandler != null && this.lockHandler != null && this.lockedFluid != null;
    }

    public void toggleLockFluid() {
        ItemStack cursorItem = this.getSyncManager().getCursorItem();
        if (this.getLockedFluid() == null) {
            IFluidHandlerItem fluidHandler;
            if (cursorItem.func_190926_b()) {
                return;
            }
            if (cursorItem.func_190916_E() > 1) {
                cursorItem = GTUtility.copy(1, cursorItem);
            }
            if ((fluidHandler = FluidUtil.getFluidHandler((ItemStack)cursorItem)) == null) {
                return;
            }
            FluidStack fluidStack = fluidHandler.getTankProperties()[0].getContents();
            if (fluidStack == null) {
                return;
            }
            this.lockFluid(fluidStack.copy(), true);
        } else if (cursorItem.func_190926_b()) {
            this.lockFluid(null, true);
        }
    }
}

