/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui.sync;

import com.cleanroommc.modularui.api.value.sync.IStringSyncValue;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigIntegerSyncValue
extends ValueSyncHandler<BigInteger>
implements IStringSyncValue<BigInteger> {
    private BigInteger cache = BigInteger.ZERO;
    private final Supplier<BigInteger> getter;
    @Nullable
    private final Consumer<BigInteger> setter;

    public BigIntegerSyncValue(@NotNull @NotNull Supplier<@NotNull BigInteger> getter, @Nullable Consumer<@NotNull BigInteger> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Contract(value="null, _, null, _ -> fail")
    public BigIntegerSyncValue(@Nullable Supplier<@NotNull BigInteger> clientGetter, @Nullable Consumer<@NotNull BigInteger> clientSetter, @Nullable Supplier<@NotNull BigInteger> serverGetter, @Nullable Consumer<@NotNull BigInteger> serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (NetworkUtils.isClient()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.get();
    }

    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.setValue(new BigInteger(value), setSource, sync);
    }

    public String getStringValue() {
        return this.cache.toString();
    }

    public void setValue(BigInteger value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        if (sync) {
            this.sync(0, this::write);
        }
    }

    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (this.getter != null && (isFirstSync || !Objects.equals(this.getter.get(), this.cache))) {
            this.setValue(this.getter.get(), false, false);
            return true;
        }
        return false;
    }

    public void write(@NotNull PacketBuffer buffer) throws IOException {
        buffer.func_179250_a(this.getValue().toByteArray());
    }

    public void read(@NotNull PacketBuffer buffer) throws IOException {
        this.setValue(new BigInteger(buffer.func_179251_a()), true, false);
    }

    public BigInteger getValue() {
        return this.cache;
    }
}

