/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.HandGuiData;
import gregtech.api.items.metaitem.MetaItem;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import org.jetbrains.annotations.NotNull;

public class MetaItemGuiFactory
extends AbstractUIFactory<HandGuiData> {
    public static final MetaItemGuiFactory INSTANCE = new MetaItemGuiFactory();

    private MetaItemGuiFactory() {
        super("gregtech:meta_item");
    }

    public static void open(EntityPlayer player, EnumHand hand) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(hand);
        HandGuiData guiData = new HandGuiData(player, hand);
        GuiManager.open((UIFactory)INSTANCE, (GuiData)guiData, (EntityPlayerMP)((EntityPlayerMP)player));
    }

    @NotNull
    public IGuiHolder<HandGuiData> getGuiHolder(HandGuiData data) {
        ItemStack stack = data.getUsedItemStack();
        Item item = stack.func_77973_b();
        if (!(item instanceof MetaItem)) {
            throw new IllegalArgumentException("Found item is not a valid MetaItem!");
        }
        MetaItem metaItem = (MetaItem)item;
        Object valueItem = metaItem.getItem(stack);
        if (valueItem == null || ((MetaItem.MetaValueItem)valueItem).getUIManager() == null) {
            throw new IllegalArgumentException("Found MetaItem is not a gui holder!");
        }
        return ((MetaItem.MetaValueItem)valueItem).getUIManager();
    }

    public void writeGuiData(HandGuiData guiData, PacketBuffer buffer) {
        buffer.writeByte(guiData.getHand().ordinal());
    }

    @NotNull
    public HandGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new HandGuiData(player, EnumHand.values()[buffer.readByte()]);
    }
}

