/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.cover.CoverWithUI;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class CoverGuiFactory
extends AbstractUIFactory<SidedPosGuiData> {
    public static final CoverGuiFactory INSTANCE = new CoverGuiFactory();

    private CoverGuiFactory() {
        super("gregtech:cover");
    }

    public static <T extends Cover & IGuiHolder<SidedPosGuiData>> void open(EntityPlayer player, T cover) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(cover);
        if (!cover.getCoverableView().isValid()) {
            throw new IllegalArgumentException("Can't open Cover GUI on invalid cover holder!");
        }
        if (player.field_70170_p != cover.getWorld()) {
            throw new IllegalArgumentException("Cover must be in same dimension as the player!");
        }
        BlockPos pos = cover.getPos();
        SidedPosGuiData data = new SidedPosGuiData(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), cover.getAttachedSide());
        GuiManager.open((UIFactory)INSTANCE, (GuiData)data, (EntityPlayerMP)((EntityPlayerMP)player));
    }

    @NotNull
    public IGuiHolder<SidedPosGuiData> getGuiHolder(SidedPosGuiData data) {
        TileEntity te = data.getTileEntity();
        if (te == null) {
            throw new IllegalStateException("Could not get gui for null TileEntity!");
        }
        CoverHolder coverHolder = (CoverHolder)te.getCapability(GregtechTileCapabilities.CAPABILITY_COVER_HOLDER, data.getSide());
        if (coverHolder == null) {
            throw new IllegalStateException("Could not get CoverHolder for found TileEntity!");
        }
        Cover cover = coverHolder.getCoverAtSide(data.getSide());
        if (cover == null) {
            throw new IllegalStateException("Could not find cover at side " + data.getSide() + " for found CoverHolder!");
        }
        if (!(cover instanceof CoverWithUI)) {
            throw new IllegalStateException("Cover at side " + data.getSide() + " is not a gui holder!");
        }
        CoverWithUI coverWithUI = (CoverWithUI)cover;
        return coverWithUI;
    }

    public void writeGuiData(SidedPosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
        buffer.writeByte(guiData.getSide().func_176745_a());
    }

    @NotNull
    public SidedPosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new SidedPosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), EnumFacing.field_82609_l[buffer.readByte()]);
    }
}

