/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.Widget;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.recipes.chance.boost.BoostableChanceEntry;
import gregtech.api.util.TextFormattingUtil;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class GTObjectDrawable
implements IDrawable,
JeiIngredientProvider {
    private static final TextRenderer renderer = new TextRenderer();
    private final Object object;
    private final long amount;
    private Function<BoostableChanceEntry<?>, Integer> boostFunction;

    public GTObjectDrawable(Object object, long amount) {
        this.object = object;
        this.amount = amount;
    }

    public GTObjectDrawable setBoostFunction(Function<BoostableChanceEntry<?>, Integer> boostFunction) {
        this.boostFunction = boostFunction;
        return this;
    }

    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        if (!(context instanceof ModularGuiContext)) {
            return;
        }
        ModularGuiContext modularGuiContext = (ModularGuiContext)context;
        renderer.setAlignment(Alignment.BottomRight, (float)(width - 1), (float)(height - 1));
        this.drawObject(this.object, modularGuiContext, x, y, width, height);
        if (this.amount > 0L) {
            renderer.setPos(x + 1, y + 1);
            String amount = TextFormattingUtil.formatLongToCompactString(this.amount, 3);
            if (this.object instanceof FluidStack) {
                amount = amount + "L";
            }
            renderer.draw(amount);
        }
    }

    private void drawObject(Object object, ModularGuiContext context, int x, int y, int width, int height) {
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            WidgetSlotTheme theme = context.getTheme().getItemSlotTheme();
            IDrawable background = theme.getBackground();
            if (background == null) {
                background = GTGuiTextures.SLOT;
            }
            background.draw((GuiContext)context, x, y, width, height, (WidgetTheme)theme);
            GuiDraw.drawItem((ItemStack)stack, (int)(x + 1), (int)(y + 1), (float)(width - 2), (float)(height - 2));
        } else if (object instanceof FluidStack) {
            FluidStack stack = (FluidStack)object;
            WidgetSlotTheme theme = context.getTheme().getFluidSlotTheme();
            IDrawable slot = theme.getBackground();
            if (slot == null) {
                slot = GTGuiTextures.FLUID_SLOT;
            }
            slot.draw((GuiContext)context, x, y, width, height, (WidgetTheme)theme);
            GuiDraw.drawFluidTexture((FluidStack)stack, (float)(x + 1), (float)(y + 1), (float)(width - 2), (float)(height - 2), (float)0.0f);
        } else if (object instanceof BoostableChanceEntry) {
            BoostableChanceEntry entry = (BoostableChanceEntry)object;
            this.drawObject(entry.getIngredient(), context, x, y, width, height);
            String chance = "~" + this.boostFunction.apply(entry) / 100 + "%";
            if (this.amount > 0L) {
                y -= 4;
            }
            renderer.setPos(x + 1, y + 1);
            renderer.draw(chance);
        }
    }

    public Icon asIcon() {
        return super.asIcon().size(18);
    }

    public Widget<?> asWidget() {
        return (Widget)super.asWidget().size(18);
    }

    @Nullable
    public Object getIngredient() {
        Object object = this.object;
        if (object instanceof BoostableChanceEntry) {
            BoostableChanceEntry entry = (BoostableChanceEntry)object;
            return entry.getIngredient();
        }
        return this.object;
    }

    static {
        renderer.setScale(0.5f);
        renderer.setShadow(true);
        renderer.setColor(Color.WHITE.main);
    }
}

