/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui;

import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import gregtech.api.mui.sync.PagedWidgetSyncHandler;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GregTechGuiTransferHandler
implements IRecipeTransferHandler<ModularContainer> {
    private final IRecipeTransferHandlerHelper handlerHelper;

    public GregTechGuiTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Class<ModularContainer> getContainerClass() {
        return ModularContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ModularContainer container, @NotNull IRecipeLayout recipeLayout, @NotNull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!container.getSyncManager().isOpen("workbench")) {
            return null;
        }
        PanelSyncManager syncManager = container.getSyncManager().getPanelSyncManager("workbench");
        CraftingRecipeLogic recipeLogic = (CraftingRecipeLogic)syncManager.getSyncHandler("recipe_logic:0");
        PagedWidgetSyncHandler pageController = (PagedWidgetSyncHandler)syncManager.getSyncHandler("page_controller:0");
        if (!doTransfer) {
            return null;
        }
        Int2ObjectMap<ItemStack> matrix = this.extractMatrix(recipeLayout.getItemStacks());
        recipeLogic.fillCraftingGrid((Map<Integer, ItemStack>)matrix);
        pageController.setPage(0);
        return null;
    }

    private Int2ObjectMap<ItemStack> extractMatrix(IGuiItemStackGroup stackGroup) {
        Map ingredients = stackGroup.getGuiIngredients();
        Int2ObjectArrayMap matrix = new Int2ObjectArrayMap(9);
        for (Integer slot : ingredients.keySet()) {
            ItemStack ing;
            if (slot == 0 || (ing = (ItemStack)((IGuiIngredient)ingredients.get(slot)).getDisplayedIngredient()) == null) continue;
            matrix.put(slot - 1, (Object)((ItemStack)((IGuiIngredient)ingredients.get(slot)).getDisplayedIngredient()));
        }
        return matrix;
    }
}

