/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import gregtech.api.cover.Cover;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.factory.CoverGuiFactory;
import gregtech.api.mui.factory.MetaItemGuiFactory;
import gregtech.api.mui.factory.MetaTileEntityGuiFactory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class GTGuis {
    public static final int DEFAULT_WIDTH = 176;
    public static final int DEFAULT_HIEGHT = 166;

    @ApiStatus.Internal
    public static void registerFactories() {
        GuiManager.registerFactory((UIFactory)MetaTileEntityGuiFactory.INSTANCE);
        GuiManager.registerFactory((UIFactory)MetaItemGuiFactory.INSTANCE);
        GuiManager.registerFactory((UIFactory)CoverGuiFactory.INSTANCE);
    }

    public static ModularPanel createPanel(String name, int width, int height) {
        return ModularPanel.defaultPanel((String)name, (int)width, (int)height);
    }

    public static ModularPanel createPanel(MetaTileEntity mte, int width, int height) {
        return GTGuis.createPanel(mte.metaTileEntityId.func_110623_a(), width, height);
    }

    public static ModularPanel createPanel(Cover cover, int width, int height) {
        return GTGuis.createPanel(cover.getDefinition().getResourceLocation().func_110623_a(), width, height);
    }

    public static ModularPanel createPanel(ItemStack stack, int width, int height) {
        String locale;
        Item item = stack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)item;
            Object valueItem = metaItem.getItem(stack);
            if (valueItem == null) {
                throw new IllegalArgumentException("Item must be a meta item!");
            }
            locale = ((MetaItem.MetaValueItem)valueItem).unlocalizedName;
        } else {
            locale = stack.func_77977_a();
        }
        return GTGuis.createPanel(locale, width, height);
    }

    public static ModularPanel createPanel(String name) {
        return ModularPanel.defaultPanel((String)name, (int)176, (int)166);
    }

    public static ModularPanel defaultPanel(MetaTileEntity mte) {
        return GTGuis.createPanel(mte.metaTileEntityId.func_110623_a());
    }

    public static ModularPanel defaultPanel(Cover cover) {
        return GTGuis.createPanel(cover.getDefinition().getResourceLocation().func_110623_a());
    }

    public static ModularPanel defaultPanel(ItemStack stack) {
        return GTGuis.createPanel(stack, 176, 166);
    }

    public static ModularPanel defaultPanel(MetaItem.MetaValueItem valueItem) {
        return GTGuis.createPanel(valueItem.unlocalizedName);
    }

    public static PopupPanel createPopupPanel(String name, int width, int height) {
        return GTGuis.defaultPopupPanel(name).size(width, height);
    }

    public static PopupPanel createPopupPanel(String name, int width, int height, boolean deleteCachedPanel) {
        return GTGuis.createPopupPanel(name, width, height).deleteCachedPanel(deleteCachedPanel);
    }

    public static PopupPanel defaultPopupPanel(String name) {
        return new PopupPanel(name).size(176, 166);
    }

    public static PopupPanel defaultPopupPanel(String name, boolean disableBelow, boolean closeOnOutsideClick, boolean deleteCachedPanel) {
        return GTGuis.defaultPopupPanel(name).disablePanelsBelow(disableBelow).closeOnOutOfBoundsClick(closeOnOutsideClick).deleteCachedPanel(deleteCachedPanel);
    }

    public static class PopupPanel
    extends ModularPanel {
        private boolean disableBelow;
        private boolean closeOnOutsideClick;
        private boolean deleteCachedPanel;

        private PopupPanel(@NotNull String name) {
            super(name);
            this.align(Alignment.Center);
            this.background(new IDrawable[]{GTGuiTextures.BACKGROUND_POPUP});
            this.child((IWidget)((ButtonWidget)((ButtonWidget)ButtonWidget.panelCloseButton().top(5)).right(5)).onMousePressed(mouseButton -> {
                if (mouseButton == 0 || mouseButton == 1) {
                    this.closeIfOpen(true);
                    return true;
                }
                return false;
            }));
        }

        public void onClose() {
            SyncHandler syncHandler;
            super.onClose();
            if (this.deleteCachedPanel && this.isSynced() && (syncHandler = this.getSyncHandler()) instanceof IPanelHandler) {
                IPanelHandler handler = (IPanelHandler)syncHandler;
                handler.deleteCachedPanel();
            }
        }

        public PopupPanel disablePanelsBelow(boolean disableBelow) {
            this.disableBelow = disableBelow;
            return this;
        }

        public PopupPanel closeOnOutOfBoundsClick(boolean closeOnOutsideClick) {
            this.closeOnOutsideClick = closeOnOutsideClick;
            return this;
        }

        public PopupPanel deleteCachedPanel(boolean deleteCachedPanel) {
            this.deleteCachedPanel = deleteCachedPanel;
            return this;
        }

        public PopupPanel size(int w, int h) {
            super.size(w, h);
            return this;
        }

        public PopupPanel size(int val) {
            super.size(val);
            return this;
        }

        public boolean disablePanelsBelow() {
            return this.disableBelow;
        }

        public boolean closeOnOutOfBoundsClick() {
            return this.closeOnOutsideClick;
        }
    }
}

