/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.drawable.DrawableSerialization;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.theme.ReloadThemeEvent;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class GTGuiTheme {
    private static final List<GTGuiTheme> THEMES = new ArrayList<GTGuiTheme>();
    public static final GTGuiTheme STANDARD = GTGuiTheme.templateBuilder(Names.STANDARD).panel(GTGuiTextures.IDs.STANDARD_BACKGROUND).itemSlot(GTGuiTextures.IDs.STANDARD_SLOT).fluidSlot(GTGuiTextures.IDs.STANDARD_FLUID_SLOT).color(ConfigHolder.client.defaultUIColor).button(GTGuiTextures.IDs.STANDARD_BUTTON).simpleToggleButton(GTGuiTextures.IDs.STANDARD_BUTTON, GTGuiTextures.IDs.STANDARD_SLOT, ConfigHolder.client.defaultUIColor).build();
    public static final GTGuiTheme COVER = GTGuiTheme.templateBuilder(Names.COVER).panel(GTGuiTextures.IDs.COVER_BACKGROUND).itemSlot(GTGuiTextures.IDs.STANDARD_SLOT).fluidSlot(GTGuiTextures.IDs.STANDARD_FLUID_SLOT).color(ConfigHolder.client.defaultUIColor).textColor(-11184811).build();
    public static final GTGuiTheme BRONZE = GTGuiTheme.templateBuilder(Names.BRONZE).parent(Names.STANDARD).panel(GTGuiTextures.IDs.BRONZE_BACKGROUND).displayBackground(GTGuiTextures.IDs.DISPLAY_BRONZE).button(GTGuiTextures.IDs.BRONZE_BUTTON).color(16742150).simpleToggleButton(GTGuiTextures.IDs.BRONZE_BUTTON, GTGuiTextures.IDs.BRONZE_BUTTON_SELECTED, ConfigHolder.client.defaultUIColor).build();
    public static final GTGuiTheme STEEL = GTGuiTheme.templateBuilder(Names.STEEL).parent(Names.STANDARD).panel(GTGuiTextures.IDs.STEEL_BACKGROUND).textColor(Color.WHITE.darker(1)).displayBackground(GTGuiTextures.IDs.DISPLAY_STEEL).button(GTGuiTextures.IDs.STEEL_BUTTON).simpleToggleButton(GTGuiTextures.IDs.STEEL_BUTTON, GTGuiTextures.IDs.STEEL_BUTTON_SELECTED, ConfigHolder.client.defaultUIColor).color(5724010).build();
    public static final GTGuiTheme PRIMITIVE = GTGuiTheme.templateBuilder(Names.PRIMITIVE).parent(Names.STANDARD).panel(GTGuiTextures.IDs.PRIMITIVE_BACKGROUND).textColor(Color.WHITE.darker(1)).color(8547153).build();
    protected final String themeId;
    protected final List<Consumer<JsonBuilder>> elementBuilder;
    protected final JsonBuilder jsonBuilder;
    private Supplier<UITexture> logo;
    private String displayBackground = GTGuiTextures.IDs.DISPLAY;

    protected GTGuiTheme(String themeId) {
        this.themeId = themeId;
        this.jsonBuilder = new JsonBuilder();
        this.elementBuilder = new ArrayList<Consumer<JsonBuilder>>();
        THEMES.add(this);
    }

    public String getId() {
        return this.themeId;
    }

    public ITheme getMuiTheme() {
        return IThemeApi.get().getTheme(this.themeId);
    }

    @Nullable
    public UITexture getLogo() {
        if (this.logo == null) {
            return null;
        }
        return this.logo.get();
    }

    @Nullable
    public UITexture getDisplayBackground() {
        return DrawableSerialization.getTexture((String)this.displayBackground);
    }

    private void register() {
        this.buildJson();
        IThemeApi.get().registerTheme(this.themeId, this.jsonBuilder);
    }

    private void buildJson() {
        this.elementBuilder.forEach(c -> c.accept(this.jsonBuilder));
    }

    public static void registerThemes() {
        MinecraftForge.EVENT_BUS.register(GTGuiTheme.class);
        THEMES.forEach(GTGuiTheme::register);
    }

    @SubscribeEvent
    public static void onReloadThemes(ReloadThemeEvent.Pre event) {
        THEMES.forEach(GTGuiTheme::buildJson);
    }

    public static Builder templateBuilder(String themeId) {
        Builder builder = new Builder(themeId);
        builder.openCloseAnimation(0);
        builder.tooltipPos(RichTooltip.Pos.NEXT_TO_MOUSE);
        builder.smoothProgressBar(true);
        return builder;
    }

    public static class Builder {
        private final GTGuiTheme theme;

        public Builder(String themeId) {
            this.theme = new GTGuiTheme(themeId);
        }

        public Builder parent(String parentId) {
            this.theme.elementBuilder.add(b -> b.add("parent", parentId));
            return this;
        }

        public Builder globalBackground(String backgroundId) {
            this.theme.elementBuilder.add(b -> b.add("background", backgroundId));
            return this;
        }

        public Builder globalHoverBackground(String hoverBackgroundId) {
            this.theme.elementBuilder.add(b -> b.add("hoverBackground", hoverBackgroundId));
            return this;
        }

        public Builder openCloseAnimation(int rate) {
            this.theme.elementBuilder.add(b -> b.add("openCloseAnimation", (Number)rate));
            return this;
        }

        public Builder smoothProgressBar(boolean smoothBar) {
            this.theme.elementBuilder.add(b -> b.add("smoothProgressBar", smoothBar));
            return this;
        }

        public Builder tooltipPos(RichTooltip.Pos tooltipPos) {
            this.theme.elementBuilder.add(b -> b.add("tooltipPos", tooltipPos.name()));
            return this;
        }

        public Builder color(int color) {
            this.theme.elementBuilder.add(b -> b.add("color", (Number)color));
            return this;
        }

        public Builder textColor(int textColor) {
            this.theme.elementBuilder.add(b -> b.add("textColor", (Number)textColor));
            return this;
        }

        public Builder textShadow() {
            this.theme.elementBuilder.add(b -> b.add("textShadow", true));
            return this;
        }

        public Builder panel(String panelId) {
            this.theme.elementBuilder.add(b -> b.add("panel", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", panelId))));
            return this;
        }

        public Builder button(String buttonId) {
            return this.button(buttonId, buttonId, -1, false);
        }

        public Builder button(String buttonId, String hoverId) {
            return this.button(buttonId, hoverId, -1, false);
        }

        public Builder button(String buttonId, String hoverId, int textColor, boolean textShadow) {
            this.theme.elementBuilder.add(b -> b.add("button", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", buttonId)).add("hoverBackground", new JsonBuilder().add("type", "texture").add("id", hoverId)).add("textColor", (Number)textColor).add("textShadow", textShadow)));
            return this;
        }

        public Builder itemSlot(String itemSlotId) {
            return this.itemSlot(itemSlotId, 0x60FFFFFF);
        }

        public Builder itemSlot(String itemSlotId, int hoverColor) {
            this.theme.elementBuilder.add(b -> b.add("itemSlot", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", itemSlotId)).add("slotHoverColor", (Number)hoverColor)));
            return this;
        }

        public Builder fluidSlot(String fluidSlotId) {
            return this.fluidSlot(fluidSlotId, 0x60FFFFFF);
        }

        public Builder fluidSlot(String fluidSlotId, int hoverColor) {
            this.theme.elementBuilder.add(b -> b.add("fluidSlot", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", fluidSlotId)).add("slotHoverColor", (Number)hoverColor)));
            return this;
        }

        public Builder textField(int textColor) {
            return this.textField(textColor, -13667672);
        }

        public Builder textField(int textColor, int markedColor) {
            this.theme.elementBuilder.add(b -> b.add("textField", new JsonBuilder().add("textColor", (Number)textColor).add("markedColor", (Number)markedColor)));
            return this;
        }

        public Builder toggleButton(String backgroundId, String hoverBackgroundId, String selectedBackgroundId, String selectedHoverBackgroundId, int selectedColor) {
            return this.toggleButton(backgroundId, hoverBackgroundId, selectedBackgroundId, selectedHoverBackgroundId, selectedColor, -4473925, false);
        }

        public Builder toggleButton(String backgroundId, String hoverBackgroundId, String selectedBackgroundId, String selectedHoverBackgroundId, int selectedColor, int textColor, boolean textShadow) {
            this.theme.elementBuilder.add(b -> b.add("toggleButton", new JsonBuilder().add("background", new JsonBuilder().add("type", "texture").add("id", backgroundId)).add("hoverBackground", new JsonBuilder().add("type", "texture").add("id", hoverBackgroundId)).add("selectedBackground", new JsonBuilder().add("type", "texture").add("id", selectedBackgroundId)).add("selectedHoverBackground", new JsonBuilder().add("type", "texture").add("id", selectedHoverBackgroundId)).add("selectedColor", (Number)selectedColor).add("textColor", (Number)textColor).add("textShadow", textShadow)));
            return this;
        }

        public Builder simpleToggleButton(String backgroundId, String selectedBackgroundId, int selectedColor) {
            return this.simpleToggleButton(backgroundId, selectedBackgroundId, selectedColor, -4473925, false);
        }

        public Builder simpleToggleButton(String backgroundId, String selectedBackgroundId, int selectedColor, int textColor, boolean textShadow) {
            return this.toggleButton(backgroundId, backgroundId, selectedBackgroundId, selectedBackgroundId, selectedColor, textColor, textShadow);
        }

        public Builder logo(Supplier<UITexture> logo) {
            this.theme.logo = logo;
            return this;
        }

        public Builder displayBackground(String displayBackground) {
            this.theme.displayBackground = displayBackground;
            return this;
        }

        public GTGuiTheme build() {
            return this.theme;
        }
    }

    public static class Names {
        public static final String STANDARD = Names.gregtech("standard");
        public static final String COVER = Names.gregtech("cover");
        public static final String BRONZE = Names.gregtech("bronze");
        public static final String STEEL = Names.gregtech("steel");
        public static final String PRIMITIVE = Names.gregtech("primitive");

        private static String gregtech(String s) {
            return "gregtech:" + s;
        }
    }

    public static class Colors {
        public static final int BRONZE = 16742150;
        public static final int STEEL = 5724010;
        public static final int PRIMITIVE = 8547153;
    }
}

