/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import gregtech.api.GTValues;
import gregtech.api.mui.GTGuiTheme;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class GTGuiTextures {
    public static final UITexture GREGTECH_LOGO = GTGuiTextures.fullImage("textures/gui/icon/gregtech_logo.png");
    public static final UITexture GREGTECH_LOGO_XMAS = GTGuiTextures.fullImage("textures/gui/icon/gregtech_logo_xmas.png");
    public static final UITexture GREGTECH_LOGO_DARK = GTGuiTextures.fullImage("textures/gui/icon/gregtech_logo_dark.png");
    public static final IDrawable GREGTECH_LOGO_BLINKING_YELLOW = GTGuiTextures.animated("textures/gui/icon/gregtech_logo_blinking_yellow.png", 17, 34, false, 60);
    public static final IDrawable GREGTECH_LOGO_BLINKING_RED = GTGuiTextures.animated("textures/gui/icon/gregtech_logo_blinking_red.png", 17, 34, false, 36);
    public static final UITexture INDICATOR_NO_ENERGY = GTGuiTextures.fullImage("textures/gui/base/indicator_no_energy.png");
    public static final UITexture INDICATOR_NO_STEAM_BRONZE = GTGuiTextures.fullImage("textures/gui/base/indicator_no_steam_bronze.png");
    public static final UITexture INDICATOR_NO_STEAM_STEEL = GTGuiTextures.fullImage("textures/gui/base/indicator_no_steam_steel.png");
    public static final UITexture TANK_ICON = GTGuiTextures.fullImage("textures/gui/base/tank_icon.png");
    public static final UITexture BACKGROUND = UITexture.builder().location("gregtech", "textures/gui/base/background.png").imageSize(176, 166).adaptable(3).name(IDs.STANDARD_BACKGROUND).canApplyTheme().build();
    public static final UITexture BACKGROUND_POPUP = UITexture.builder().location("gregtech", "textures/gui/base/background_popup.png").imageSize(195, 136).adaptable(4).name(IDs.COVER_BACKGROUND).canApplyTheme().build();
    public static final UITexture BACKGROUND_BRONZE = UITexture.builder().location("gregtech", "textures/gui/base/background_bronze.png").imageSize(176, 166).adaptable(3).name(IDs.BRONZE_BACKGROUND).build();
    public static final UITexture BACKGROUND_STEEL = UITexture.builder().location("gregtech", "textures/gui/base/background_steel.png").imageSize(176, 166).adaptable(3).name(IDs.STEEL_BACKGROUND).build();
    public static final UITexture BACKGROUND_PRIMITIVE = UITexture.builder().location("gregtech", "textures/gui/primitive/primitive_background.png").imageSize(176, 166).adaptable(3).name(IDs.PRIMITIVE_BACKGROUND).build();
    public static final UITexture DISPLAY = new UITexture.Builder().location("gregtech", "textures/gui/base/display.png").name(IDs.DISPLAY).imageSize(143, 75).adaptable(2).canApplyTheme().build();
    public static final UITexture DISPLAY_BRONZE = new UITexture.Builder().location("gregtech", "textures/gui/base/display_bronze.png").name(IDs.DISPLAY_BRONZE).imageSize(143, 75).adaptable(2).build();
    public static final UITexture DISPLAY_STEEL = new UITexture.Builder().location("gregtech", "textures/gui/base/display_steel.png").name(IDs.DISPLAY_STEEL).imageSize(143, 75).adaptable(2).build();
    public static final UITexture FUSION_REACTOR_MK1_TITLE = GTGuiTextures.fullImage("textures/gui/widget/fusion_reactor_mk1_title.png");
    public static final UITexture FUSION_REACTOR_MK2_TITLE = GTGuiTextures.fullImage("textures/gui/widget/fusion_reactor_mk2_title.png");
    public static final UITexture FUSION_REACTOR_MK3_TITLE = GTGuiTextures.fullImage("textures/gui/widget/fusion_reactor_mk3_title.png");
    public static final UITexture FUSION_DIAGRAM = GTGuiTextures.fullImage("textures/gui/widget/fusion_reactor_diagram.png");
    public static final UITexture FUSION_LEGEND = GTGuiTextures.fullImage("textures/gui/widget/fusion_reactor_legend.png");
    public static final UITexture FUSION_PROGRESS = GTGuiTextures.fullImage("textures/gui/progress_bar/fusion_diagram/stitched.png");
    public static final UITexture SLOT = new UITexture.Builder().location("gregtech", "textures/gui/base/slot.png").imageSize(18, 18).adaptable(1).name(IDs.STANDARD_SLOT).canApplyTheme().build();
    public static final UITexture SLOT_BRONZE = new UITexture.Builder().location("gregtech", "textures/gui/base/slot_bronze.png").imageSize(18, 18).adaptable(1).name(IDs.BRONZE_SLOT).build();
    public static final UITexture SLOT_STEEL = new UITexture.Builder().location("gregtech", "textures/gui/base/slot_steel.png").imageSize(18, 18).adaptable(1).name(IDs.STEEL_SLOT).build();
    public static final UITexture SLOT_PRIMITIVE = new UITexture.Builder().location("gregtech", "textures/gui/primitive/primitive_slot.png").imageSize(18, 18).adaptable(1).name(IDs.PRIMITIVE_SLOT).build();
    public static final UITexture FLUID_SLOT = new UITexture.Builder().location("gregtech", "textures/gui/base/fluid_slot.png").imageSize(18, 18).adaptable(1).name(IDs.STANDARD_FLUID_SLOT).canApplyTheme().build();
    public static final UITexture BLANK_TRANSPARENT = GTGuiTextures.fullImage("textures/gui/base/blank_transparent.png");
    public static final UITexture HPCA_COMPONENT_OUTLINE = GTGuiTextures.fullImage("textures/gui/widget/hpca/component_outline.png");
    public static final UITexture HPCA_ICON_EMPTY_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/empty_component.png");
    public static final UITexture HPCA_ICON_ADVANCED_COMPUTATION_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/advanced_computation_component.png");
    public static final UITexture HPCA_ICON_BRIDGE_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/bridge_component.png");
    public static final UITexture HPCA_ICON_COMPUTATION_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/computation_component.png");
    public static final UITexture HPCA_ICON_ACTIVE_COOLER_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/active_cooler_component.png");
    public static final UITexture HPCA_ICON_HEAT_SINK_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/heat_sink_component.png");
    public static final UITexture HPCA_ICON_DAMAGED_ADVANCED_COMPUTATION_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/damaged_advanced_computation_component.png");
    public static final UITexture HPCA_ICON_DAMAGED_COMPUTATION_COMPONENT = GTGuiTextures.fullImage("textures/gui/widget/hpca/damaged_computation_component.png");
    public static final UITexture[] BUTTON_BLACKLIST = GTGuiTextures.slice("textures/gui/widget/button_blacklist.png", 16, 32, 16, 16, true);
    public static final UITexture[] BUTTON_IGNORE_DAMAGE = GTGuiTextures.slice("textures/gui/widget/button_filter_damage.png", 16, 32, 16, 16, true);
    public static final UITexture[] BUTTON_IGNORE_NBT = GTGuiTextures.slice("textures/gui/widget/button_filter_nbt.png", 16, 32, 16, 16, true);
    public static final UITexture[] BUTTON_CASE_SENSITIVE = GTGuiTextures.slice("textures/gui/widget/ore_filter/button_case_sensitive.png", 16, 32, 16, 16, true);
    public static final UITexture[] BUTTON_MATCH_ALL = GTGuiTextures.slice("textures/gui/widget/ore_filter/button_match_all.png", 16, 32, 16, 16, true);
    public static final UITexture BUTTON_LOCK = GTGuiTextures.fullImage("textures/gui/widget/button_lock.png");
    public static final UITexture OREDICT_ERROR = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/error.png");
    public static final UITexture OREDICT_INFO = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/info.png");
    public static final UITexture OREDICT_MATCH = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/match.png");
    public static final UITexture OREDICT_NO_MATCH = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/no_match.png");
    public static final UITexture OREDICT_SUCCESS = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/success.png");
    public static final UITexture OREDICT_WAITING = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/waiting.png");
    public static final UITexture OREDICT_WARN = GTGuiTextures.fullImage("textures/gui/widget/ore_filter/warn.png");
    public static final IDrawable PLUS = IKey.str((String)"+").asIcon().marginLeft(1);
    public static final IDrawable MINUS = IKey.str((String)"-").asIcon().marginLeft(1);
    public static final UITexture[] MANUAL_IO_OVERLAY_IN = GTGuiTextures.slice("textures/gui/overlay/manual_io_overlay_in.png", 18, 54, 18, 18, true);
    public static final UITexture[] MANUAL_IO_OVERLAY_OUT = GTGuiTextures.slice("textures/gui/overlay/manual_io_overlay_out.png", 18, 54, 18, 18, true);
    public static final UITexture[] CONVEYOR_MODE_OVERLAY = GTGuiTextures.slice("textures/gui/overlay/conveyor_mode_overlay.png", 18, 36, 18, 18, true);
    public static final UITexture[] TRANSFER_MODE_OVERLAY = GTGuiTextures.slice("textures/gui/overlay/transfer_mode_overlay.png", 18, 54, 18, 18, true);
    public static final UITexture[] FLUID_TRANSFER_MODE_OVERLAY = GTGuiTextures.slice("textures/gui/overlay/fluid_transfer_mode_overlay.png", 18, 54, 18, 18, true);
    public static final UITexture[] DISTRIBUTION_MODE_OVERLAY = GTGuiTextures.slice("textures/gui/widget/button_distribution_mode.png", 16, 48, 16, 16, true);
    public static final UITexture[] VOIDING_MODE_OVERLAY = GTGuiTextures.slice("textures/gui/overlay/voiding_mode_overlay.png", 16, 32, 16, 16, true);
    public static final UITexture[] FILTER_MODE_OVERLAY = GTGuiTextures.slice("textures/gui/overlay/filter_mode_overlay.png", 16, 48, 16, 16, true);
    public static final UITexture[] PRIVATE_MODE_BUTTON = GTGuiTextures.slice("textures/gui/widget/button_public_private.png", 18, 36, 18, 18, true);
    public static final UITexture MENU_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/menu_overlay.png");
    public static final UITexture RECIPE_LOCK = GTGuiTextures.fullImage("textures/gui/widget/lock.png");
    public static final UITexture PRIMITIVE_FURNACE_OVERLAY = GTGuiTextures.fullImage("textures/gui/primitive/overlay_primitive_furnace.png");
    public static final UITexture PRIMITIVE_DUST_OVERLAY = GTGuiTextures.fullImage("textures/gui/primitive/overlay_primitive_dust.png");
    public static final UITexture PRIMITIVE_INGOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/primitive/overlay_primitive_ingot.png");
    public static final UITexture PRIMITIVE_LARGE_FLUID_TANK = new UITexture.Builder().location("gregtech", "textures/gui/primitive/primitive_large_fluid_tank.png").fullImage().adaptable(2).build();
    public static final UITexture PRIMITIVE_LARGE_FLUID_TANK_OVERLAY = GTGuiTextures.fullImage("textures/gui/primitive/primitive_large_fluid_tank_overlay.png");
    public static final UITexture PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR = GTGuiTextures.fullImage("textures/gui/primitive/progress_bar_primitive_blast_furnace.png");
    public static final UITexture ATOMIC_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/atomic_overlay_1.png", true);
    public static final UITexture ATOMIC_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/atomic_overlay_2.png", true);
    public static final UITexture ARROW_INPUT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/arrow_input_overlay.png", true);
    public static final UITexture ARROW_OUTPUT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/arrow_output_overlay.png", true);
    public static final UITexture BATTERY_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/battery_overlay.png", true);
    public static final UITexture BEAKER_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/beaker_overlay_1.png", true);
    public static final UITexture BEAKER_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/beaker_overlay_2.png", true);
    public static final UITexture BEAKER_OVERLAY_3 = GTGuiTextures.fullImage("textures/gui/overlay/beaker_overlay_3.png", true);
    public static final UITexture BEAKER_OVERLAY_4 = GTGuiTextures.fullImage("textures/gui/overlay/beaker_overlay_4.png", true);
    public static final UITexture BENDER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/bender_overlay.png", true);
    public static final UITexture BOX_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/box_overlay.png", true);
    public static final UITexture BOXED_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/boxed_overlay.png", true);
    public static final UITexture BREWER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/brewer_overlay.png", true);
    public static final UITexture CANNER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/canner_overlay.png", true);
    public static final UITexture CHARGER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/charger_slot_overlay.png", true);
    public static final UITexture CANISTER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/canister_overlay.png", true);
    public static final UITexture CANISTER_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/canister_overlay_bronze.png");
    public static final UITexture CANISTER_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/canister_overlay_steel.png");
    public static final UITexture CENTRIFUGE_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/centrifuge_overlay.png", true);
    public static final UITexture CIRCUIT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/circuit_overlay.png", true);
    public static final UITexture COAL_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/coal_overlay_bronze.png");
    public static final UITexture COAL_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/coal_overlay_steel.png");
    public static final UITexture COMPRESSOR_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/compressor_overlay.png", true);
    public static final UITexture COMPRESSOR_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/compressor_overlay_bronze.png");
    public static final UITexture COMPRESSOR_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/compressor_overlay_steel.png");
    public static final UITexture CRACKING_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/cracking_overlay_1.png", true);
    public static final UITexture CRACKING_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/cracking_overlay_2.png", true);
    public static final UITexture CRUSHED_ORE_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/crushed_ore_overlay.png", true);
    public static final UITexture CRUSHED_ORE_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/crushed_ore_overlay_bronze.png");
    public static final UITexture CRUSHED_ORE_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/crushed_ore_overlay_steel.png");
    public static final UITexture CRYSTAL_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/crystal_overlay.png", true);
    public static final UITexture CUTTER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/cutter_overlay.png", true);
    public static final UITexture DARK_CANISTER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/dark_canister_overlay.png", true);
    public static final UITexture DUST_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/dust_overlay.png", true);
    public static final UITexture DUST_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/dust_overlay_bronze.png");
    public static final UITexture DUST_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/dust_overlay_steel.png");
    public static final UITexture EXTRACTOR_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/extractor_overlay.png", true);
    public static final UITexture EXTRACTOR_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/extractor_overlay_bronze.png");
    public static final UITexture EXTRACTOR_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/extractor_overlay_steel.png");
    public static final UITexture FILTER_SLOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/filter_slot_overlay.png", true);
    public static final UITexture FILTER_SETTINGS_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/filter_settings_overlay.png");
    public static final UITexture FURNACE_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/furnace_overlay_1.png", true);
    public static final UITexture FURNACE_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/furnace_overlay_2.png", true);
    public static final UITexture FURNACE_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/furnace_overlay_bronze.png");
    public static final UITexture FURNACE_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/furnace_overlay_steel.png");
    public static final UITexture HAMMER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/hammer_overlay.png", true);
    public static final UITexture HAMMER_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/hammer_overlay_bronze.png");
    public static final UITexture HAMMER_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/hammer_overlay_steel.png");
    public static final UITexture HEATING_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/heating_overlay_1.png", true);
    public static final UITexture HEATING_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/heating_overlay_2.png", true);
    public static final UITexture IMPLOSION_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/implosion_overlay_1.png", true);
    public static final UITexture IMPLOSION_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/implosion_overlay_2.png", true);
    public static final UITexture IN_SLOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/in_slot_overlay.png", true);
    public static final UITexture IN_SLOT_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/in_slot_overlay_bronze.png");
    public static final UITexture IN_SLOT_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/in_slot_overlay_steel.png");
    public static final UITexture INGOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/ingot_overlay.png", true);
    public static final UITexture INT_CIRCUIT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/int_circuit_overlay.png", true);
    public static final UITexture LENS_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/lens_overlay.png", true);
    public static final UITexture LIGHTNING_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/lightning_overlay_1.png", true);
    public static final UITexture LIGHTNING_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/lightning_overlay_2.png", true);
    public static final UITexture MOLD_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/mold_overlay.png", true);
    public static final UITexture MOLECULAR_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/molecular_overlay_1.png", true);
    public static final UITexture MOLECULAR_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/molecular_overlay_2.png", true);
    public static final UITexture MOLECULAR_OVERLAY_3 = GTGuiTextures.fullImage("textures/gui/overlay/molecular_overlay_3.png", true);
    public static final UITexture MOLECULAR_OVERLAY_4 = GTGuiTextures.fullImage("textures/gui/overlay/molecular_overlay_4.png", true);
    public static final UITexture OUT_SLOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/out_slot_overlay.png", true);
    public static final UITexture OUT_SLOT_OVERLAY_BRONZE = GTGuiTextures.fullImage("textures/gui/overlay/out_slot_overlay_bronze.png");
    public static final UITexture OUT_SLOT_OVERLAY_STEEL = GTGuiTextures.fullImage("textures/gui/overlay/out_slot_overlay_steel.png");
    public static final UITexture PAPER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/paper_overlay.png", true);
    public static final UITexture PRINTED_PAPER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/printed_paper_overlay.png", true);
    public static final UITexture PIPE_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/pipe_overlay_2.png", true);
    public static final UITexture PIPE_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/pipe_overlay_1.png", true);
    public static final UITexture PRESS_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/press_overlay_1.png", true);
    public static final UITexture PRESS_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/press_overlay_2.png", true);
    public static final UITexture PRESS_OVERLAY_3 = GTGuiTextures.fullImage("textures/gui/overlay/press_overlay_3.png", true);
    public static final UITexture PRESS_OVERLAY_4 = GTGuiTextures.fullImage("textures/gui/overlay/press_overlay_4.png", true);
    public static final UITexture SAWBLADE_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/sawblade_overlay.png", true);
    public static final UITexture SOLIDIFIER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/solidifier_overlay.png", true);
    public static final UITexture STRING_SLOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/string_slot_overlay.png", true);
    public static final UITexture TOOL_SLOT_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/tool_slot_overlay.png", true);
    public static final UITexture TURBINE_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/turbine_overlay.png", true);
    public static final UITexture VIAL_OVERLAY_1 = GTGuiTextures.fullImage("textures/gui/overlay/vial_overlay_1.png", true);
    public static final UITexture VIAL_OVERLAY_2 = GTGuiTextures.fullImage("textures/gui/overlay/vial_overlay_2.png", true);
    public static final UITexture WIREMILL_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/wiremill_overlay.png", true);
    public static final UITexture POSITIVE_MATTER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/positive_matter_overlay.png", true);
    public static final UITexture NEUTRAL_MATTER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/neutral_matter_overlay.png", true);
    public static final UITexture DATA_ORB_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/data_orb_overlay.png", true);
    public static final UITexture SCANNER_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/scanner_overlay.png", true);
    public static final UITexture DUCT_TAPE_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/duct_tape_overlay.png", true);
    public static final UITexture RESEARCH_STATION_OVERLAY = GTGuiTextures.fullImage("textures/gui/overlay/research_station_overlay.png", true);
    public static final UITexture BUTTON = new UITexture.Builder().location("gregtech", "textures/gui/widget/button.png").imageSize(18, 18).adaptable(2).name(IDs.STANDARD_BUTTON).canApplyTheme().build();
    public static final UITexture BUTTON_BRONZE = new UITexture.Builder().location("gregtech", "textures/gui/widget/buttons.png").imageSize(54, 36).uv(18, 0, 18, 18).adaptable(2).name(IDs.BRONZE_BUTTON).build();
    public static final UITexture BUTTON_BRONZE_SELECTED = new UITexture.Builder().location("gregtech", "textures/gui/widget/buttons.png").imageSize(54, 36).uv(18, 18, 18, 18).adaptable(2).name(IDs.BRONZE_BUTTON_SELECTED).build();
    public static final UITexture BUTTON_STEEL = new UITexture.Builder().location("gregtech", "textures/gui/widget/buttons.png").imageSize(54, 36).uv(36, 0, 18, 18).adaptable(2).name(IDs.STEEL_BUTTON).build();
    public static final UITexture BUTTON_STEEL_SELECTED = new UITexture.Builder().location("gregtech", "textures/gui/widget/buttons.png").imageSize(54, 36).uv(36, 18, 18, 18).adaptable(2).name(IDs.STEEL_BUTTON_SELECTED).build();
    public static final UITexture MC_BUTTON = new UITexture.Builder().location("modularui", "gui/widgets/mc_button.png").imageSize(16, 32).uv(0.0f, 0.0f, 1.0f, 0.5f).adaptable(2).build();
    public static final UITexture MC_BUTTON_DISABLED = new UITexture.Builder().location("modularui", "gui/widgets/mc_button_disabled.png").imageSize(16, 16).adaptable(2).build();
    public static final UITexture BUTTON_ITEM_OUTPUT = GTGuiTextures.fullImage("textures/gui/widget/button_item_output_overlay.png");
    public static final UITexture BUTTON_FLUID_OUTPUT = GTGuiTextures.fullImage("textures/gui/widget/button_fluid_output_overlay.png");
    public static final UITexture BUTTON_AUTO_COLLAPSE = GTGuiTextures.fullImage("textures/gui/widget/button_auto_collapse_overlay.png");
    public static final UITexture BUTTON_X = GTGuiTextures.fullImage("textures/gui/widget/button_x_overlay.png", true);
    public static final UITexture BUTTON_CLEAR_GRID = GTGuiTextures.fullImage("textures/gui/widget/button_clear_grid.png", false);
    public static final UITexture BUTTON_CROSS = GTGuiTextures.fullImage("textures/gui/widget/button_cross.png");
    public static final UITexture BUTTON_REDSTONE_ON = GTGuiTextures.fullImage("textures/gui/widget/button_redstone_on.png");
    public static final UITexture BUTTON_REDSTONE_OFF = GTGuiTextures.fullImage("textures/gui/widget/button_redstone_off.png");
    public static final UITexture[] BUTTON_POWER = GTGuiTextures.slice("textures/gui/widget/button_power.png", 18, 36, 18, 18, false);
    public static final UITexture BUTTON_POWER_DETAIL = GTGuiTextures.fullImage("textures/gui/widget/button_power_detail.png");
    public static final UITexture[] MULTIBLOCK_VOID = GTGuiTextures.slice("textures/gui/widget/button_void_multiblock.png", 18, 72, 18, 18, false);
    public static final UITexture OVERLAY_VOID_NONE = GTGuiTextures.fullImage("textures/gui/widget/button_void_none.png");
    public static final UITexture[] OVERLAY_DISTINCT_BUSES = GTGuiTextures.slice("textures/gui/widget/button_distinct_buses.png", 18, 36, 18, 18, false);
    public static final UITexture OVERLAY_NO_FLEX = GTGuiTextures.fullImage("textures/gui/widget/button_no_flex.png", false);
    public static final UITexture BUTTON_MULTI_MAP = GTGuiTextures.fullImage("textures/gui/widget/button_multi_map.png", true);
    public static final UITexture BUTTON_MINER_MODES = GTGuiTextures.fullImage("textures/gui/widget/button_miner_modes.png", true);
    public static final UITexture BUTTON_THROTTLE_MINUS = GTGuiTextures.fullImage("textures/gui/widget/button_throttle_minus.png", true);
    public static final UITexture BUTTON_THROTTLE_PLUS = GTGuiTextures.fullImage("textures/gui/widget/button_throttle_plus.png", true);
    public static final UITexture PROGRESS_BAR_ARC_FURNACE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_arc_furnace.png", true);
    public static final UITexture PROGRESS_BAR_ARROW = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_arrow.png", true);
    public static final UITexture PROGRESS_BAR_ARROW_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_arrow_bronze.png");
    public static final UITexture PROGRESS_BAR_ARROW_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_arrow_steel.png");
    public static final UITexture PROGRESS_BAR_ARROW_MULTIPLE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_arrow_multiple.png", true);
    public static final UITexture PROGRESS_BAR_BATH = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_bath.png", true);
    public static final UITexture PROGRESS_BAR_BENDING = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_bending.png", true);
    public static final UITexture PROGRESS_BAR_CANNER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_canner.png", true);
    public static final UITexture PROGRESS_BAR_CIRCUIT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_circuit.png", true);
    public static final UITexture PROGRESS_BAR_CIRCUIT_ASSEMBLER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_circuit_assembler.png", true);
    public static final UITexture PROGRESS_BAR_COMPRESS = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_compress.png", true);
    public static final UITexture PROGRESS_BAR_COMPRESS_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_compress_bronze.png");
    public static final UITexture PROGRESS_BAR_COMPRESS_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_compress_steel.png");
    public static final UITexture PROGRESS_BAR_CRACKING = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_cracking.png", true);
    public static final UITexture PROGRESS_BAR_CRACKING_INPUT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_cracking_2.png", 21, 38, true);
    public static final UITexture PROGRESS_BAR_CRYSTALLIZATION = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_crystallization.png", true);
    public static final UITexture PROGRESS_BAR_EXTRACT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_extract.png", true);
    public static final UITexture PROGRESS_BAR_EXTRACT_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_extract_bronze.png");
    public static final UITexture PROGRESS_BAR_EXTRACT_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_extract_steel.png");
    public static final UITexture PROGRESS_BAR_EXTRUDER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_extruder.png", true);
    public static final UITexture PROGRESS_BAR_FUSION = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_fusion.png", true);
    public static final UITexture PROGRESS_BAR_GAS_COLLECTOR = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_gas_collector.png", true);
    public static final UITexture PROGRESS_BAR_HAMMER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_hammer.png", true);
    public static final UITexture PROGRESS_BAR_HAMMER_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_hammer_bronze.png");
    public static final UITexture PROGRESS_BAR_HAMMER_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_hammer_steel.png");
    public static final UITexture PROGRESS_BAR_HAMMER_BASE = GTGuiTextures.fullImage("textures/gui/progress_bar/progress_bar_hammer_base.png", true);
    public static final UITexture PROGRESS_BAR_HAMMER_BASE_BRONZE = GTGuiTextures.fullImage("textures/gui/progress_bar/progress_bar_hammer_base_bronze.png");
    public static final UITexture PROGRESS_BAR_HAMMER_BASE_STEEL = GTGuiTextures.fullImage("textures/gui/progress_bar/progress_bar_hammer_base_steel.png");
    public static final UITexture PROGRESS_BAR_LATHE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_lathe.png", true);
    public static final UITexture PROGRESS_BAR_LATHE_BASE = GTGuiTextures.fullImage("textures/gui/progress_bar/progress_bar_lathe_base.png", true);
    public static final UITexture PROGRESS_BAR_MACERATE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_macerate.png", true);
    public static final UITexture PROGRESS_BAR_MACERATE_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_macerate_bronze.png");
    public static final UITexture PROGRESS_BAR_MACERATE_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_macerate_steel.png");
    public static final UITexture PROGRESS_BAR_MAGNET = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_magnet.png", true);
    public static final UITexture PROGRESS_BAR_MASS_FAB = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_mass_fab.png", true);
    public static final UITexture PROGRESS_BAR_MIXER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_mixer.png", true);
    public static final UITexture PROGRESS_BAR_PACKER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_packer.png", true);
    public static final UITexture PROGRESS_BAR_RECYCLER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_recycler.png", true);
    public static final UITexture PROGRESS_BAR_REPLICATOR = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_replicator.png", true);
    public static final UITexture PROGRESS_BAR_SIFT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_sift.png", true);
    public static final UITexture PROGRESS_BAR_SLICE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_slice.png", true);
    public static final UITexture PROGRESS_BAR_UNPACKER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_unpacker.png", true);
    public static final UITexture PROGRESS_BAR_WIREMILL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_wiremill.png", true);
    public static final UITexture PROGRESS_BAR_BOILER_EMPTY_BRONZE = new UITexture.Builder().location("gregtech", "textures/gui/progress_bar/progress_bar_boiler_empty_bronze.png").imageSize(10, 54).adaptable(1).build();
    public static final UITexture PROGRESS_BAR_BOILER_EMPTY_STEEL = new UITexture.Builder().location("gregtech", "textures/gui/progress_bar/progress_bar_boiler_empty_steel.png").imageSize(10, 54).adaptable(1).build();
    public static final UITexture PROGRESS_BAR_BOILER_FUEL_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_boiler_fuel_bronze.png", 18, 36);
    public static final UITexture PROGRESS_BAR_BOILER_FUEL_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_boiler_fuel_steel.png", 18, 36);
    public static final UITexture PROGRESS_BAR_BOILER_HEAT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_boiler_heat.png");
    public static final UITexture PROGRESS_BAR_ASSEMBLY_LINE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_assembly_line.png", 54, 144);
    public static final UITexture PROGRESS_BAR_ASSEMBLY_LINE_ARROW = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_assembly_line_arrow.png", 10, 36);
    public static final UITexture PROGRESS_BAR_COKE_OVEN = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_coke_oven.png", 36, 36);
    public static final UITexture PROGRESS_BAR_DISTILLATION_TOWER = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_distillation_tower.png", 66, 116);
    public static final UITexture PROGRESS_BAR_SOLAR_BRONZE = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_solar_bronze.png", 10, 20);
    public static final UITexture PROGRESS_BAR_SOLAR_STEEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_solar_steel.png", 10, 20);
    public static final UITexture PROGRESS_BAR_RESEARCH_STATION_1 = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_research_station_1.png", 54, 10);
    public static final UITexture PROGRESS_BAR_RESEARCH_STATION_2 = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_research_station_2.png", 10, 36);
    public static final UITexture PROGRESS_BAR_RESEARCH_STATION_BASE = GTGuiTextures.fullImage("textures/gui/progress_bar/progress_bar_research_station_base.png");
    public static final UITexture PROGRESS_BAR_FUSION_ENERGY = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_fusion_energy.png", 94, 14);
    public static final UITexture PROGRESS_BAR_FUSION_HEAT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_fusion_heat.png", 94, 14);
    public static final UITexture PROGRESS_BAR_MULTI_ENERGY_YELLOW = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_multi_energy_yellow.png", 190, 14);
    public static final UITexture PROGRESS_BAR_HPCA_COMPUTATION = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_hpca_computation.png", 94, 14);
    public static final UITexture PROGRESS_BAR_LCE_FUEL = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_lce_fuel.png", 62, 14);
    public static final UITexture PROGRESS_BAR_LCE_LUBRICANT = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_lce_lubricant.png", 62, 14);
    public static final UITexture PROGRESS_BAR_LCE_OXYGEN = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_lce_oxygen.png", 62, 14);
    public static final UITexture PROGRESS_BAR_TURBINE_ROTOR_SPEED = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_turbine_rotor_speed.png", 62, 14);
    public static final UITexture PROGRESS_BAR_TURBINE_ROTOR_DURABILITY = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_turbine_rotor_durability.png", 62, 14);
    public static final UITexture PROGRESS_BAR_FLUID_RIG_DEPLETION = GTGuiTextures.progressBar("textures/gui/progress_bar/progress_bar_fluid_rig_depletion.png", 190, 14);

    public static void init() {
    }

    private static UITexture fullImage(String path) {
        return GTGuiTextures.fullImage(path, false);
    }

    private static UITexture fullImage(String path, boolean canApplyTheme) {
        return UITexture.fullImage((String)"gregtech", (String)path, (boolean)canApplyTheme);
    }

    private static UITexture[] slice(String path, int imageWidth, int imageHeight, int sliceWidth, int sliceHeight, boolean canApplyTheme) {
        if (imageWidth % sliceWidth != 0 || imageHeight % sliceHeight != 0) {
            throw new IllegalArgumentException("Slice height and slice width must divide the image evenly!");
        }
        int countX = imageWidth / sliceWidth;
        int countY = imageHeight / sliceHeight;
        UITexture[] slices = new UITexture[countX * countY];
        for (int indexX = 0; indexX < countX; ++indexX) {
            for (int indexY = 0; indexY < countY; ++indexY) {
                slices[indexX * countX + indexY] = UITexture.builder().location("gregtech", path).canApplyTheme(canApplyTheme).imageSize(imageWidth, imageHeight).uv(indexX * sliceWidth, indexY * sliceHeight, sliceWidth, sliceHeight).build();
            }
        }
        return slices;
    }

    private static UITexture[] slice(String path, int imageWidth, int imageHeight, boolean canApplyTheme) {
        int sliceSize = Math.min(imageWidth, imageHeight);
        return GTGuiTextures.slice(path, imageWidth, imageHeight, sliceSize, sliceSize, canApplyTheme);
    }

    private static IDrawable animated(String path, int imageWidth, int imageHeight, boolean canApplyTheme, int rate) {
        return GTGuiTextures.dynamic(GTGuiTextures.slice(path, imageWidth, imageHeight, canApplyTheme), rate);
    }

    private static UITexture progressBar(String path) {
        return GTGuiTextures.progressBar(path, 20, 40, false);
    }

    private static UITexture progressBar(String path, boolean canApplyTheme) {
        return GTGuiTextures.progressBar(path, 20, 40, canApplyTheme);
    }

    private static UITexture progressBar(String path, int width, int height) {
        return GTGuiTextures.progressBar(path, width, height, false);
    }

    private static UITexture progressBar(String path, int width, int height, boolean canApplyTheme) {
        UITexture.Builder builder = new UITexture.Builder().location("gregtech", path).imageSize(width, height);
        if (canApplyTheme) {
            builder.canApplyTheme();
        }
        return builder.build();
    }

    @NotNull
    public static UITexture getLogo(GTGuiTheme theme) {
        UITexture logo;
        if (theme != null && (logo = theme.getLogo()) != null) {
            return logo;
        }
        return GTValues.XMAS.get() != false ? GREGTECH_LOGO_XMAS : GREGTECH_LOGO;
    }

    public static IDrawable dynamic(final UITexture[] textures, final int rate) {
        return new IDrawable(){
            int tick = 0;
            int index = 0;

            public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
                int a;
                if ((a = this.tick++ % rate) == 0) {
                    ++this.index;
                }
                textures[this.index % textures.length].draw(context, x, y, width, height, widgetTheme);
            }
        };
    }

    public static class IDs {
        public static final String STANDARD_BACKGROUND = IDs.id("standard_bg");
        public static final String COVER_BACKGROUND = IDs.id("cover_bg");
        public static final String BRONZE_BACKGROUND = IDs.id("bronze_bg");
        public static final String STEEL_BACKGROUND = IDs.id("steel_bg");
        public static final String PRIMITIVE_BACKGROUND = IDs.id("primitive_bg");
        public static final String STANDARD_SLOT = IDs.id("standard_slot");
        public static final String BRONZE_SLOT = IDs.id("bronze_slot");
        public static final String STEEL_SLOT = IDs.id("steel_slot");
        public static final String PRIMITIVE_SLOT = IDs.id("primitive_slot");
        public static final String STANDARD_FLUID_SLOT = IDs.id("standard_fluid_slot");
        public static final String STANDARD_BUTTON = IDs.id("standard_button");
        public static final String BRONZE_BUTTON = IDs.id("bronze_button");
        public static final String STEEL_BUTTON = IDs.id("steel_button");
        public static final String BRONZE_BUTTON_SELECTED = IDs.id("bronze_button_sel");
        public static final String STEEL_BUTTON_SELECTED = IDs.id("steel_button_sel");
        public static final String DISPLAY = IDs.id("display");
        public static final String DISPLAY_BRONZE = IDs.id("display_bronze");
        public static final String DISPLAY_STEEL = IDs.id("display_steel");

        private static String id(String path) {
            return "gregtech:" + path;
        }
    }
}

