/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.mui;

import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.utils.serialization.IByteBufDeserializer;
import com.cleanroommc.modularui.utils.serialization.IByteBufSerializer;
import com.cleanroommc.modularui.utils.serialization.IEquals;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.util.NetworkUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class GTByteBufAdapters {
    public static final IByteBufAdapter<ChancedItemOutput> CHANCED_ITEM_OUTPUT = GTByteBufAdapters.makeAdapter(ChancedItemOutput::fromBuffer, ChancedItemOutput::toBuffer);
    public static final IByteBufAdapter<ChancedFluidOutput> CHANCED_FLUID_OUTPUT = GTByteBufAdapters.makeAdapter(ChancedFluidOutput::fromBuffer, ChancedFluidOutput::toBuffer);
    public static final IByteBufAdapter<BigInteger> BIG_INT = GTByteBufAdapters.makeAdapter(buffer -> new BigInteger(buffer.func_179251_a()), (buffer, value) -> buffer.func_179250_a(value.toByteArray()));
    public static final IByteBufAdapter<Fluid> FLUID = GTByteBufAdapters.makeAdapter(NetworkUtil::readFluid, NetworkUtil::writeFluid);

    public static <T> IByteBufAdapter<T> makeAdapter(@NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer) {
        return GTByteBufAdapters.makeAdapter(deserializer, serializer, IEquals.defaultTester());
    }

    public static <T> IByteBufAdapter<T> makeAdapter(final @NotNull IByteBufDeserializer<T> deserializer, final @NotNull IByteBufSerializer<T> serializer, @NotNull IEquals<T> equals) {
        final IEquals<T> tester = Objects.requireNonNull(equals);
        return new IByteBufAdapter<T>(){

            public T deserialize(PacketBuffer buffer) throws IOException {
                return deserializer.deserialize(buffer);
            }

            public void serialize(PacketBuffer buffer, T u) throws IOException {
                serializer.serialize(buffer, u);
            }

            public boolean areEqual(@NotNull T t1, @NotNull T t2) {
                return tester.areEqual(t1, t2);
            }
        };
    }
}

