/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.registry;

import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTControlledRegistry;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class MTERegistry
extends GTControlledRegistry<ResourceLocation, MetaTileEntity> {
    private final String modid;
    private final int networkId;
    private BlockMachine block;

    public MTERegistry(@NotNull String modid, int networkId) {
        super(Short.MAX_VALUE);
        this.modid = modid;
        this.networkId = networkId;
    }

    public void register(int id, @NotNull ResourceLocation key, @NotNull MetaTileEntity value) {
        if (!this.canRegister(key.func_110624_b())) {
            throw new IllegalArgumentException("Cannot register MTE to another mod's registry");
        }
        super.func_177775_a(id, key, value);
    }

    private boolean canRegister(@NotNull String modid) {
        return this.modid.equals(modid);
    }

    @NotNull
    public String getModid() {
        return this.modid;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    @NotNull
    public BlockMachine getBlock() {
        return this.block;
    }

    @ApiStatus.Internal
    public void setBlock(@NotNull BlockMachine block) {
        this.block = block;
    }

    public String toString() {
        return "MTERegistry{modid='" + this.modid + '\'' + ", networkId=" + this.networkId + ", block=" + this.block + '}';
    }
}

