/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.registry;

import gregtech.api.metatileentity.registry.MTERegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public final class MTEManager {
    private static MTEManager instance;
    private static int networkId;
    private static MTERegistry internalRegistry;
    private final Map<String, MTERegistry> registryMap = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<MTERegistry> networkMap = new Int2ObjectOpenHashMap();

    @ApiStatus.Internal
    @NotNull
    public static MTEManager getInstance() {
        if (instance == null) {
            instance = new MTEManager();
            internalRegistry = instance.createRegistry("gregtech");
        }
        return instance;
    }

    private MTEManager() {
    }

    @NotNull
    public MTERegistry getRegistry(@NotNull String modid) {
        MTERegistry registry = this.registryMap.get(modid);
        if (registry == null) {
            throw new IllegalArgumentException("No MTE registry exists for modid " + modid);
        }
        return registry;
    }

    @NotNull
    public MTERegistry createRegistry(@NotNull String modid) {
        if (this.registryMap.containsKey(modid)) {
            throw new IllegalArgumentException("MTE Registry for modid " + modid + " is already registered");
        }
        MTERegistry registry = new MTERegistry(modid, ++networkId);
        this.registryMap.put(modid, registry);
        this.networkMap.put(networkId, (Object)registry);
        return registry;
    }

    @NotNull
    public MTERegistry getRegistry(int networkId) {
        MTERegistry registry = (MTERegistry)((Object)this.networkMap.get(networkId));
        return registry == null ? internalRegistry : registry;
    }

    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull MTERegistry> getRegistries() {
        return this.registryMap.values();
    }

    public static class MTERegistryEvent
    extends Event {
    }
}

