/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock.ui;

import com.cleanroommc.modularui.utils.serialization.ByteBufAdapters;
import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.utils.serialization.IByteBufDeserializer;
import com.cleanroommc.modularui.utils.serialization.IByteBufSerializer;
import gregtech.api.mui.GTByteBufAdapters;
import gregtech.api.util.function.ByteSupplier;
import gregtech.api.util.function.FloatSupplier;
import java.math.BigInteger;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface UISyncer {
    public boolean syncBoolean(@NotNull BooleanSupplier var1);

    public int syncInt(@NotNull IntSupplier var1);

    public long syncLong(@NotNull LongSupplier var1);

    public byte syncByte(@NotNull ByteSupplier var1);

    public double syncDouble(@NotNull DoubleSupplier var1);

    public float syncFloat(@NotNull FloatSupplier var1);

    default public boolean syncBoolean(boolean initial) {
        return this.syncBoolean(() -> initial);
    }

    default public int syncInt(int initial) {
        return this.syncInt(() -> initial);
    }

    default public long syncLong(long initial) {
        return this.syncLong(() -> initial);
    }

    default public byte syncByte(byte initial) {
        return this.syncByte(() -> initial);
    }

    default public double syncDouble(double initial) {
        return this.syncDouble(() -> initial);
    }

    default public float syncFloat(float initial) {
        return this.syncFloat(() -> initial);
    }

    @NotNull
    default public String syncString(@NotNull String initial) {
        return this.syncObject(initial, ByteBufAdapters.STRING);
    }

    default public BigInteger syncBigInt(BigInteger initial) {
        return this.syncObject(initial, GTByteBufAdapters.BIG_INT);
    }

    default public <T> T syncObject(T initial, IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
        return (T)this.syncObject(() -> initial, serializer, deserializer);
    }

    default public <T> T syncObject(T initial, IByteBufAdapter<T> adapter) {
        return this.syncObject(initial, (IByteBufSerializer<T>)adapter, (IByteBufDeserializer<T>)adapter);
    }

    public <T> T syncObject(@NotNull @NotNull Supplier<@NotNull T> var1, IByteBufSerializer<T> var2, IByteBufDeserializer<T> var3);

    default public <T> T syncObject(@NotNull @NotNull Supplier<@NotNull T> initial, IByteBufAdapter<T> adapter) {
        return this.syncObject(initial, (IByteBufSerializer<T>)adapter, (IByteBufDeserializer<T>)adapter);
    }

    public <T, C extends Collection<T>> C syncCollection(C var1, IByteBufSerializer<T> var2, IByteBufDeserializer<T> var3);

    default public <T, C extends Collection<T>> C syncCollection(C initial, IByteBufAdapter<T> adapter) {
        return this.syncCollection(initial, (IByteBufSerializer<T>)adapter, (IByteBufDeserializer<T>)adapter);
    }

    public <T> T[] syncArray(T[] var1, IByteBufSerializer<T> var2, IByteBufDeserializer<T> var3);

    default public <T> T[] syncArray(T[] initial, IByteBufAdapter<T> adapter) {
        return this.syncArray(initial, (IByteBufSerializer<T>)adapter, (IByteBufDeserializer<T>)adapter);
    }

    @NotNull
    default public ItemStack syncItemStack(@NotNull @NotNull Supplier<@NotNull ItemStack> initial) {
        return this.syncObject(initial, ByteBufAdapters.ITEM_STACK);
    }

    @NotNull
    default public ItemStack syncItemStack(@NotNull ItemStack initial) {
        return this.syncItemStack(() -> initial);
    }

    @Nullable
    default public FluidStack syncFluidStack(@NotNull Supplier<@Nullable FluidStack> initial) {
        return this.syncObject(initial, ByteBufAdapters.FLUID_STACK);
    }

    @Nullable
    default public FluidStack syncFluidStack(@Nullable FluidStack initial) {
        return this.syncFluidStack(() -> initial);
    }

    @Nullable
    default public Fluid syncFluid(@NotNull Supplier<@Nullable Fluid> initial) {
        return this.syncObject(initial, GTByteBufAdapters.FLUID);
    }

    @Nullable
    default public Fluid syncFluid(@Nullable Fluid initial) {
        return this.syncFluid(() -> initial);
    }
}

