/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock.ui;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IDistinctBusController;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.GTLambdaUtils;
import gregtech.common.mui.widget.ScrollableTextWidget;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockUIFactory {
    private static final Consumer<MultiblockUIBuilder> NO_OP = b -> {};
    private static final IBoolValue<Boolean> ALWAYS_ON = new BoolValue.Dynamic(() -> true, b -> {});
    private final MultiblockWithDisplayBase mte;
    protected Consumer<MultiblockUIBuilder> displayText;
    protected Consumer<MultiblockUIBuilder> warningText;
    protected Consumer<MultiblockUIBuilder> errorText;
    protected BiFunction<PosGuiData, PanelSyncManager, IWidget> flexButton = (guiData, syncManager) -> null;
    private int width = 198;
    private int height = 202;
    private int screenHeight = 109;
    private ScreenFunction screenFunction;
    private boolean disableDisplay = false;
    private boolean disableIndicator = false;
    private boolean disableButtons = false;

    public MultiblockUIFactory(@NotNull MultiblockWithDisplayBase mte) {
        this.mte = mte;
        this.configureDisplayText(builder -> builder.title(mte.getMetaFullName()).structureFormed(mte.isStructureFormed()));
    }

    private Widget<?> createIndicator(PanelSyncManager syncManager) {
        if (this.warningText == NO_OP && this.errorText == NO_OP) {
            return ((Widget)((Widget)new Widget().debugName("indicator_none").size(18)).pos(169, this.screenHeight - 18 - 3)).overlay(new IDrawable[]{GTGuiTextures.GREGTECH_LOGO_DARK});
        }
        MultiblockUIBuilder error = MultiblockUIFactory.builder();
        error.sync("error", syncManager);
        error.setAction(this.errorText);
        MultiblockUIBuilder warning = MultiblockUIFactory.builder();
        warning.sync("warning", syncManager);
        warning.setAction(this.warningText);
        warning.onRebuild(() -> warning.updateFormed(this.mte.isStructureFormed()));
        DynamicDrawable indicator = new DynamicDrawable(() -> {
            if (!error.isEmpty()) {
                return GTGuiTextures.GREGTECH_LOGO_BLINKING_RED;
            }
            if (!warning.isEmpty()) {
                return GTGuiTextures.GREGTECH_LOGO_BLINKING_YELLOW;
            }
            return GTGuiTextures.GREGTECH_LOGO_DARK;
        });
        return (Widget)((Widget)((Widget)((Widget)new Widget().debugName("indicator").size(18)).pos(169, this.screenHeight - 18 - 3)).overlay(new IDrawable[]{indicator}).tooltipAutoUpdate(true)).tooltipBuilder(t -> {
            if (!error.isEmpty()) {
                error.build((IRichTextBuilder<?>)t);
            } else if (!warning.isEmpty()) {
                warning.build((IRichTextBuilder<?>)t);
            }
        });
    }

    public MultiblockUIFactory configureWarningText(boolean merge, Consumer<MultiblockUIBuilder> warningText) {
        this.warningText = merge ? GTLambdaUtils.mergeConsumers(this.warningText, warningText) : warningText;
        return this;
    }

    public MultiblockUIFactory configureWarningText(Consumer<MultiblockUIBuilder> warningText) {
        return this.configureWarningText(true, warningText);
    }

    public MultiblockUIFactory disableWarningText() {
        this.warningText = NO_OP;
        return this;
    }

    public MultiblockUIFactory configureErrorText(boolean merge, Consumer<MultiblockUIBuilder> errorText) {
        this.errorText = merge ? GTLambdaUtils.mergeConsumers(this.errorText, errorText) : errorText;
        return this;
    }

    public MultiblockUIFactory configureErrorText(Consumer<MultiblockUIBuilder> errorText) {
        return this.configureErrorText(true, errorText);
    }

    public MultiblockUIFactory disableErrorText() {
        this.errorText = NO_OP;
        return this;
    }

    public MultiblockUIFactory configureDisplayText(boolean merge, Consumer<MultiblockUIBuilder> displayText) {
        this.displayText = merge ? GTLambdaUtils.mergeConsumers(this.displayText, displayText) : displayText;
        return this;
    }

    public MultiblockUIFactory configureDisplayText(Consumer<MultiblockUIBuilder> displayText) {
        return this.configureDisplayText(true, displayText);
    }

    public MultiblockUIFactory disableDisplayText() {
        this.displayText = NO_OP;
        return this;
    }

    public MultiblockUIFactory disableDisplay() {
        this.disableDisplayText();
        this.disableDisplay = true;
        return this.disableIndicator();
    }

    public MultiblockUIFactory disableIndicator() {
        this.disableWarningText();
        this.disableErrorText();
        this.disableIndicator = true;
        return this;
    }

    public MultiblockUIFactory disableButtons() {
        this.disableButtons = true;
        return this;
    }

    public MultiblockUIFactory createFlexButton(BiFunction<PosGuiData, PanelSyncManager, IWidget> flexButton) {
        this.flexButton = flexButton;
        return this;
    }

    public MultiblockUIFactory setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public MultiblockUIFactory setScreenHeight(int height) {
        int diff = height - this.screenHeight;
        this.height += diff;
        this.screenHeight += diff;
        return this;
    }

    public MultiblockUIFactory addScreenChildren(ScreenFunction function) {
        this.screenFunction = function;
        return this;
    }

    @NotNull
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager panelSyncManager) {
        ProgressBarMultiblock progressBarMultiblock;
        ModularPanel panel = (ModularPanel)((ModularPanel)GTGuis.createPanel(this.mte, this.width, this.height).debugName("root_panel")).childIf(!this.disableDisplay, () -> this.createScreen(panelSyncManager));
        MultiblockWithDisplayBase multiblockWithDisplayBase = this.mte;
        if (multiblockWithDisplayBase instanceof ProgressBarMultiblock && (progressBarMultiblock = (ProgressBarMultiblock)((Object)multiblockWithDisplayBase)).hasBars()) {
            panel.height(this.height + Bars.HEIGHT * MultiblockUIFactory.calculateRows(progressBarMultiblock.getProgressBarCount()) - 2);
            panel.child((IWidget)this.createBars(progressBarMultiblock, panelSyncManager));
        }
        if (this.disableDisplay && this.screenFunction != null) {
            this.screenFunction.addWidgets((ParentWidget<?>)panel, panelSyncManager);
        }
        SlotGroupWidget playerInv = SlotGroupWidget.playerInventory((int)0);
        if (this.disableButtons) {
            playerInv.alignX(0.5f);
        } else {
            playerInv.left(4);
        }
        return (ModularPanel)panel.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().debugName("bottom_row")).bottom(7)).coverChildrenHeight()).margin(4, 0)).crossAxisAlignment(Alignment.CrossAxis.CENTER).child((IWidget)playerInv)).childIf(!this.disableButtons, () -> this.createButtons(panel, panelSyncManager, guiData)));
    }

    private static int calculateRows(int count) {
        if (count <= 3) {
            return 1;
        }
        if (count <= 8) {
            return 2;
        }
        throw new UnsupportedOperationException("Cannot compute progress bar rows for count " + count);
    }

    private static int calculateCols(int count, int row) {
        int n;
        switch (count) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                n = count;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                if (row == 0) {
                    n = 3;
                    break;
                }
                n = 2;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 7: {
                if (row == 0) {
                    n = 4;
                    break;
                }
                n = 3;
                break;
            }
            case 8: {
                n = 4;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot compute progress bar cols for count " + count);
            }
        }
        return n;
    }

    @Nullable
    protected Flow createBars(@NotNull ProgressBarMultiblock progressMulti, @NotNull PanelSyncManager panelSyncManager) {
        int count = progressMulti.getProgressBarCount();
        int calculatedRows = MultiblockUIFactory.calculateRows(count);
        Flow column = (Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().debugName("bar_col")).margin(4, 0)).top(5 + this.screenHeight)).widthRel(1.0f)).height(Bars.HEIGHT * calculatedRows);
        ArrayList<UnaryOperator<TemplateBarBuilder>> barBuilders = new ArrayList<UnaryOperator<TemplateBarBuilder>>(progressMulti.getProgressBarCount());
        progressMulti.registerBars(barBuilders, panelSyncManager);
        for (int r = 0; r < calculatedRows; ++r) {
            int calculatedCols = MultiblockUIFactory.calculateCols(count, r);
            Flow row = (Flow)((Flow)((Flow)Flow.row().debugName("bar_row:" + r)).widthRel(1.0f)).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).height(Bars.HEIGHT);
            int from = r * (count - calculatedCols);
            int to = from + calculatedCols;
            int barCount = Math.max(1, to - from);
            int barWidth = Bars.FULL_WIDTH / barCount - (barCount - 1);
            for (int i = from; i < to; ++i) {
                ProgressWidget widget = i < barBuilders.size() ? ((TemplateBarBuilder)((UnaryOperator)barBuilders.get(i)).apply(new TemplateBarBuilder())).build() : (ProgressWidget)((ProgressWidget)new ProgressWidget().addTooltipLine("Error! no bar for index: " + i)).background(new IDrawable[]{new Rectangle().setColor(Color.RED.main)});
                row.child((IWidget)((ProgressWidget)((ProgressWidget)widget.size(barWidth, Bars.HEIGHT)).debugName(this.mte.getClass().getSimpleName() + ":bar:" + i)).direction(ProgressWidget.Direction.RIGHT));
            }
            column.child((IWidget)row);
        }
        return column;
    }

    protected Widget<?> createScreen(PanelSyncManager syncManager) {
        ParentWidget parent = new ParentWidget();
        if (this.displayText != NO_OP) {
            MultiblockUIBuilder display = MultiblockUIFactory.builder();
            display.setAction(this.displayText);
            display.sync("display", syncManager);
            parent.child((IWidget)((ScrollableTextWidget)((ScrollableTextWidget)((ScrollableTextWidget)((ScrollableTextWidget)new ScrollableTextWidget().debugName("display_text")).sizeRel(1.0f)).alignment(Alignment.TopLeft)).margin(4, 4)).autoUpdate(true).textBuilder(display::build));
        }
        if (this.screenFunction != null) {
            this.screenFunction.addWidgets(parent, syncManager);
        }
        return (Widget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)parent.childIf(!this.disableIndicator, () -> this.createIndicator(syncManager))).debugName("display_root")).background(new IDrawable[]{this.getDisplayBackground()})).size(190, this.screenHeight)).pos(4, 4);
    }

    private UITexture getDisplayBackground() {
        return this.mte.getUITheme().getDisplayBackground();
    }

    @NotNull
    protected Flow createButtons(@NotNull ModularPanel mainPanel, @NotNull PanelSyncManager panelSyncManager, PosGuiData guiData) {
        IWidget flexButton = this.flexButton.apply(guiData, panelSyncManager);
        if (flexButton == null) {
            flexButton = (IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().debugName("flex_none")).value(ALWAYS_ON).overlay(new IDrawable[]{GTGuiTextures.OVERLAY_NO_FLEX})).size(18)).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.multiblock.universal.no_flex_button"));
        }
        Widget<?> powerButton = this.createPowerButton(mainPanel, panelSyncManager);
        return (Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().debugName("button_col")).right(4)).coverChildren()).child(this.createDistinctButton(mainPanel, panelSyncManager))).child(this.createVoidingButton(mainPanel, panelSyncManager))).child(flexButton)).childIf(powerButton != null, powerButton);
    }

    protected IWidget createDistinctButton(@NotNull ModularPanel mainPanel, @NotNull PanelSyncManager panelSyncManager) {
        IDistinctBusController distinct;
        MultiblockWithDisplayBase multiblockWithDisplayBase = this.mte;
        if (!(multiblockWithDisplayBase instanceof IDistinctBusController) || !(distinct = (IDistinctBusController)((Object)multiblockWithDisplayBase)).canBeDistinct()) {
            return (IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().debugName("distinct_none")).value(ALWAYS_ON).size(18)).overlay(new IDrawable[]{GTGuiTextures.OVERLAY_DISTINCT_BUSES[0]})).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.multiblock.universal.distinct_not_supported"));
        }
        return ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().debugName("distinct_button")).size(18)).value((IBoolValue)new BooleanSyncValue(distinct::isDistinct, distinct::setDistinct)).disableHoverBackground()).overlay(true, new IDrawable[]{GTGuiTextures.OVERLAY_DISTINCT_BUSES[1]}).overlay(false, new IDrawable[]{GTGuiTextures.OVERLAY_DISTINCT_BUSES[0]}).addTooltip(true, (IDrawable)IKey.lang((String)"gregtech.multiblock.universal.distinct_enabled")).addTooltip(false, (IDrawable)IKey.lang((String)"gregtech.multiblock.universal.distinct_disabled"));
    }

    protected IWidget createVoidingButton(@NotNull ModularPanel mainPanel, @NotNull PanelSyncManager panelSyncManager) {
        if (!this.mte.shouldShowVoidingModeButton()) {
            return (IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().debugName("voiding_none")).value(ALWAYS_ON).size(18)).overlay(new IDrawable[]{GTGuiTextures.OVERLAY_VOID_NONE})).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.gui.multiblock_voiding_not_supported"));
        }
        IntSyncValue voidingValue = new IntSyncValue(this.mte::getVoidingMode, this.mte::setVoidingMode);
        return (IWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().debugName("voiding_button")).size(18)).value((IIntValue)voidingValue).length(4).stateOverlay(0, (IDrawable)GTGuiTextures.MULTIBLOCK_VOID[0]).stateOverlay(1, (IDrawable)GTGuiTextures.MULTIBLOCK_VOID[1]).stateOverlay(2, (IDrawable)GTGuiTextures.MULTIBLOCK_VOID[2]).stateOverlay(3, (IDrawable)GTGuiTextures.MULTIBLOCK_VOID[3]).tooltipBuilder(t -> t.addLine((IDrawable)IKey.lang((String)this.mte.getVoidingModeTooltip(voidingValue.getIntValue()))));
    }

    @Nullable
    protected Widget<?> createPowerButton(@NotNull ModularPanel mainPanel, @NotNull PanelSyncManager panelSyncManager) {
        MultiblockWithDisplayBase multiblockWithDisplayBase = this.mte;
        if (multiblockWithDisplayBase instanceof IControllable) {
            IControllable controllable = (IControllable)((Object)multiblockWithDisplayBase);
            Icon detail = GTGuiTextures.BUTTON_POWER_DETAIL.asIcon().size(18, 6).marginTop(24);
            BooleanSyncValue controllableSync = new BooleanSyncValue(controllable::isWorkingEnabled, controllable::setWorkingEnabled);
            return (Widget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().debugName("power_button")).size(18)).disableHoverBackground()).overlay(true, new IDrawable[]{detail, GTGuiTextures.BUTTON_POWER[1]}).overlay(false, new IDrawable[]{detail, GTGuiTextures.BUTTON_POWER[0]}).value((IBoolValue)controllableSync).marginTop(4);
        }
        return null;
    }

    public static MultiblockUIBuilder builder() {
        return new MultiblockUIBuilder();
    }

    public static MultiblockUIBuilder builder(String key, PanelSyncManager syncManager) {
        MultiblockUIBuilder b = MultiblockUIFactory.builder();
        b.sync(key, syncManager);
        return b;
    }

    @FunctionalInterface
    public static interface ScreenFunction {
        public void addWidgets(ParentWidget<?> var1, PanelSyncManager var2);
    }

    public static final class Bars {
        public static int FULL_WIDTH = Screen.WIDTH;
        public static int HEIGHT = 7;

        private Bars() {
        }
    }

    public static final class Screen {
        public static int WIDTH = 190;

        private Screen() {
        }
    }
}

