/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock.ui;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.utils.serialization.ByteBufAdapters;
import com.cleanroommc.modularui.utils.serialization.IByteBufDeserializer;
import com.cleanroommc.modularui.utils.serialization.IByteBufSerializer;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.ComputationRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.Operation;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.mui.GTByteBufAdapters;
import gregtech.api.mui.drawable.GTObjectDrawable;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTHashMaps;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.util.function.ByteSupplier;
import gregtech.api.util.function.FloatSupplier;
import gregtech.common.ConfigHolder;
import gregtech.common.items.ToolItems;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockUIBuilder {
    private final List<Operation> operations = new ArrayList<Operation>();
    private Consumer<MultiblockUIBuilder> action;
    private final InternalSyncHandler syncHandler = new InternalSyncHandler();
    private static final int DEFAULT_MAX_RECIPE_LINES = 25;
    @Nullable
    private InternalSyncer syncer;
    private boolean isWorkingEnabled;
    private boolean isActive;
    private boolean isStructureFormed;
    private IKey idlingKey = IKey.lang((String)"gregtech.multiblock.idling").style(TextFormatting.GRAY);
    private IKey pausedKey = IKey.lang((String)"gregtech.multiblock.work_paused").style(TextFormatting.GOLD);
    private IKey runningKey = IKey.lang((String)"gregtech.multiblock.running").style(TextFormatting.GREEN);
    private boolean dirty;
    private Runnable onRebuild;

    @NotNull
    InternalSyncer getSyncer() {
        if (this.syncer == null) {
            this.syncer = new InternalSyncer(this.isServer());
        }
        return this.syncer;
    }

    void updateFormed(boolean isStructureFormed) {
        this.isStructureFormed = this.getSyncer().syncBoolean(isStructureFormed);
    }

    private boolean isServer() {
        return !this.syncHandler.getSyncManager().isClient();
    }

    public MultiblockUIBuilder structureFormed(boolean structureFormed) {
        this.updateFormed(structureFormed);
        if (!this.isStructureFormed) {
            IKey base = KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.invalid_structure", new Object[0]);
            IKey hover = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.invalid_structure.tooltip", new Object[0]);
            this.addHoverableKey(base, new IDrawable[]{hover});
        }
        return this;
    }

    public MultiblockUIBuilder title(String lang) {
        this.addKey((IDrawable)KeyUtil.lang(TextFormatting.WHITE, lang, new Object[0]));
        return this;
    }

    public MultiblockUIBuilder setWorkingStatus(boolean isWorkingEnabled, boolean isActive) {
        this.isWorkingEnabled = this.getSyncer().syncBoolean(isWorkingEnabled);
        this.isActive = this.getSyncer().syncBoolean(isActive);
        return this;
    }

    public MultiblockUIBuilder setWorkingStatusKeys(String idlingKey, String pausedKey, String runningKey) {
        if (idlingKey != null) {
            this.idlingKey = IKey.lang((String)idlingKey).style(TextFormatting.GRAY);
        }
        if (pausedKey != null) {
            this.pausedKey = IKey.lang((String)pausedKey).style(TextFormatting.GOLD);
        }
        if (runningKey != null) {
            this.runningKey = IKey.lang((String)runningKey).style(TextFormatting.GREEN);
        }
        return this;
    }

    public MultiblockUIBuilder addEnergyUsageLine(IEnergyContainer energyContainer) {
        if (!this.isStructureFormed) {
            return this;
        }
        long capacity = this.getSyncer().syncLong(() -> energyContainer.getEnergyCapacity());
        long inV = this.getSyncer().syncLong(() -> energyContainer.getInputVoltage());
        long outV = this.getSyncer().syncLong(() -> energyContainer.getOutputVoltage());
        if (capacity <= 0L) {
            return this;
        }
        long maxVoltage = Math.max(inV, outV);
        byte tier = GTUtility.getFloorTierByVoltage(maxVoltage);
        IKey bodyText = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick", KeyUtil.number(maxVoltage), KeyUtil.string(GTValues.VOCNF[tier]));
        IKey hoverText = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick_hover", new Object[0]);
        this.addHoverableKey(bodyText, new IDrawable[]{hoverText});
        return this;
    }

    public MultiblockUIBuilder addEnergyTierLine(int tier) {
        if (!this.isStructureFormed) {
            return this;
        }
        tier = this.getSyncer().syncInt(tier);
        if (tier < 0 || tier > 30) {
            return this;
        }
        IKey bodyText = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.max_recipe_tier", GTValues.VOCNF[tier]);
        IKey hoverText = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.max_recipe_tier_hover", new Object[0]);
        this.addHoverableKey(bodyText, new IDrawable[]{hoverText});
        return this;
    }

    public MultiblockUIBuilder addEnergyUsageExactLine(long energyUsage) {
        if (!this.isStructureFormed) {
            return this;
        }
        energyUsage = this.getSyncer().syncLong(energyUsage);
        if (energyUsage > 0L) {
            String energyFormatted = TextFormattingUtil.formatNumbers(energyUsage);
            byte tier = GTUtility.getOCTierByVoltage(energyUsage);
            IKey voltageName = KeyUtil.string(GTValues.VOCNF[tier]);
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.energy_consumption", energyFormatted, voltageName));
        }
        return this;
    }

    public MultiblockUIBuilder addEnergyProductionLine(long maxVoltage, long recipeEUt) {
        if (!this.isStructureFormed) {
            return this;
        }
        maxVoltage = this.getSyncer().syncLong(maxVoltage);
        recipeEUt = this.getSyncer().syncLong(recipeEUt);
        if (maxVoltage != 0L && maxVoltage >= recipeEUt) {
            String energyFormatted = TextFormattingUtil.formatNumbers(maxVoltage);
            byte tier = GTUtility.getFloorTierByVoltage(maxVoltage);
            IKey voltageName = KeyUtil.string(GTValues.VOCNF[tier]);
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick", energyFormatted, voltageName));
        }
        return this;
    }

    public MultiblockUIBuilder addEnergyProductionAmpsLine(long maxVoltage, int amperage) {
        if (!this.isStructureFormed) {
            return this;
        }
        maxVoltage = this.getSyncer().syncLong(maxVoltage);
        amperage = this.getSyncer().syncInt(amperage);
        if (maxVoltage != 0L && amperage != 0) {
            String energyFormatted = TextFormattingUtil.formatNumbers(maxVoltage);
            byte tier = GTUtility.getFloorTierByVoltage(maxVoltage);
            IKey voltageName = KeyUtil.string(GTValues.VOCNF[tier]);
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.max_energy_per_tick_amps", energyFormatted, amperage, voltageName));
        }
        return this;
    }

    public MultiblockUIBuilder addComputationUsageLine(int maxCWUt) {
        if (!this.isStructureFormed) {
            return this;
        }
        maxCWUt = this.getSyncer().syncInt(maxCWUt);
        if (maxCWUt > 0) {
            IKey computation = KeyUtil.number(TextFormatting.AQUA, (long)maxCWUt);
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.computation.max", computation));
        }
        return this;
    }

    public MultiblockUIBuilder addComputationUsageExactLine(int currentCWUt) {
        if (!this.isStructureFormed) {
            return this;
        }
        currentCWUt = this.getSyncer().syncInt(currentCWUt);
        if (this.isActive && currentCWUt > 0) {
            IKey computation = KeyUtil.number(TextFormatting.AQUA, (long)currentCWUt, " CWU/t");
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.computation.usage", computation));
        }
        return this;
    }

    public MultiblockUIBuilder addWorkingStatusLine() {
        if (!this.isStructureFormed) {
            return this;
        }
        if (!this.isWorkingEnabled) {
            this.addKey((IDrawable)this.pausedKey);
        } else if (this.isActive) {
            this.addKey((IDrawable)this.runningKey);
        } else {
            this.addKey((IDrawable)this.idlingKey);
        }
        return this;
    }

    public MultiblockUIBuilder addWorkPausedLine(boolean checkState) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (!checkState || !this.isWorkingEnabled) {
            this.addKey((IDrawable)this.pausedKey);
        }
        return this;
    }

    public MultiblockUIBuilder addRunningPerfectlyLine(boolean checkState) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (!checkState || this.isActive) {
            this.addKey((IDrawable)this.runningKey);
        }
        return this;
    }

    public MultiblockUIBuilder addIdlingLine(boolean checkState) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (!checkState || this.isWorkingEnabled && !this.isActive) {
            this.addKey((IDrawable)this.idlingKey);
        }
        return this;
    }

    public MultiblockUIBuilder addProgressLine(int progress, int maxProgress) {
        if (!this.isStructureFormed || !this.isActive) {
            return this;
        }
        progress = this.getSyncer().syncInt(progress);
        maxProgress = this.getSyncer().syncInt(maxProgress);
        if (maxProgress <= 20) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.recipe_progress.ticks", String.format("%02d", progress), String.format("%02d", maxProgress), Float.valueOf((float)progress / (float)maxProgress * 100.0f)));
        } else {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.recipe_progress.seconds", Float.valueOf((float)progress / 20.0f), Float.valueOf((float)maxProgress / 20.0f), Float.valueOf((float)progress / (float)maxProgress * 100.0f)));
        }
        return this;
    }

    public MultiblockUIBuilder addComputationProgressLine(ComputationRecipeLogic crl) {
        if (!this.isStructureFormed || !this.isActive) {
            return this;
        }
        int progress = this.getSyncer().syncInt(crl.getProgress());
        int maxProgress = this.getSyncer().syncInt(crl.getMaxProgress());
        int maxCwu = this.getSyncer().syncInt(() -> crl.getComputationProvider().getMaxCWUt());
        if (crl.shouldShowDuration()) {
            this.addKey((IDrawable)IKey.str((String)"%s / %s CWU", (Object[])new Object[]{KeyUtil.number(progress), KeyUtil.number(maxProgress)}).style(TextFormatting.GRAY));
        } else {
            int cwuRate = this.getSyncer().syncInt(crl.getCurrentDrawnCWUt());
            int n = progress * cwuRate;
        }
        return this;
    }

    public MultiblockUIBuilder addParallelsLine(int numParallels) {
        if (!this.isStructureFormed) {
            return this;
        }
        numParallels = this.getSyncer().syncInt(numParallels);
        if (numParallels > 1) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.parallel", KeyUtil.number(TextFormatting.DARK_PURPLE, (long)numParallels)));
        }
        return this;
    }

    public MultiblockUIBuilder addLowPowerLine(@NotNull BooleanSupplier isLowPower) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (this.getSyncer().syncBoolean(isLowPower)) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.not_enough_energy", new Object[0]));
        }
        return this;
    }

    public MultiblockUIBuilder addLowPowerLine(boolean isLowPower) {
        return this.addLowPowerLine(() -> isLowPower);
    }

    public MultiblockUIBuilder addLowComputationLine(boolean isLowComputation) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (this.getSyncer().syncBoolean(isLowComputation)) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.computation.not_enough_computation", new Object[0]));
        }
        return this;
    }

    public MultiblockUIBuilder addLowDynamoTierLine(boolean isTooLow) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (this.getSyncer().syncBoolean(isTooLow)) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.not_enough_energy_output", new Object[0]));
        }
        return this;
    }

    public MultiblockUIBuilder addMaintenanceProblemLines(byte maintenanceProblems, boolean warning) {
        if (!this.isStructureFormed || !ConfigHolder.machines.enableMaintenance) {
            return this;
        }
        maintenanceProblems = this.getSyncer().syncByte(maintenanceProblems);
        if (warning && maintenanceProblems < 63 && maintenanceProblems > 0 || !warning && maintenanceProblems == 0) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.has_problems", new Object[0]));
            if ((maintenanceProblems & 1) == 0) {
                this.addOperation(richText -> richText.add((IDrawable)new ItemDrawable(ToolItems.WRENCH.get(Materials.Iron))).add((IDrawable)IKey.SPACE).add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.problem.wrench", new Object[0])).newLine());
            }
            if ((maintenanceProblems >> 1 & 1) == 0) {
                this.addOperation(richText -> richText.add((IDrawable)new ItemDrawable(ToolItems.SCREWDRIVER.get(Materials.Iron))).add((IDrawable)IKey.SPACE).add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.problem.screwdriver", new Object[0])).newLine());
            }
            if ((maintenanceProblems >> 2 & 1) == 0) {
                this.addOperation(richText -> richText.add((IDrawable)new ItemDrawable(ToolItems.SOFT_MALLET.get(Materials.Wood))).add((IDrawable)IKey.SPACE).add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.problem.soft_mallet", new Object[0])).newLine());
            }
            if ((maintenanceProblems >> 3 & 1) == 0) {
                this.addOperation(richText -> richText.add((IDrawable)new ItemDrawable(ToolItems.HARD_HAMMER.get(Materials.Iron))).add((IDrawable)IKey.SPACE).add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.problem.hard_hammer", new Object[0])).newLine());
            }
            if ((maintenanceProblems >> 4 & 1) == 0) {
                this.addOperation(richText -> richText.add((IDrawable)new ItemDrawable(ToolItems.WIRE_CUTTER.get(Materials.Iron))).add((IDrawable)IKey.SPACE).add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.problem.wire_cutter", new Object[0])).newLine());
            }
            if ((maintenanceProblems >> 5 & 1) == 0) {
                this.addOperation(richText -> richText.add((IDrawable)new ItemDrawable(ToolItems.CROWBAR.get(Materials.Iron))).add((IDrawable)IKey.SPACE).add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.universal.problem.crowbar", new Object[0])).newLine());
            }
        }
        return this;
    }

    public MultiblockUIBuilder addMufflerObstructedLine(boolean isObstructed) {
        if (!this.isStructureFormed) {
            return this;
        }
        if (this.getSyncer().syncBoolean(isObstructed)) {
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.universal.muffler_obstructed", new Object[0]));
            this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.universal.muffler_obstructed_desc", new Object[0]));
        }
        return this;
    }

    public MultiblockUIBuilder addFuelNeededLine(String fuelAmount, int previousRecipeDuration) {
        if (!this.isStructureFormed || !this.isActive) {
            return this;
        }
        fuelAmount = this.getSyncer().syncString(fuelAmount);
        previousRecipeDuration = this.getSyncer().syncInt(previousRecipeDuration);
        this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.turbine.fuel_needed", KeyUtil.string(TextFormatting.RED, fuelAmount), KeyUtil.number(TextFormatting.AQUA, (long)previousRecipeDuration)));
        return this;
    }

    public MultiblockUIBuilder addRecipeMapLine(RecipeMap<?> map) {
        if (!this.isStructureFormed) {
            return this;
        }
        IKey mapName = KeyUtil.lang(TextFormatting.YELLOW, map.getTranslationKey(), new Object[0]);
        this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.machine_mode", mapName));
        return this;
    }

    public MultiblockUIBuilder addRecipeOutputLine(@NotNull AbstractRecipeLogic arl) {
        return this.addRecipeOutputLine(arl, 25);
    }

    public MultiblockUIBuilder addRecipeOutputLine(AbstractRecipeLogic arl, int maxLines) {
        int p;
        Recipe recipe = arl.getPreviousRecipe();
        if (this.getSyncer().syncBoolean(recipe == null)) {
            return this;
        }
        RecipeMap<?> map = arl.getRecipeMap();
        if (this.getSyncer().syncBoolean(map == null)) {
            return this;
        }
        Recipe trimmed = null;
        if (this.isServer()) {
            MetaTileEntity mte = arl.getMetaTileEntity();
            trimmed = Recipe.trimRecipeOutputs(recipe, map, mte.getItemOutputLimit(), mte.getFluidOutputLimit());
        }
        if ((p = this.getSyncer().syncInt(arl.getParallelRecipesPerformed())) == 0) {
            p = 1;
        }
        long eut = this.getSyncer().syncLong(trimmed == null ? 0L : trimmed.getEUt());
        long maxVoltage = this.getSyncer().syncLong(arl.getMaximumOverclockVoltage());
        int maxProgress = this.getSyncer().syncInt(arl.getMaxProgress());
        if (maxProgress == 0) {
            return this;
        }
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
        List chancedItemOutputs = new ArrayList<ChancedItemOutput>();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        List chancedFluidOutputs = new ArrayList<ChancedFluidOutput>();
        if (this.isServer()) {
            itemOutputs.addAll(trimmed.getOutputs());
            chancedItemOutputs.addAll(trimmed.getChancedOutputs().getChancedEntries());
            fluidOutputs.addAll(trimmed.getFluidOutputs());
            chancedFluidOutputs.addAll(trimmed.getChancedFluidOutputs().getChancedEntries());
        }
        itemOutputs = this.getSyncer().syncCollection(itemOutputs, ByteBufAdapters.ITEM_STACK);
        fluidOutputs = this.getSyncer().syncCollection(fluidOutputs, ByteBufAdapters.FLUID_STACK);
        chancedItemOutputs = this.getSyncer().syncCollection(chancedItemOutputs, GTByteBufAdapters.CHANCED_ITEM_OUTPUT);
        chancedFluidOutputs = this.getSyncer().syncCollection(chancedFluidOutputs, GTByteBufAdapters.CHANCED_FLUID_OUTPUT);
        this.addKey((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.gui.multiblock.recipe_producing", new Object[0]), Operation::addLine);
        byte recipeTier = GTUtility.getTierByVoltage(eut);
        byte machineTier = GTUtility.getOCTierByVoltage(maxVoltage);
        Object2IntMap<ItemStack> itemMap = GTHashMaps.fromItemStackCollection(itemOutputs);
        for (ItemStack stack : itemMap.keySet()) {
            this.addItemOutputLine(stack, (long)itemMap.getInt((Object)stack) * (long)p, maxProgress);
        }
        for (ChancedItemOutput chancedItemOutput : chancedItemOutputs) {
            int chance = this.getSyncer().syncInt(() -> map.chanceFunction.getBoostedChance(chancedItemOutput, recipeTier, machineTier));
            int count = ((ItemStack)chancedItemOutput.getIngredient()).func_190916_E() * p;
            this.addChancedItemOutputLine(chancedItemOutput, count, chance, maxProgress);
        }
        Object2IntMap<FluidStack> fluidMap = GTHashMaps.fromFluidCollection(fluidOutputs);
        for (FluidStack stack : fluidMap.keySet()) {
            this.addFluidOutputLine(stack, fluidMap.getInt((Object)stack), maxProgress);
        }
        for (ChancedFluidOutput chancedFluidOutput : chancedFluidOutputs) {
            int chance = this.getSyncer().syncInt(() -> map.chanceFunction.getBoostedChance(chancedFluidOutput, recipeTier, machineTier));
            int count = ((FluidStack)chancedFluidOutput.getIngredient()).amount * p;
            this.addChancedFluidOutputLine(chancedFluidOutput, count, chance, maxProgress);
        }
        return this;
    }

    private void addItemOutputLine(@NotNull ItemStack stack, long count, int recipeLength) {
        IKey name = KeyUtil.string(TextFormatting.AQUA, stack.func_82833_r());
        IKey amount = KeyUtil.number(TextFormatting.GOLD, count);
        IKey rate = KeyUtil.string(TextFormatting.WHITE, MultiblockUIBuilder.formatRecipeRate(this.getSyncer().syncInt(recipeLength), count));
        this.addKey((IDrawable)new GTObjectDrawable(stack, count).asIcon().asHoverable().addTooltipLine((IDrawable)MultiblockUIBuilder.formatRecipeData(name, amount, rate)), Operation::add);
    }

    private void addFluidOutputLine(@NotNull FluidStack stack, long count, int recipeLength) {
        IKey name = KeyUtil.fluid(TextFormatting.AQUA, stack);
        IKey amount = KeyUtil.number(TextFormatting.GOLD, count);
        IKey rate = KeyUtil.string(TextFormatting.WHITE, MultiblockUIBuilder.formatRecipeRate(this.getSyncer().syncInt(recipeLength), count));
        this.addKey((IDrawable)new GTObjectDrawable(stack, count).asIcon().asHoverable().addTooltipLine((IDrawable)MultiblockUIBuilder.formatRecipeData(name, amount, rate)), Operation::add);
    }

    private void addChancedItemOutputLine(@NotNull ChancedItemOutput output, int count, int chance, int recipeLength) {
        IKey name = KeyUtil.string(TextFormatting.AQUA, ((ItemStack)output.getIngredient()).func_82833_r());
        IKey amount = KeyUtil.number(TextFormatting.GOLD, (long)count);
        IKey rate = KeyUtil.string(TextFormatting.WHITE, MultiblockUIBuilder.formatRecipeRate(this.getSyncer().syncInt(recipeLength), count));
        this.addKey((IDrawable)new GTObjectDrawable(output, count).setBoostFunction(entry -> chance).asIcon().asHoverable().addTooltipLine((IDrawable)MultiblockUIBuilder.formatRecipeData(name, amount, rate)), Operation::add);
    }

    private void addChancedFluidOutputLine(ChancedFluidOutput output, int count, int chance, int recipeLength) {
        IKey name = KeyUtil.fluid(TextFormatting.AQUA, (FluidStack)output.getIngredient());
        IKey amount = KeyUtil.number(TextFormatting.GOLD, (long)count);
        IKey rate = KeyUtil.string(TextFormatting.WHITE, MultiblockUIBuilder.formatRecipeRate(this.getSyncer().syncInt(recipeLength), count));
        this.addKey((IDrawable)new GTObjectDrawable(output, count).setBoostFunction(entry -> chance).asIcon().asHoverable().addTooltipLine((IDrawable)MultiblockUIBuilder.formatRecipeData(name, amount, rate)), Operation::add);
    }

    private static String formatRecipeRate(int recipeLength, long amount) {
        float perSecond = (float)amount / (float)recipeLength * 20.0f;
        String rate = perSecond > 1.0f ? "(" + String.format("%,.2f", Float.valueOf(perSecond)).replaceAll("\\.?0+$", "") + "/s)" : "(" + String.format("%,.2f", Float.valueOf(1.0f / perSecond)).replaceAll("\\.?0+$", "") + "s/ea)";
        return rate;
    }

    private static IKey formatRecipeData(IKey name, IKey amount, IKey rate) {
        return IKey.comp((IKey[])new IKey[]{name, KeyUtil.string(TextFormatting.WHITE, " x "), amount, IKey.SPACE, rate});
    }

    public MultiblockUIBuilder addEmptyLine() {
        this.addKey((IDrawable)IKey.LINE_FEED);
        return this;
    }

    public MultiblockUIBuilder addCustom(BiConsumer<KeyManager, UISyncer> customConsumer) {
        customConsumer.accept(this::addOperation, this.getSyncer());
        return this;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public void clear() {
        this.operations.clear();
    }

    protected boolean hasChanged() {
        if (this.action == null) {
            return false;
        }
        return this.getSyncer().hasChanged();
    }

    public void sync(String key, PanelSyncManager syncManager) {
        syncManager.syncValue(key, (SyncHandler)this.syncHandler);
    }

    public void build(IRichTextBuilder<?> richText) {
        if (this.dirty) {
            this.clear();
            this.onRebuild();
            this.runAction();
            this.dirty = false;
        }
        for (Operation op : this.operations) {
            op.accept(richText);
        }
    }

    private void onRebuild() {
        if (this.onRebuild != null) {
            this.onRebuild.run();
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void runAction() {
        if (this.action != null) {
            this.action.accept(this);
        }
    }

    public void setAction(Consumer<MultiblockUIBuilder> action) {
        this.action = action;
    }

    public void onRebuild(Runnable onRebuild) {
        this.onRebuild = onRebuild;
    }

    private void addHoverableKey(IKey key, IDrawable ... hover) {
        if (this.isServer()) {
            return;
        }
        this.addKey(KeyUtil.setHover(key, hover));
    }

    private void addKey(IDrawable key) {
        this.addOperation(Operation.addLineSpace(key));
    }

    private void addKey(IDrawable key, Function<IDrawable, Operation> function) {
        this.addOperation(function.apply(key));
    }

    private void addOperation(@NotNull Operation op) {
        if (!this.isServer()) {
            this.operations.add(op);
        }
    }

    public class InternalSyncHandler
    extends SyncHandler {
        private InternalSyncHandler() {
        }

        public void detectAndSendChanges(boolean init) {
            if (init || MultiblockUIBuilder.this.hasChanged()) {
                if (init) {
                    MultiblockUIBuilder.this.onRebuild();
                    MultiblockUIBuilder.this.runAction();
                }
                this.syncToClient(0, buf -> MultiblockUIBuilder.this.getSyncer().writeBuffer((ByteBuf)buf));
            }
        }

        public void readOnClient(int id, PacketBuffer buf) {
            if (id == 0) {
                MultiblockUIBuilder.this.getSyncer().readBuffer((ByteBuf)buf);
                MultiblockUIBuilder.this.onRebuild();
                MultiblockUIBuilder.this.runAction();
            }
        }

        public void readOnServer(int id, PacketBuffer buf) {
        }
    }

    public class InternalSyncer
    implements UISyncer {
        private final PacketBuffer internal = new PacketBuffer(Unpooled.buffer());
        private final boolean isServer;

        private InternalSyncer(boolean isServer) {
            this.isServer = isServer;
        }

        private boolean isServer() {
            return this.isServer;
        }

        @Override
        public boolean syncBoolean(@NotNull BooleanSupplier initial) {
            if (this.isServer()) {
                boolean val = initial.getAsBoolean();
                this.internal.writeBoolean(val);
                return val;
            }
            return this.internal.readBoolean();
        }

        @Override
        public int syncInt(@NotNull IntSupplier initial) {
            if (this.isServer()) {
                int val = initial.getAsInt();
                this.internal.writeInt(val);
                return val;
            }
            return this.internal.readInt();
        }

        @Override
        public long syncLong(@NotNull LongSupplier initial) {
            if (this.isServer()) {
                long val = initial.getAsLong();
                this.internal.writeLong(val);
                return val;
            }
            return this.internal.readLong();
        }

        @Override
        public byte syncByte(@NotNull ByteSupplier initial) {
            if (this.isServer()) {
                byte val = initial.getByte();
                this.internal.writeByte((int)val);
                return val;
            }
            return this.internal.readByte();
        }

        @Override
        public double syncDouble(@NotNull DoubleSupplier initial) {
            if (this.isServer()) {
                double val = initial.getAsDouble();
                this.internal.writeDouble(val);
                return val;
            }
            return this.internal.readDouble();
        }

        @Override
        public float syncFloat(@NotNull FloatSupplier initial) {
            if (this.isServer()) {
                float val = initial.getFloat();
                this.internal.writeFloat(val);
                return val;
            }
            return this.internal.readFloat();
        }

        @Override
        @NotNull
        public <T> T syncObject(@NotNull Supplier<T> initial, IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
            if (this.isServer()) {
                T val = initial.get();
                serializer.serializeSafe(this.internal, Objects.requireNonNull(val));
                return val;
            }
            try {
                return (T)deserializer.deserialize(this.internal);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public <T, C extends Collection<T>> C syncCollection(C initial, IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
            if (this.isServer()) {
                this.internal.func_150787_b(initial.size());
                initial.forEach(t -> serializer.serializeSafe(this.internal, t));
            } else {
                int size = this.internal.func_150792_a();
                try {
                    for (int i = 0; i < size; ++i) {
                        initial.add((Object)deserializer.deserialize(this.internal));
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            return initial;
        }

        @Override
        public <T> T[] syncArray(T[] initial, IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
            if (this.isServer()) {
                this.internal.func_150787_b(initial.length);
                for (T t : initial) {
                    serializer.serializeSafe(this.internal, t);
                }
            } else {
                initial = Arrays.copyOf(initial, this.internal.func_150792_a());
                Arrays.setAll(initial, i -> deserializer.deserializeSafe(this.internal));
            }
            return initial;
        }

        public void readBuffer(ByteBuf buf) {
            MultiblockUIBuilder.this.clear();
            this.internal.clear();
            this.internal.writeBytes(buf);
        }

        public void writeBuffer(ByteBuf buf) {
            buf.writeBytes((ByteBuf)this.internal);
        }

        public boolean hasChanged() {
            byte[] old = (byte[])this.internal.array().clone();
            this.internal.clear();
            MultiblockUIBuilder.this.clear();
            MultiblockUIBuilder.this.onRebuild();
            MultiblockUIBuilder.this.runAction();
            return !Arrays.equals(old, this.internal.array());
        }
    }
}

