/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.SteamMultiblockRecipeLogic;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.KeyUtil;
import gregtech.common.ConfigHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class RecipeMapSteamMultiblockController
extends MultiblockWithDisplayBase
implements IControllable {
    protected static final double CONVERSION_RATE = ConfigHolder.machines.multiblockSteamToEU;
    public final RecipeMap<?> recipeMap;
    protected SteamMultiblockRecipeLogic recipeMapWorkable;
    protected IItemHandlerModifiable inputInventory;
    protected IItemHandlerModifiable outputInventory;
    protected IMultipleTankHandler steamFluidTank;

    public RecipeMapSteamMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, double conversionRate) {
        super(metaTileEntityId);
        this.recipeMap = recipeMap;
        this.recipeMapWorkable = new SteamMultiblockRecipeLogic(this, recipeMap, this.steamFluidTank, conversionRate);
        this.resetTileAbilities();
    }

    public IItemHandlerModifiable getInputInventory() {
        return this.inputInventory;
    }

    public IItemHandlerModifiable getOutputInventory() {
        return this.outputInventory;
    }

    public IMultipleTankHandler getSteamFluidTank() {
        return this.steamFluidTank;
    }

    public boolean checkRecipe(Recipe recipe, boolean consumeIfProcess) {
        return true;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    @Override
    protected void updateFormedValid() {
        this.recipeMapWorkable.update();
    }

    private void initializeAbilities() {
        this.inputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.STEAM_IMPORT_ITEMS));
        this.outputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.STEAM_EXPORT_ITEMS));
        this.steamFluidTank = new FluidTankList(true, this.getAbilities(MultiblockAbility.STEAM));
    }

    private void resetTileAbilities() {
        this.inputInventory = new GTItemStackHandler((MetaTileEntity)this, 0);
        this.outputInventory = new GTItemStackHandler((MetaTileEntity)this, 0);
        this.steamFluidTank = new FluidTankList(true, new IFluidTank[0]);
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addCustom((keyManager, syncer) -> {
            IFluidTank steamFluidTank = this.recipeMapWorkable.getSteamFluidTankCombined();
            int stored = syncer.syncInt(steamFluidTank.getFluidAmount());
            int capacity = syncer.syncInt(steamFluidTank.getCapacity());
            if (capacity > 0) {
                IKey steamInfo = KeyUtil.string(TextFormatting.BLUE, "%s/%s L", KeyUtil.number(stored), KeyUtil.number(capacity));
                IKey steamStored = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.steam.steam_stored", steamInfo);
                keyManager.add((IDrawable)steamStored);
            }
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine(this.recipeMapWorkable);
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        builder.addCustom((list, syncer) -> {
            boolean noEnergy = syncer.syncBoolean(this.recipeMapWorkable.isHasNotEnoughEnergy());
            if (this.isStructureFormed() && noEnergy) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.steam.low_steam", new Object[0]));
            }
        });
        super.configureWarningText(builder);
    }

    @Override
    public GTGuiTheme getUITheme() {
        return GTGuiTheme.BRONZE;
    }

    @Override
    public TraceabilityPredicate autoAbilities() {
        return this.autoAbilities(true, true, true, true, true);
    }

    public TraceabilityPredicate autoAbilities(boolean checkSteam, boolean checkMaintainer, boolean checkItemIn, boolean checkItemOut, boolean checkMuffler) {
        TraceabilityPredicate predicate = super.autoAbilities(checkMaintainer, checkMuffler).or(checkSteam ? RecipeMapSteamMultiblockController.abilities(MultiblockAbility.STEAM).setMinGlobalLimited(1).setPreviewCount(1) : new TraceabilityPredicate());
        if (checkItemIn && this.recipeMap.getMaxInputs() > 0) {
            predicate = predicate.or(RecipeMapSteamMultiblockController.abilities(MultiblockAbility.STEAM_IMPORT_ITEMS).setPreviewCount(1));
        }
        if (checkItemOut && this.recipeMap.getMaxOutputs() > 0) {
            predicate = predicate.or(RecipeMapSteamMultiblockController.abilities(MultiblockAbility.STEAM_EXPORT_ITEMS).setPreviewCount(1));
        }
        return predicate;
    }

    @Override
    protected boolean shouldUpdate(MTETrait trait) {
        return !(trait instanceof SteamMultiblockRecipeLogic);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    @Override
    public SoundEvent getSound() {
        return this.recipeMap.getSound();
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.recipeMapWorkable.isActive() && this.recipeMapWorkable.isWorkingEnabled();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.recipeMapWorkable.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.recipeMapWorkable.setWorkingEnabled(isWorkingAllowed);
    }
}

