/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import gregtech.api.GTValues;
import gregtech.api.block.VariantActiveBlock;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMaintenanceHatch;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class MultiblockWithDisplayBase
extends MultiblockControllerBase
implements IMaintenance {
    private static final String NBT_VOIDING_MODE = "VoidingMode";
    private static final String NBT_VOIDING_ITEMS = "VoidingItems";
    private static final String NBT_VOIDING_FLUIDS = "VoidingFluids";
    private MultiblockUIFactory uiFactory;
    private boolean voidingItems = false;
    private boolean voidingFluids = false;
    private IVoidable.VoidingMode voidingMode;
    private boolean fluidInfSink = false;
    private boolean itemInfSink = false;
    private IMaintenanceHatch maintenanceHatch;
    protected final List<ItemStack> recoveryItems = new ArrayList<ItemStack>(Collections.singleton(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Ash)));
    private int timeActive;
    protected byte maintenance_problems = 0;
    private boolean initialMaintenanceDone;
    private boolean storedTaped = false;
    protected List<BlockPos> variantActiveBlocks;
    protected boolean lastActive;

    public MultiblockWithDisplayBase(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.voidingMode = IVoidable.VoidingMode.VOID_NONE;
    }

    @Override
    public void setMaintenanceFixed(int index) {
        this.maintenance_problems = (byte)(this.maintenance_problems | 1 << index);
    }

    @Override
    public void causeMaintenanceProblems() {
        this.maintenance_problems = (byte)(this.maintenance_problems & ~(1 << (int)(GTValues.RNG.nextFloat() * 5.0f)));
        this.getWorld().func_184148_a(null, (double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), this.getBreakdownSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public byte getMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics() ? this.maintenance_problems : (byte)63;
    }

    @Override
    public int getNumMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics() ? 6 - Integer.bitCount(this.maintenance_problems) : 0;
    }

    @Override
    public boolean hasMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics() && this.maintenance_problems < 63;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return false;
    }

    public void calculateMaintenance() {
        int n;
        if (!ConfigHolder.machines.enableMaintenance || !this.hasMaintenanceMechanics() || this.maintenanceHatch == null) {
            return;
        }
        if (this.maintenanceHatch.isFullAuto()) {
            return;
        }
        ++this.timeActive;
        if ((double)n >= 1000.0 / this.maintenanceHatch.getTimeMultiplier()) {
            this.timeActive = 0;
            if (GTValues.RNG.nextInt(6000) == 0) {
                this.causeMaintenanceProblems();
                this.maintenanceHatch.setTaped(false);
            }
        }
    }

    public double getMaintenanceDurationMultiplier() {
        if (!ConfigHolder.machines.enableMaintenance || !this.hasMaintenanceMechanics() || this.maintenanceHatch == null) {
            return 1.0;
        }
        return this.maintenanceHatch.getDurationMultiplier();
    }

    @Override
    public boolean isStructureObstructed() {
        return this.hasMufflerMechanics() && !this.isMufflerFaceFree();
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            if (this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).isEmpty()) {
                return;
            }
            this.maintenanceHatch = this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0);
            if (this.maintenanceHatch.startWithoutProblems() && !this.initialMaintenanceDone) {
                this.maintenance_problems = (byte)63;
                this.timeActive = 0;
                this.initialMaintenanceDone = true;
            }
            this.readMaintenanceData(this.maintenanceHatch);
            if (this.storedTaped) {
                this.maintenanceHatch.setTaped(true);
                this.storeTaped(false);
            }
        }
        this.variantActiveBlocks = context.getOrDefault("VABlock", new LinkedList());
        this.replaceVariantBlocksActive(false);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            boolean state = this.isActive();
            if (this.lastActive != state) {
                this.setLastActive(state);
                this.markDirty();
                this.replaceVariantBlocksActive(this.lastActive);
            }
            if (state) {
                this.calculateMaintenance();
            }
        }
    }

    public void setLastActive(boolean lastActive) {
        this.lastActive = lastActive;
        this.writeCustomData(GregtechDataCodes.IS_WORKING, buf -> buf.writeBoolean(lastActive));
    }

    @Override
    public void storeTaped(boolean isTaped) {
        this.storedTaped = isTaped;
        this.writeCustomData(GregtechDataCodes.STORE_TAPED, buf -> buf.writeBoolean(isTaped));
    }

    private void readMaintenanceData(IMaintenanceHatch hatch) {
        if (hatch.hasMaintenanceData()) {
            Tuple<Byte, Integer> data = hatch.readMaintenanceData();
            this.maintenance_problems = (Byte)data.func_76341_a();
            this.timeActive = (Integer)data.func_76340_b();
        }
    }

    public boolean isMufflerFaceFree() {
        if (!this.isStructureFormed()) {
            return false;
        }
        if (!this.hasMufflerMechanics()) {
            return false;
        }
        List<IMufflerHatch> mufflers = this.getAbilities(MultiblockAbility.MUFFLER_HATCH);
        if (mufflers.isEmpty()) {
            return false;
        }
        return mufflers.get(0).isFrontFaceFree();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public EnumParticleTypes getMufflerParticle() {
        return EnumParticleTypes.SMOKE_LARGE;
    }

    protected void setRecoveryItems(ItemStack ... recoveryItems) {
        this.recoveryItems.clear();
        this.recoveryItems.addAll(Arrays.asList(recoveryItems));
    }

    @Override
    public boolean isActive() {
        return this.isStructureFormed();
    }

    @Override
    public void invalidateStructure() {
        if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance && !this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).isEmpty()) {
            this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0).storeMaintenanceData(this.maintenance_problems, this.timeActive);
        }
        this.lastActive = false;
        this.replaceVariantBlocksActive(false);
        this.fluidInfSink = false;
        this.itemInfSink = false;
        this.maintenanceHatch = null;
        super.invalidateStructure();
    }

    protected void replaceVariantBlocksActive(boolean isActive) {
        if (this.variantActiveBlocks != null && !this.variantActiveBlocks.isEmpty()) {
            int id = this.getWorld().field_73011_w.getDimension();
            this.writeCustomData(GregtechDataCodes.VARIANT_RENDER_UPDATE, buf -> {
                buf.writeInt(id);
                buf.writeBoolean(isActive);
                buf.writeInt(this.variantActiveBlocks.size());
                for (BlockPos blockPos : this.variantActiveBlocks) {
                    VariantActiveBlock.setBlockActive(id, blockPos, isActive);
                    buf.func_179255_a(blockPos);
                }
            });
        }
    }

    public TraceabilityPredicate autoAbilities() {
        return this.autoAbilities(true, true);
    }

    public TraceabilityPredicate autoAbilities(boolean checkMaintenance, boolean checkMuffler) {
        TraceabilityPredicate predicate = new TraceabilityPredicate();
        if (checkMaintenance && this.hasMaintenanceMechanics()) {
            predicate = predicate.or(this.maintenancePredicate());
        }
        if (checkMuffler && this.hasMufflerMechanics()) {
            predicate = predicate.or(MultiblockWithDisplayBase.abilities(MultiblockAbility.MUFFLER_HATCH).setMinGlobalLimited(1).setMaxGlobalLimited(1));
        }
        return predicate;
    }

    protected TraceabilityPredicate maintenancePredicate() {
        if (this.hasMaintenanceMechanics()) {
            return MultiblockWithDisplayBase.abilities(MultiblockAbility.MAINTENANCE_HATCH).setMinGlobalLimited(ConfigHolder.machines.enableMaintenance ? 1 : 0).setMaxGlobalLimited(1);
        }
        return new TraceabilityPredicate();
    }

    public boolean shouldShowVoidingModeButton() {
        return true;
    }

    public final int getVoidingMode() {
        return this.voidingMode.ordinal();
    }

    public final void setVoidingMode(int mode) {
        this.voidingMode = IVoidable.VoidingMode.VALUES[mode];
        this.voidingFluids = mode >= 2;
        this.voidingItems = mode == 1 || mode == 3;
        for (IFluidTank tank : this.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
            this.getNotifiedFluidInputList().add((IFluidHandler)tank);
        }
        this.getNotifiedItemInputList().addAll(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.markDirty();
    }

    @NotNull
    public String getVoidingModeTooltip(int mode) {
        return IVoidable.VoidingMode.VALUES[mode].func_176610_l();
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    protected void configureDisplayText(MultiblockUIBuilder builder) {
    }

    protected void configureErrorText(MultiblockUIBuilder builder) {
        builder.structureFormed(this.isStructureFormed());
        if (this.hasMufflerMechanics()) {
            builder.addMufflerObstructedLine(!this.isMufflerFaceFree());
        }
        if (this.hasMaintenanceMechanics()) {
            builder.addMaintenanceProblemLines(this.getMaintenanceProblems(), false);
        }
    }

    protected void configureWarningText(MultiblockUIBuilder builder) {
        if (this.hasMaintenanceMechanics()) {
            builder.addMaintenanceProblemLines(this.getMaintenanceProblems(), true);
        }
    }

    protected MultiblockUIFactory createUIFactory() {
        return new MultiblockUIFactory(this).configureDisplayText(this::configureDisplayText).configureWarningText(this::configureWarningText).configureErrorText(this::configureErrorText);
    }

    @Override
    public final ModularPanel buildUI(PosGuiData guiData, PanelSyncManager panelSyncManager) {
        if (this.uiFactory == null) {
            this.uiFactory = this.createUIFactory();
        }
        return this.uiFactory.buildUI(guiData, panelSyncManager);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("Maintenance", this.maintenance_problems);
        data.func_74757_a("InitialMaintenance", this.initialMaintenanceDone);
        data.func_74768_a("ActiveTimer", this.timeActive);
        data.func_74757_a(NBT_VOIDING_ITEMS, this.voidingItems);
        data.func_74757_a(NBT_VOIDING_FLUIDS, this.voidingFluids);
        data.func_74768_a(NBT_VOIDING_MODE, this.voidingMode.ordinal());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.maintenance_problems = data.func_74771_c("Maintenance");
        this.initialMaintenanceDone = data.func_74767_n("InitialMaintenance");
        this.timeActive = data.func_74762_e("ActiveTimer");
        if (data.func_74764_b(NBT_VOIDING_ITEMS)) {
            this.voidingItems = data.func_74767_n(NBT_VOIDING_ITEMS);
        }
        if (data.func_74764_b(NBT_VOIDING_FLUIDS)) {
            this.voidingFluids = data.func_74767_n(NBT_VOIDING_FLUIDS);
        }
        if (data.func_74764_b(NBT_VOIDING_MODE)) {
            this.voidingMode = IVoidable.VoidingMode.values()[data.func_74762_e(NBT_VOIDING_MODE)];
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte((int)this.maintenance_problems);
        buf.writeInt(this.timeActive);
        buf.writeBoolean(this.voidingFluids);
        buf.writeBoolean(this.voidingItems);
        buf.writeInt(this.voidingMode.ordinal());
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.maintenance_problems = buf.readByte();
        this.timeActive = buf.readInt();
        this.voidingFluids = buf.readBoolean();
        this.voidingItems = buf.readBoolean();
        this.voidingMode = IVoidable.VoidingMode.values()[buf.readInt()];
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.STORE_TAPED) {
            this.storedTaped = buf.readBoolean();
        }
        if (dataId == GregtechDataCodes.VARIANT_RENDER_UPDATE) {
            int minZ = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minX = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxX = Integer.MIN_VALUE;
            int id = buf.readInt();
            boolean isActive = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                BlockPos blockPos = buf.func_179259_c();
                VariantActiveBlock.setBlockActive(id, blockPos, isActive);
                minX = Math.min(minX, blockPos.func_177958_n());
                minY = Math.min(minY, blockPos.func_177956_o());
                minZ = Math.min(minZ, blockPos.func_177952_p());
                maxX = Math.max(maxX, blockPos.func_177958_n());
                maxY = Math.max(maxY, blockPos.func_177956_o());
                maxZ = Math.max(maxZ, blockPos.func_177952_p());
            }
            if (this.getWorld().field_73011_w.getDimension() == id) {
                this.getWorld().func_175704_b(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
            }
        }
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.lastActive = buf.readBoolean();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T capabilityResult = super.getCapability(capability, side);
        if (capabilityResult != null) {
            return capabilityResult;
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_MAINTENANCE && this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            return (T)GregtechTileCapabilities.CAPABILITY_MAINTENANCE.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return this.voidingFluids || this.fluidInfSink;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return this.voidingItems || this.itemInfSink;
    }

    public void enableFluidInfSink() {
        this.fluidInfSink = true;
    }

    public void enableItemInfSink() {
        this.itemInfSink = true;
    }
}

