/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import gregtech.api.GregTechAPI;
import gregtech.api.block.VariantActiveBlock;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.world.DummyWorld;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.handler.MultiblockPreviewRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOrientedCubeRenderer;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiblockControllerBase
extends MetaTileEntity
implements IMultiblockController {
    @Nullable
    public BlockPattern structurePattern;
    private final Map<MultiblockAbility<Object>, AbilityInstances> multiblockAbilities = new HashMap<MultiblockAbility<Object>, AbilityInstances>();
    private final List<IMultiblockPart> multiblockParts = new ArrayList<IMultiblockPart>();
    private boolean structureFormed;
    protected EnumFacing upwardsFacing = EnumFacing.NORTH;
    protected boolean isFlipped;

    public MultiblockControllerBase(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public void onPlacement(EntityLivingBase placer) {
        super.onPlacement(placer);
        this.reinitializeStructurePattern();
    }

    public void reinitializeStructurePattern() {
        this.structurePattern = this.createStructurePattern();
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (this.getOffsetTimer() % 20L == 0L || this.isFirstTick()) {
                this.checkStructurePattern();
            }
            if (this.isStructureFormed() && !(this.getWorld() instanceof DummyWorld)) {
                this.updateFormedValid();
            }
        }
    }

    protected abstract void updateFormedValid();

    @NotNull
    protected abstract BlockPattern createStructurePattern();

    public EnumFacing getUpwardsFacing() {
        return this.upwardsFacing;
    }

    public void setUpwardsFacing(EnumFacing upwardsFacing) {
        if (!this.allowsExtendedFacing()) {
            return;
        }
        if (upwardsFacing == null || upwardsFacing == EnumFacing.UP || upwardsFacing == EnumFacing.DOWN) {
            GTLog.logger.error("Tried to set upwards facing to invalid facing {}! Skipping", (Object)upwardsFacing);
            return;
        }
        if (this.upwardsFacing != upwardsFacing) {
            this.upwardsFacing = upwardsFacing;
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.notifyBlockUpdate();
                this.markDirty();
                this.writeCustomData(GregtechDataCodes.UPDATE_UPWARDS_FACING, buf -> buf.writeByte(upwardsFacing.func_176745_a()));
                if (this.structurePattern != null) {
                    this.structurePattern.clearCache();
                    this.checkStructurePattern();
                }
            }
        }
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    @ApiStatus.Internal
    protected void setFlipped(boolean isFlipped) {
        if (this.isFlipped != isFlipped) {
            this.isFlipped = isFlipped;
            this.notifyBlockUpdate();
            this.markDirty();
            this.writeCustomData(GregtechDataCodes.UPDATE_FLIP, buf -> buf.writeBoolean(isFlipped));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ICubeRenderer getBaseTexture(IMultiblockPart var1);

    public boolean shouldRenderOverlay(IMultiblockPart sourcePart) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.MULTIBLOCK_WORKABLE_OVERLAY;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getFrontDefaultTexture() {
        return this.getFrontOverlay().getParticleSprite();
    }

    public static TraceabilityPredicate tilePredicate(@NotNull BiFunction<BlockWorldState, MetaTileEntity, Boolean> predicate, @Nullable Supplier<BlockInfo[]> candidates) {
        return new TraceabilityPredicate(blockWorldState -> {
            TileEntity tileEntity = blockWorldState.getTileEntity();
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return false;
            }
            MetaTileEntity metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (((Boolean)predicate.apply((BlockWorldState)blockWorldState, metaTileEntity)).booleanValue()) {
                if (metaTileEntity instanceof IMultiblockPart) {
                    Set partsFound = blockWorldState.getMatchContext().getOrCreate("MultiblockParts", HashSet::new);
                    partsFound.add((IMultiblockPart)((Object)metaTileEntity));
                }
                return true;
            }
            return false;
        }, candidates);
    }

    public static TraceabilityPredicate metaTileEntities(MetaTileEntity ... metaTileEntities) {
        ResourceLocation[] ids = (ResourceLocation[])Arrays.stream(metaTileEntities).filter(Objects::nonNull).map(tile -> tile.metaTileEntityId).toArray(ResourceLocation[]::new);
        return MultiblockControllerBase.tilePredicate((state, tile) -> ArrayUtils.contains((Object[])ids, (Object)tile.metaTileEntityId), MultiblockControllerBase.getCandidates(metaTileEntities));
    }

    private static Supplier<BlockInfo[]> getCandidates(MetaTileEntity ... metaTileEntities) {
        return () -> (BlockInfo[])Arrays.stream(metaTileEntities).filter(Objects::nonNull).map(tile -> {
            MetaTileEntityHolder holder = new MetaTileEntityHolder();
            holder.setMetaTileEntity((MetaTileEntity)tile);
            holder.getMetaTileEntity().onPlacement();
            holder.getMetaTileEntity().setFrontFacing(EnumFacing.SOUTH);
            return new BlockInfo(tile.getBlock().func_176223_P(), holder);
        }).toArray(BlockInfo[]::new);
    }

    private static Supplier<BlockInfo[]> getCandidates(IBlockState ... allowedStates) {
        return () -> (BlockInfo[])Arrays.stream(allowedStates).map(state -> new BlockInfo((IBlockState)state, null)).toArray(BlockInfo[]::new);
    }

    public static TraceabilityPredicate abilities(MultiblockAbility<?> ... allowedAbilities) {
        return MultiblockControllerBase.tilePredicate((state, tile) -> {
            if (tile instanceof IMultiblockAbilityPart) {
                IMultiblockAbilityPart abilityPart = (IMultiblockAbilityPart)((Object)tile);
                for (MultiblockAbility<?> ability : abilityPart.getAbilities()) {
                    if (!ArrayUtils.contains((Object[])allowedAbilities, ability)) continue;
                    return true;
                }
            }
            return false;
        }, MultiblockControllerBase.getCandidates((MetaTileEntity[])Arrays.stream(allowedAbilities).flatMap(ability -> MultiblockAbility.REGISTRY.get(ability).stream()).toArray(MetaTileEntity[]::new)));
    }

    public static TraceabilityPredicate states(IBlockState ... allowedStates) {
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            if (state.func_177230_c() instanceof VariantActiveBlock) {
                blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList()).add(blockWorldState.getPos());
            }
            return ArrayUtils.contains((Object[])allowedStates, (Object)state);
        }, MultiblockControllerBase.getCandidates(allowedStates));
    }

    public static TraceabilityPredicate frames(Material ... frameMaterials) {
        return MultiblockControllerBase.states((IBlockState[])Arrays.stream(frameMaterials).map(m -> MetaBlocks.FRAMES.get(m).getBlock((Material)m)).toArray(IBlockState[]::new)).or(new TraceabilityPredicate(blockWorldState -> {
            TileEntity tileEntity = blockWorldState.getTileEntity();
            if (!(tileEntity instanceof IPipeTile)) {
                return false;
            }
            IPipeTile pipeTile = (IPipeTile)tileEntity;
            return ArrayUtils.contains((Object[])frameMaterials, (Object)pipeTile.getFrameMaterial());
        }));
    }

    public static TraceabilityPredicate blocks(Block ... block) {
        return new TraceabilityPredicate(blockWorldState -> ArrayUtils.contains((Object[])block, (Object)blockWorldState.getBlockState().func_177230_c()), MultiblockControllerBase.getCandidates((IBlockState[])Arrays.stream(block).map(Block::func_176223_P).toArray(IBlockState[]::new)));
    }

    public static TraceabilityPredicate air() {
        return TraceabilityPredicate.AIR;
    }

    public static TraceabilityPredicate any() {
        return TraceabilityPredicate.ANY;
    }

    public static TraceabilityPredicate heatingCoils() {
        return TraceabilityPredicate.HEATING_COILS.get();
    }

    public TraceabilityPredicate selfPredicate() {
        return MultiblockControllerBase.metaTileEntities(this).setCenter();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        ICubeRenderer baseTexture = this.getBaseTexture(null);
        pipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        if (baseTexture instanceof SimpleOrientedCubeRenderer) {
            baseTexture.renderOriented(renderState, translation, pipeline, this.getFrontFacing());
        } else {
            baseTexture.render(renderState, translation, pipeline);
        }
        if (this.allowsExtendedFacing()) {
            double degree = 1.5707963267948966 * (double)(this.upwardsFacing == EnumFacing.EAST ? -1 : (this.upwardsFacing == EnumFacing.SOUTH ? 2 : (this.upwardsFacing == EnumFacing.WEST ? 1 : 0)));
            Rotation rotation = new Rotation(degree, (double)this.frontFacing.func_82601_c(), (double)this.frontFacing.func_96559_d(), (double)this.frontFacing.func_82599_e());
            translation.translate(0.5, 0.5, 0.5);
            if (this.frontFacing == EnumFacing.DOWN && this.upwardsFacing.func_176740_k() == EnumFacing.Axis.Z) {
                translation.apply((Transformation)new Rotation(Math.PI, 0.0, 1.0, 0.0));
            }
            translation.apply((Transformation)rotation);
            translation.scale(1.0);
            translation.translate(-0.5, -0.5, -0.5);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseTexture(null).getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    public boolean shouldShowInJei() {
        return true;
    }

    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return Vec3i::hashCode;
    }

    public void checkStructurePattern() {
        if (this.structurePattern == null) {
            return;
        }
        PatternMatchContext context = this.structurePattern.checkPatternFastAt(this.getWorld(), this.getPos(), this.getFrontFacing().func_176734_d(), this.getUpwardsFacing(), this.allowsFlip());
        if (context != null && !this.structureFormed) {
            Set rawPartsSet = context.getOrCreate("MultiblockParts", HashSet::new);
            ArrayList<IMultiblockPart> parts = new ArrayList<IMultiblockPart>(rawPartsSet);
            for (IMultiblockPart part2 : parts) {
                if (!part2.isAttachedToMultiBlock() || part2.canPartShare()) continue;
                return;
            }
            this.setFlipped(context.neededFlip());
            parts.sort(Comparator.comparing(it -> this.multiblockPartSorter().apply(((MetaTileEntity)((Object)it)).getPos())));
            HashMap<MultiblockAbility, AbilityInstances> abilities = new HashMap<MultiblockAbility, AbilityInstances>();
            for (IMultiblockPart part3 : parts) {
                if (!(part3 instanceof IMultiblockAbilityPart)) continue;
                IMultiblockAbilityPart abilityPart = (IMultiblockAbilityPart)part3;
                List<MultiblockAbility<?>> abilityList = abilityPart.getAbilities();
                for (MultiblockAbility<?> ability : abilityList) {
                    if (!this.checkAbilityPart(ability, ((MetaTileEntity)((Object)abilityPart)).getPos())) continue;
                    AbilityInstances instances = abilities.computeIfAbsent(ability, AbilityInstances::new);
                    abilityPart.registerAbilities(instances);
                }
            }
            this.multiblockParts.addAll(parts);
            this.multiblockAbilities.putAll(abilities);
            parts.forEach(part -> part.addToMultiBlock(this));
            this.structureFormed = true;
            this.writeCustomData(GregtechDataCodes.STRUCTURE_FORMED, buf -> buf.writeBoolean(true));
            this.formStructure(context);
        } else if (context == null && this.structureFormed) {
            this.invalidateStructure();
        } else if (context != null && context.neededFlip() != this.isFlipped()) {
            this.setFlipped(context.neededFlip());
        }
    }

    protected <T> boolean checkAbilityPart(MultiblockAbility<T> ability, BlockPos pos) {
        return true;
    }

    protected void formStructure(PatternMatchContext context) {
    }

    public void invalidateStructure() {
        this.multiblockParts.forEach(part -> part.removeFromMultiBlock(this));
        this.multiblockAbilities.clear();
        this.multiblockParts.clear();
        this.structureFormed = false;
        this.setFlipped(false);
        this.writeCustomData(GregtechDataCodes.STRUCTURE_FORMED, buf -> buf.writeBoolean(false));
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getWorld().field_72995_K && this.structureFormed) {
            this.invalidateStructure();
        }
    }

    public <T> List<T> getAbilities(MultiblockAbility<T> ability) {
        return Collections.unmodifiableList(this.multiblockAbilities.getOrDefault(ability, AbilityInstances.EMPTY).cast());
    }

    public List<IMultiblockPart> getMultiblockParts() {
        return Collections.unmodifiableList(this.multiblockParts);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("UpwardsFacing")) {
            this.upwardsFacing = EnumFacing.field_82609_l[data.func_74771_c("UpwardsFacing")];
        }
        if (data.func_74764_b("IsFlipped")) {
            this.isFlipped = data.func_74767_n("IsFlipped");
        }
        this.reinitializeStructurePattern();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("UpwardsFacing", (byte)this.upwardsFacing.func_176745_a());
        data.func_74757_a("IsFlipped", this.isFlipped);
        return data;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.structureFormed);
        buf.writeByte(this.upwardsFacing.func_176745_a());
        buf.writeBoolean(this.isFlipped);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.structureFormed = buf.readBoolean();
        this.upwardsFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.isFlipped = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.STRUCTURE_FORMED) {
            this.structureFormed = buf.readBoolean();
            if (!this.structureFormed) {
                GregTechAPI.soundManager.stopTileSound(this.getPos());
            }
        } else if (dataId == GregtechDataCodes.UPDATE_UPWARDS_FACING) {
            this.upwardsFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_FLIP) {
            this.isFlipped = buf.readBoolean();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T result = super.getCapability(capability, side);
        if (result != null) {
            return result;
        }
        if (capability == GregtechCapabilities.CAPABILITY_MULTIBLOCK_CONTROLLER) {
            return (T)GregtechCapabilities.CAPABILITY_MULTIBLOCK_CONTROLLER.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean isStructureFormed() {
        return this.structureFormed;
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        EnumFacing oldFrontFacing = this.getFrontFacing();
        super.setFrontFacing(frontFacing);
        if (this.allowsExtendedFacing()) {
            EnumFacing newUpwardsFacing = RelativeDirection.simulateAxisRotation(frontFacing, oldFrontFacing, this.getUpwardsFacing());
            this.setUpwardsFacing(newUpwardsFacing);
        }
        if (this.getWorld() != null && !this.getWorld().field_72995_K && this.structurePattern != null) {
            this.structurePattern.clearCache();
            this.checkStructurePattern();
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        if (this instanceof IMultipleRecipeMaps) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        }
        if (this.allowsExtendedFacing()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.extended_facing", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        }
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (super.onRightClick(playerIn, hand, facing, hitResult)) {
            return true;
        }
        if (this.getWorld().field_72995_K && !this.isStructureFormed() && playerIn.func_70093_af() && playerIn.func_184586_b(hand).func_190926_b()) {
            MultiblockPreviewRenderer.renderMultiBlockPreview(this, 60000L);
            return true;
        }
        return false;
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        if (wrenchSide == this.getFrontFacing() && this.allowsExtendedFacing()) {
            if (!this.getWorld().field_72995_K) {
                this.setUpwardsFacing(playerIn.func_70093_af() ? this.upwardsFacing.func_176735_f() : this.upwardsFacing.func_176746_e());
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, wrenchSide, hitResult);
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return this.allowsExtendedFacing() || super.isValidFrontFacing(facing);
    }

    public boolean allowsExtendedFacing() {
        return true;
    }

    public boolean allowsFlip() {
        return true;
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        if (this.structurePattern == null) {
            this.reinitializeStructurePattern();
            if (this.structurePattern == null) {
                return Collections.emptyList();
            }
        }
        int[][] aisleRepetitions = this.structurePattern.aisleRepetitions;
        return this.repetitionDFS(new ArrayList<MultiblockShapeInfo>(), aisleRepetitions, new Stack<Integer>());
    }

    private List<MultiblockShapeInfo> repetitionDFS(List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack) {
        if (repetitionStack.size() == aisleRepetitions.length) {
            int[] repetition = new int[repetitionStack.size()];
            for (int i = 0; i < repetitionStack.size(); ++i) {
                repetition[i] = (Integer)repetitionStack.get(i);
            }
            pages.add(new MultiblockShapeInfo(Objects.requireNonNull(this.structurePattern).getPreview(repetition)));
        } else {
            for (int i = aisleRepetitions[repetitionStack.size()][0]; i <= aisleRepetitions[repetitionStack.size()][1]; ++i) {
                repetitionStack.push(i);
                this.repetitionDFS(pages, aisleRepetitions, repetitionStack);
                repetitionStack.pop();
            }
        }
        return pages;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getDescription() {
        String[] stringArray;
        String key = String.format("gregtech.multiblock.%s.description", this.metaTileEntityId.func_110623_a());
        if (I18n.func_188566_a((String)key)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    public void explodeMultiblock(float explosionPower) {
        ArrayList<IMultiblockPart> parts = new ArrayList<IMultiblockPart>(this.getMultiblockParts());
        for (IMultiblockPart part : parts) {
            part.removeFromMultiBlock(this);
            ((MetaTileEntity)((Object)part)).doExplosion(explosionPower);
        }
        this.doExplosion(explosionPower);
    }

    public boolean isMultiblockPartWeatherResistant(@NotNull IMultiblockPart part) {
        return false;
    }
}

