/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IHPCAComponentHatch;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.capability.IMaintenanceHatch;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.capability.IObjectHolder;
import gregtech.api.capability.IOpticalComputationHatch;
import gregtech.api.capability.IOpticalDataAccessHatch;
import gregtech.api.capability.IRotorHolder;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IPassthroughHatch;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class MultiblockAbility<T> {
    public static final Map<MultiblockAbility<?>, List<MetaTileEntity>> REGISTRY = new Object2ObjectOpenHashMap();
    public static final MultiblockAbility<IItemHandlerModifiable> EXPORT_ITEMS = MultiblockAbility.ability("export_items", IItemHandlerModifiable.class);
    public static final MultiblockAbility<IItemHandlerModifiable> IMPORT_ITEMS = MultiblockAbility.ability("import_items", IItemHandlerModifiable.class);
    public static final MultiblockAbility<IFluidTank> EXPORT_FLUIDS = MultiblockAbility.ability("export_fluids", IFluidTank.class);
    public static final MultiblockAbility<IFluidTank> IMPORT_FLUIDS = MultiblockAbility.ability("import_fluids", IFluidTank.class);
    public static final MultiblockAbility<IEnergyContainer> INPUT_ENERGY = MultiblockAbility.ability("input_energy", IEnergyContainer.class);
    public static final MultiblockAbility<IEnergyContainer> OUTPUT_ENERGY = MultiblockAbility.ability("output_energy", IEnergyContainer.class);
    public static final MultiblockAbility<IEnergyContainer> SUBSTATION_INPUT_ENERGY = MultiblockAbility.ability("substation_input_energy", IEnergyContainer.class);
    public static final MultiblockAbility<IEnergyContainer> SUBSTATION_OUTPUT_ENERGY = MultiblockAbility.ability("substation_output_energy", IEnergyContainer.class);
    public static final MultiblockAbility<IRotorHolder> ROTOR_HOLDER = MultiblockAbility.ability("rotor_holder", IRotorHolder.class);
    public static final MultiblockAbility<IFluidTank> PUMP_FLUID_HATCH = MultiblockAbility.ability("pump_fluid_hatch", IFluidTank.class);
    public static final MultiblockAbility<IFluidTank> STEAM = new MultiblockAbility<IFluidTank>("steam", IFluidTank.class);
    public static final MultiblockAbility<IItemHandlerModifiable> STEAM_IMPORT_ITEMS = MultiblockAbility.ability("steam_import_items", IItemHandlerModifiable.class);
    public static final MultiblockAbility<IItemHandlerModifiable> STEAM_EXPORT_ITEMS = MultiblockAbility.ability("steam_export_items", IItemHandlerModifiable.class);
    public static final MultiblockAbility<IMaintenanceHatch> MAINTENANCE_HATCH = MultiblockAbility.ability("maintenance_hatch", IMaintenanceHatch.class);
    public static final MultiblockAbility<IMufflerHatch> MUFFLER_HATCH = MultiblockAbility.ability("muffler_hatch", IMufflerHatch.class);
    public static final MultiblockAbility<IItemHandlerModifiable> MACHINE_HATCH = MultiblockAbility.ability("machine_hatch", IItemHandlerModifiable.class);
    public static final MultiblockAbility<IFluidHandler> TANK_VALVE = MultiblockAbility.ability("tank_valve", IFluidHandler.class);
    public static final MultiblockAbility<IPassthroughHatch> PASSTHROUGH_HATCH = MultiblockAbility.ability("passthrough_hatch", IPassthroughHatch.class);
    public static final MultiblockAbility<IDataAccessHatch> DATA_ACCESS_HATCH = MultiblockAbility.ability("data_access_hatch", IDataAccessHatch.class);
    public static final MultiblockAbility<IOpticalDataAccessHatch> OPTICAL_DATA_RECEPTION = MultiblockAbility.ability("optical_data_reception", IOpticalDataAccessHatch.class);
    public static final MultiblockAbility<IOpticalDataAccessHatch> OPTICAL_DATA_TRANSMISSION = MultiblockAbility.ability("optical_data_transmission", IOpticalDataAccessHatch.class);
    public static final MultiblockAbility<ILaserContainer> INPUT_LASER = MultiblockAbility.ability("input_laser", ILaserContainer.class);
    public static final MultiblockAbility<ILaserContainer> OUTPUT_LASER = MultiblockAbility.ability("output_laser", ILaserContainer.class);
    public static final MultiblockAbility<IOpticalComputationHatch> COMPUTATION_DATA_RECEPTION = MultiblockAbility.ability("computation_data_reception", IOpticalComputationHatch.class);
    public static final MultiblockAbility<IOpticalComputationHatch> COMPUTATION_DATA_TRANSMISSION = MultiblockAbility.ability("computation_data_transmission", IOpticalComputationHatch.class);
    public static final MultiblockAbility<IHPCAComponentHatch> HPCA_COMPONENT = MultiblockAbility.ability("hpca_component", IHPCAComponentHatch.class);
    public static final MultiblockAbility<IObjectHolder> OBJECT_HOLDER = MultiblockAbility.ability("object_holder", IObjectHolder.class);
    private final String name;
    private final Class<T> clazz;

    public static void registerMultiblockAbility(MultiblockAbility<?> ability, MetaTileEntity part) {
        if (!REGISTRY.containsKey(ability)) {
            REGISTRY.put(ability, new ArrayList());
        }
        REGISTRY.get(ability).add(part);
    }

    public static <R> MultiblockAbility<R> ability(String name, Class<R> clazz) {
        return new MultiblockAbility<R>(name, clazz);
    }

    public MultiblockAbility(String name, Class<T> clazz) {
        this.name = name.toLowerCase();
        this.clazz = clazz;
    }

    public String toString() {
        return this.name;
    }

    public boolean checkType(Object o) {
        return this.clazz.isAssignableFrom(o.getClass());
    }

    @NotNull
    public <R> List<R> castList(AbilityInstances instances) {
        if (instances.isKey(this)) {
            return instances;
        }
        throw new IllegalArgumentException("Cannot cast instances of " + (Object)((Object)instances) + " because they are not of " + this.clazz.getSimpleName() + "!");
    }
}

