/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class DummyCleanroom
implements ICleanroomProvider {
    private final boolean allowsAllTypes;
    private final Collection<CleanroomType> allowedTypes;

    @NotNull
    public static DummyCleanroom createForTypes(@NotNull Collection<CleanroomType> types) {
        return new DummyCleanroom(types, false);
    }

    @NotNull
    public static DummyCleanroom createForAllTypes() {
        return new DummyCleanroom(Collections.emptyList(), true);
    }

    private DummyCleanroom(@NotNull Collection<CleanroomType> allowedTypes, boolean allowsAllTypes) {
        this.allowedTypes = allowedTypes;
        this.allowsAllTypes = allowsAllTypes;
    }

    @Override
    public boolean isClean() {
        return true;
    }

    @Override
    public boolean drainEnergy(boolean simulate) {
        return true;
    }

    @Override
    public long getEnergyInputPerSecond() {
        return 0L;
    }

    @Override
    public int getEnergyTier() {
        return 0;
    }

    @Override
    public boolean checkCleanroomType(@NotNull CleanroomType type) {
        if (this.allowsAllTypes) {
            return true;
        }
        return this.allowedTypes.contains(type);
    }

    @Override
    public void setCleanAmount(int amount) {
    }

    @Override
    public void adjustCleanAmount(int amount) {
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

