/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbilityInstances
extends AbstractObjectList<Object> {
    public static final AbilityInstances EMPTY = new AbilityInstances(null){

        @Override
        public boolean isKey(MultiblockAbility<?> key) {
            return false;
        }

        @Override
        protected boolean canAdd(Object o) {
            return false;
        }

        @Override
        @NotNull
        public <R> List<R> cast() {
            return Collections.emptyList();
        }
    };
    private final MultiblockAbility<?> key;
    private final List<Object> instances = new ArrayList<Object>();

    public AbilityInstances(MultiblockAbility<?> key) {
        this.key = key;
    }

    public Object get(int index) {
        return this.instances.get(index);
    }

    public boolean isKey(MultiblockAbility<?> key) {
        return this.key.equals(key);
    }

    @NotNull
    public <R> List<R> cast() {
        return this.key.castList(this);
    }

    public boolean add(Object o) {
        int s = this.size();
        if (!this.canAdd(o) && o instanceof Iterable) {
            Iterable iterable = (Iterable)o;
            for (Object e : iterable) {
                this.add(this.size(), e);
            }
        } else {
            this.add(s, o);
        }
        return s != this.size();
    }

    protected boolean canAdd(Object o) {
        return this.key.checkType(o);
    }

    public void add(int index, Object element) {
        if (this.canAdd(element) && !this.instances.contains(element)) {
            this.instances.add(index, element);
        }
    }

    public Object set(int index, Object element) {
        if (!this.canAdd(element)) {
            return null;
        }
        int existing = this.instances.indexOf(element);
        if (existing != -1) {
            GTLog.logger.warn("attempted to set \"{}\" at index {} when we already have it at {}", (Object)element.getClass().getSimpleName(), (Object)index, (Object)existing);
            return null;
        }
        return this.instances.set(index, element);
    }

    public Object remove(int index) {
        return this.instances.remove(index);
    }

    public int size() {
        return this.instances.size();
    }

    public String toString() {
        return String.format("key{%s, %s}", this.key, super.toString());
    }
}

