/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.interfaces;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverableView;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public interface ISyncedTileEntity {
    public static final Consumer<PacketBuffer> NO_OP = buf -> {};
    public static final IntList datacodes = new IntArrayList();
    public static final ThreadLocal<Object> tracked = ThreadLocal.withInitial(() -> null);

    public void writeInitialSyncData(@NotNull PacketBuffer var1);

    public void receiveInitialSyncData(@NotNull PacketBuffer var1);

    public void writeCustomData(int var1, @NotNull @NotNull Consumer<@NotNull PacketBuffer> var2);

    default public void writeCustomData(int discriminator) {
        this.writeCustomData(discriminator, NO_OP);
    }

    public void receiveCustomData(int var1, @NotNull PacketBuffer var2);

    public static void checkData(@NotNull ByteBuf buf) {
        if (buf.readableBytes() != 0) {
            if (datacodes.isEmpty()) {
                GTLog.logger.error("Class {} failed to finish reading initialSyncData with {} bytes remaining", (Object)ISyncedTileEntity.stringify(tracked.get()), (Object)buf.readableBytes());
            } else {
                GTLog.logger.error("Class {} failed to finish reading receiveCustomData at code path [{}] with {} bytes remaining", (Object)ISyncedTileEntity.stringify(tracked.get()), (Object)ISyncedTileEntity.getCodePath(), (Object)buf.readableBytes());
            }
        }
        ISyncedTileEntity.reset();
    }

    public static String stringify(Object obj) {
        IGregTechTileEntity gtte;
        if (obj instanceof IGregTechTileEntity && (gtte = (IGregTechTileEntity)obj).getMetaTileEntity() != null) {
            obj = gtte.getMetaTileEntity();
        }
        StringBuilder builder = new StringBuilder(obj.getClass().getSimpleName());
        BlockPos pos = null;
        if (obj instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)obj;
            pos = tileEntity.func_174877_v();
        } else if (obj instanceof CoverableView) {
            CoverableView view = (CoverableView)obj;
            pos = view.getPos();
        } else if (obj instanceof Cover) {
            Cover cover = (Cover)obj;
            pos = cover.getPos();
            builder.append("[side=").append(cover.getAttachedSide()).append("]");
        }
        if (pos != null) {
            builder.append(" @ {").append(pos.func_177958_n()).append("X, ").append(pos.func_177956_o()).append("Y, ").append(pos.func_177952_p()).append("Z}");
        }
        return builder.toString();
    }

    public static void addCode(int code, Object trackedObject) {
        datacodes.add(code);
        ISyncedTileEntity.track(trackedObject);
    }

    public static void track(Object trackedObject) {
        tracked.set(trackedObject);
    }

    public static String getCodePath() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < datacodes.size(); ++i) {
            builder.append(GregtechDataCodes.getNameFor((Integer)datacodes.get(i)));
            if (i >= datacodes.size() - 1) continue;
            builder.append(" > ");
        }
        return builder.toString();
    }

    public static void reset() {
        datacodes.clear();
        tracked.remove();
    }
}

