/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WorkableTieredMetaTileEntity
extends TieredMetaTileEntity
implements IDataInfoProvider,
ICleanroomReceiver {
    protected final AbstractRecipeLogic workable;
    protected final RecipeMap<?> recipeMap;
    protected final ICubeRenderer renderer;
    private final Function<Integer, Integer> tankScalingFunction;
    public final boolean handlesRecipeOutputs;
    @Nullable
    private ICleanroomProvider cleanroom;

    public WorkableTieredMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, Function<Integer, Integer> tankScalingFunction) {
        this(metaTileEntityId, recipeMap, renderer, tier, tankScalingFunction, true);
    }

    public WorkableTieredMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, Function<Integer, Integer> tankScalingFunction, boolean handlesRecipeOutputs) {
        super(metaTileEntityId, tier);
        this.renderer = renderer;
        this.handlesRecipeOutputs = handlesRecipeOutputs;
        this.workable = this.createWorkable(recipeMap);
        this.recipeMap = recipeMap;
        this.tankScalingFunction = tankScalingFunction;
        this.initializeInventory();
        this.reinitializeEnergyContainer();
    }

    protected AbstractRecipeLogic createWorkable(RecipeMap<?> recipeMap) {
        return new RecipeLogicEnergy((MetaTileEntity)this, recipeMap, () -> this.energyContainer);
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = this.isEnergyEmitter() ? EnergyContainerHandler.emitterContainer(this, tierVoltage * 64L, tierVoltage, this.getMaxInputOutputAmperage()) : new EnergyContainerHandler(this, tierVoltage * 64L, tierVoltage, 2L, 0L, 0L){

            @Override
            public long getInputAmperage() {
                if (this.getEnergyCapacity() / 2L > this.getEnergyStored() && WorkableTieredMetaTileEntity.this.workable.isActive()) {
                    return 2L;
                }
                return 1L;
            }
        };
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return 2L;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.renderer.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.workable.isActive(), this.workable.isWorkingEnabled());
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.workable == null) {
            return new GTItemStackHandler((MetaTileEntity)this, 0);
        }
        return new NotifiableItemStackHandler(this, this.workable.getRecipeMap().getMaxInputs(), this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        if (this.workable == null) {
            return new GTItemStackHandler((MetaTileEntity)this, 0);
        }
        return new NotifiableItemStackHandler(this, this.workable.getRecipeMap().getMaxOutputs(), this, true);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        if (this.workable == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        NotifiableFluidTank[] fluidImports = new NotifiableFluidTank[this.workable.getRecipeMap().getMaxFluidInputs()];
        for (int i = 0; i < fluidImports.length; ++i) {
            NotifiableFluidTank filteredFluidHandler;
            fluidImports[i] = filteredFluidHandler = new NotifiableFluidTank(this.tankScalingFunction.apply(this.getTier()), this, false);
        }
        return new FluidTankList(false, (IFluidTank[])fluidImports);
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        if (this.workable == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        FluidTank[] fluidExports = new FluidTank[this.workable.getRecipeMap().getMaxFluidOutputs()];
        for (int i = 0; i < fluidExports.length; ++i) {
            fluidExports[i] = new NotifiableFluidTank(this.tankScalingFunction.apply(this.getTier()), this, true);
        }
        return new FluidTankList(false, (IFluidTank[])fluidExports);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        if (this.workable.getRecipeMap().getMaxFluidInputs() != 0) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.tankScalingFunction.apply(this.getTier())}));
        }
    }

    public Function<Integer, Integer> getTankScalingFunction() {
        return this.tankScalingFunction;
    }

    @Override
    public boolean isActive() {
        return this.workable.isActive() && this.workable.isWorkingEnabled();
    }

    @Override
    public SoundEvent getSound() {
        return this.workable.getRecipeMap().getSound();
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.workable != null) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_progress", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.workable.getProgress() / 20), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.workable.getMaxProgress() / 20), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
            if (this.energyContainer != null) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_stored_energy", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getEnergyStored()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getEnergyCapacity()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
            }
            if (this.workable.consumesEnergy()) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_consumption", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.workable.getInfoProviderEUt()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.workable.getInfoProviderEUt() == 0L ? 0L : 1L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
            } else {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_production", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.workable.getInfoProviderEUt()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.workable.getInfoProviderEUt() == 0L ? 0L : 1L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
            }
        }
        return list;
    }

    @Override
    @Nullable
    public ICleanroomProvider getCleanroom() {
        return this.cleanroom;
    }

    @Override
    public void setCleanroom(@NotNull ICleanroomProvider provider) {
        this.cleanroom = provider;
    }

    @Override
    public void unsetCleanroom() {
        this.cleanroom = null;
    }
}

