/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TieredMetaTileEntity
extends MetaTileEntity
implements EnergyContainerHandler.IEnergyChangeListener,
ITieredMetaTileEntity {
    private final int tier;
    protected IEnergyContainer energyContainer;

    public TieredMetaTileEntity(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
        this.reinitializeEnergyContainer();
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.tier];
        this.energyContainer = this.isEnergyEmitter() ? EnergyContainerHandler.emitterContainer(this, tierVoltage * 64L, tierVoltage, this.getMaxInputOutputAmperage()) : EnergyContainerHandler.receiverContainer(this, tierVoltage * 64L, tierVoltage, this.getMaxInputOutputAmperage());
    }

    @Override
    public void onEnergyChanged(IEnergyContainer container, boolean isInitialChange) {
    }

    @SideOnly(value=Side.CLIENT)
    protected SimpleSidedCubeRenderer getBaseRenderer() {
        return Textures.VOLTAGE_CASINGS[this.tier];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseRenderer().getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
    }

    @Override
    public void update() {
        super.update();
        this.checkWeatherOrTerrainExplosion(this.tier, this.tier * 10, this.energyContainer);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    protected long getMaxInputOutputAmperage() {
        return 1L;
    }

    protected boolean isEnergyEmitter() {
        return false;
    }
}

