/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.block.BlockStateTileEntity;
import gregtech.api.metatileentity.interfaces.ISyncedTileEntity;
import gregtech.api.network.PacketDataList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyncedTileEntityBase
extends BlockStateTileEntity
implements ISyncedTileEntity {
    public static final int SIZE_THRESHOLD = 10;
    private final PacketDataList updates = new PacketDataList();

    @Nullable
    public TileEntity getNeighbor(EnumFacing facing) {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
    }

    @Override
    public final void writeCustomData(int discriminator, @NotNull @NotNull Consumer<@NotNull PacketBuffer> dataWriter) {
        ByteBuf backedBuffer = Unpooled.buffer();
        dataWriter.accept(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        this.updates.add(discriminator, updateData);
        this.notifyWorld();
    }

    public void addPacketsFrom(SyncedTileEntityBase syncedTileEntityBase) {
        if (this == syncedTileEntityBase || syncedTileEntityBase.updates.isEmpty()) {
            return;
        }
        boolean wasEmpty = this.updates.isEmpty();
        this.updates.addAll(syncedTileEntityBase.updates);
        syncedTileEntityBase.updates.clear();
        if (wasEmpty) {
            this.notifyWorld();
        }
    }

    private void notifyWorld() {
        IBlockState blockState = this.func_145838_q().func_176203_a(this.func_145832_p());
        if (this.canNotifyWorld()) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 0);
        }
    }

    private boolean canNotifyWorld() {
        World world;
        if (this.updates.size() > 10 && (world = this.func_145831_w()) instanceof WorldServer) {
            WorldServer server = (WorldServer)world;
            int x = this.func_174877_v().func_177958_n() >> 4;
            int z = this.func_174877_v().func_177952_p() >> 4;
            if (server.func_184164_w().func_152621_a(x, z)) {
                return true;
            }
            this.updates.clear();
            return false;
        }
        return true;
    }

    @Nullable
    public final SPacketUpdateTileEntity func_189518_D_() {
        if (this.updates.isEmpty()) {
            return null;
        }
        NBTTagCompound updateTag = new NBTTagCompound();
        updateTag.func_74782_a("d", (NBTBase)this.updates.dumpToNbt());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
    }

    public final void onDataPacket(@NotNull NetworkManager net, @NotNull SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTag = pkt.func_148857_g();
        NBTTagList listTag = updateTag.func_150295_c("d", 10);
        for (NBTBase entryBase : listTag) {
            NBTTagCompound entryTag = (NBTTagCompound)entryBase;
            for (String discriminatorKey : entryTag.func_150296_c()) {
                ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])entryTag.func_74770_j(discriminatorKey));
                int dataId = Integer.parseInt(discriminatorKey);
                ISyncedTileEntity.addCode(dataId, this);
                this.receiveCustomData(dataId, new PacketBuffer(backedBuffer));
                ISyncedTileEntity.checkData(backedBuffer);
            }
        }
    }

    @NotNull
    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        ByteBuf backedBuffer = Unpooled.buffer();
        this.writeInitialSyncData(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        updateTag.func_74773_a("d", updateData);
        return updateTag;
    }

    public final void handleUpdateTag(@NotNull NBTTagCompound tag) {
        super.func_145839_a(tag);
        byte[] updateData = tag.func_74770_j("d");
        ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])updateData);
        ISyncedTileEntity.track(this);
        this.receiveInitialSyncData(new PacketBuffer(backedBuffer));
        ISyncedTileEntity.checkData(backedBuffer);
    }
}

