/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.metatileentity.interfaces.INeighborCache;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NeighborCacheTileEntityBase
extends SyncedTileEntityBase
implements INeighborCache {
    private static final WeakReference<TileEntity> NULL = new WeakReference<Object>(null);
    private static final WeakReference<TileEntity> INVALID = new WeakReference<Object>(null);
    private final List<WeakReference<TileEntity>> neighbors = Arrays.asList(INVALID, INVALID, INVALID, INVALID, INVALID, INVALID);
    private boolean neighborsInvalidated = false;

    public NeighborCacheTileEntityBase() {
        this.invalidateNeighbors();
    }

    protected void invalidateNeighbors() {
        if (!this.neighborsInvalidated) {
            for (EnumFacing value : EnumFacing.field_82609_l) {
                this.neighbors.set(value.func_176745_a(), INVALID);
            }
            this.neighborsInvalidated = true;
        }
    }

    @MustBeInvokedByOverriders
    public void func_145834_a(@NotNull World worldIn) {
        super.func_145834_a(worldIn);
        this.invalidateNeighbors();
    }

    @MustBeInvokedByOverriders
    public void func_174878_a(@NotNull BlockPos posIn) {
        super.func_174878_a(posIn);
        this.invalidateNeighbors();
    }

    @MustBeInvokedByOverriders
    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateNeighbors();
    }

    @MustBeInvokedByOverriders
    public void onChunkUnload() {
        super.onChunkUnload();
        this.invalidateNeighbors();
    }

    @Override
    @Nullable
    public TileEntity getNeighbor(@NotNull EnumFacing facing) {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        WeakReference<TileEntity> ref = this.invalidRef(facing) ? this.computeNeighbor(facing) : this.getRef(facing);
        return (TileEntity)ref.get();
    }

    private boolean invalidRef(EnumFacing facing) {
        WeakReference<TileEntity> ref = this.getRef(facing);
        if (ref == INVALID) {
            return true;
        }
        TileEntity te = (TileEntity)ref.get();
        return te != null && te.func_145837_r();
    }

    @NotNull
    private WeakReference<TileEntity> computeNeighbor(EnumFacing facing) {
        TileEntity te = super.getNeighbor(facing);
        WeakReference<TileEntity> ref = te == null ? NULL : new WeakReference<TileEntity>(te);
        this.neighbors.set(facing.func_176745_a(), ref);
        this.neighborsInvalidated = false;
        return ref;
    }

    @NotNull
    private WeakReference<TileEntity> getRef(EnumFacing facing) {
        return this.neighbors.get(facing.func_176745_a());
    }

    @Override
    public void onNeighborChanged(@NotNull EnumFacing facing) {
        this.neighbors.set(facing.func_176745_a(), INVALID);
    }
}

