/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.ISyncedTileEntity;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public abstract class MTETrait
implements ISyncedTileEntity {
    private static final Object2IntFunction<String> traitIds = new Object2IntOpenHashMap();
    private static final int NO_NETWORK_ID = -1;
    private static int rollingNetworkId = 0;
    protected final MetaTileEntity metaTileEntity;
    private final int networkId;

    public MTETrait(@NotNull MetaTileEntity metaTileEntity) {
        this.metaTileEntity = metaTileEntity;
        String traitName = this.getName();
        int networkId = traitIds.getInt((Object)traitName);
        if (networkId == -1) {
            networkId = rollingNetworkId++;
            traitIds.put((Object)traitName, networkId);
        }
        this.networkId = networkId;
        metaTileEntity.addMetaTileEntityTrait(this);
    }

    @NotNull
    public MetaTileEntity getMetaTileEntity() {
        return this.metaTileEntity;
    }

    @NotNull
    public abstract String getName();

    public final int getNetworkID() {
        return this.networkId;
    }

    public abstract <T> T getCapability(Capability<T> var1);

    public void onFrontFacingSet(EnumFacing newFrontFacing) {
    }

    public void update() {
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(@NotNull NBTTagCompound compound) {
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
    }

    @Override
    public void receiveCustomData(int discriminator, @NotNull PacketBuffer buf) {
    }

    @Override
    public final void writeCustomData(int discriminator, @NotNull @NotNull Consumer<@NotNull PacketBuffer> dataWriter) {
        this.metaTileEntity.writeTraitData(this, discriminator, dataWriter);
    }

    public String toString() {
        return "MTETrait{metaTileEntity=" + this.metaTileEntity + ", networkId=" + this.networkId + ", name='" + this.getName() + '\'' + '}';
    }

    static {
        traitIds.defaultReturnValue(-1);
    }
}

