/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem.aoe;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.Nullable;

public class AoESymmetrical {
    private static final AoESymmetrical NONE = new AoESymmetrical();
    public final int column;
    public final int row;
    public final int layer;

    public static AoESymmetrical readMax(NBTTagCompound tag) {
        int column = 0;
        int row = 0;
        int layer = 0;
        if (tag.func_150297_b("MaxAoEColumn", 3)) {
            column = tag.func_74762_e("MaxAoEColumn");
        }
        if (tag.func_150297_b("MaxAoERow", 3)) {
            row = tag.func_74762_e("MaxAoERow");
        }
        if (tag.func_150297_b("MaxAoELayer", 3)) {
            layer = tag.func_74762_e("MaxAoELayer");
        }
        return column == 0 && row == 0 && layer == 0 ? NONE : new AoESymmetrical(column, row, layer);
    }

    public static AoESymmetrical read(NBTTagCompound tag, @Nullable AoESymmetrical defaultDefinition) {
        int layer;
        int row;
        int column;
        if (tag.func_150297_b("AoEColumn", 3)) {
            column = tag.func_74762_e("AoEColumn");
        } else {
            int n = column = defaultDefinition == null ? 0 : defaultDefinition.column;
        }
        if (tag.func_150297_b("AoERow", 3)) {
            row = tag.func_74762_e("AoERow");
        } else {
            int n = row = defaultDefinition == null ? 0 : defaultDefinition.row;
        }
        if (tag.func_150297_b("AoELayer", 3)) {
            layer = tag.func_74762_e("AoELayer");
        } else {
            int n = layer = defaultDefinition == null ? 0 : defaultDefinition.layer;
        }
        if (column == 0 && row == 0 && layer == 0) {
            return NONE;
        }
        tag.func_74768_a("AoEColumn", column);
        tag.func_74768_a("AoERow", row);
        tag.func_74768_a("AoELayer", layer);
        return new AoESymmetrical(column, row, layer);
    }

    public static int getColumn(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        if (tag.func_150297_b("AoEColumn", 3)) {
            return tag.func_74762_e("AoEColumn");
        }
        return defaultDefinition.column;
    }

    public static int getRow(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        if (tag.func_150297_b("AoERow", 3)) {
            return tag.func_74762_e("AoERow");
        }
        return defaultDefinition.row;
    }

    public static int getLayer(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        if (tag.func_150297_b("AoELayer", 3)) {
            return tag.func_74762_e("AoELayer");
        }
        return defaultDefinition.layer;
    }

    public static void setColumn(NBTTagCompound tag, int i, AoESymmetrical defaultDefinition) {
        tag.func_74768_a("AoEColumn", MathHelper.func_76125_a((int)i, (int)0, (int)defaultDefinition.column));
    }

    public static void setRow(NBTTagCompound tag, int i, AoESymmetrical defaultDefinition) {
        tag.func_74768_a("AoERow", MathHelper.func_76125_a((int)i, (int)0, (int)defaultDefinition.row));
    }

    public static void setLayer(NBTTagCompound tag, int i, AoESymmetrical defaultDefinition) {
        tag.func_74768_a("AoELayer", MathHelper.func_76125_a((int)i, (int)0, (int)defaultDefinition.layer));
    }

    public static void increaseColumn(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        int currentColumn = AoESymmetrical.getColumn(tag, defaultDefinition);
        AoESymmetrical.setColumn(tag, currentColumn + 1, defaultDefinition);
    }

    public static void increaseRow(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        int currentRow = AoESymmetrical.getRow(tag, defaultDefinition);
        AoESymmetrical.setRow(tag, currentRow + 1, defaultDefinition);
    }

    public static void increaseLayer(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        int currentLayer = AoESymmetrical.getLayer(tag, defaultDefinition);
        AoESymmetrical.setLayer(tag, currentLayer + 1, defaultDefinition);
    }

    public static void decreaseColumn(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        int currentColumn = AoESymmetrical.getColumn(tag, defaultDefinition);
        AoESymmetrical.setColumn(tag, currentColumn - 1, defaultDefinition);
    }

    public static void decreaseRow(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        int currentRow = AoESymmetrical.getRow(tag, defaultDefinition);
        AoESymmetrical.setRow(tag, currentRow - 1, defaultDefinition);
    }

    public static void decreaseLayer(NBTTagCompound tag, AoESymmetrical defaultDefinition) {
        int currentLayer = AoESymmetrical.getLayer(tag, defaultDefinition);
        AoESymmetrical.setLayer(tag, currentLayer - 1, defaultDefinition);
    }

    public static AoESymmetrical none() {
        return NONE;
    }

    public static AoESymmetrical of(int column, int row, int layer) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"Height cannot be negative.");
        Preconditions.checkArgument((row >= 0 ? 1 : 0) != 0, (Object)"Width cannot be negative.");
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"Depth cannot be negative.");
        return column == 0 && row == 0 && layer == 0 ? NONE : new AoESymmetrical(column, row, layer);
    }

    private AoESymmetrical() {
        this.column = 0;
        this.row = 0;
        this.layer = 0;
    }

    private AoESymmetrical(int column, int row, int layer) {
        this.column = column;
        this.row = row;
        this.layer = layer;
    }
}

