/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ItemGTSword;
import gregtech.api.items.toolitem.ItemGTToolbelt;
import gregtech.api.items.toolitem.TreeFellingListener;
import gregtech.api.items.toolitem.aoe.AoESymmetrical;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.api.util.function.QuintFunction;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.ColorSprayBehaviour;
import gregtech.tools.enchants.EnchantmentHardHammer;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolHelper {
    public static final String TOOL_TAG_KEY = "GT.Tool";
    public static final String BEHAVIOURS_TAG_KEY = "GT.Behaviours";
    public static final String MAX_CHARGE_KEY = "MaxCharge";
    public static final String CHARGE_KEY = "Charge";
    public static final String UNBREAKABLE_KEY = "Unbreakable";
    public static final String HIDE_FLAGS = "HideFlags";
    public static final String DISALLOW_CONTAINER_ITEM_KEY = "DisallowContainerItem";
    public static final String MATERIAL_KEY = "Material";
    public static final String DURABILITY_KEY = "Durability";
    public static final String MAX_DURABILITY_KEY = "MaxDurability";
    public static final String TOOL_SPEED_KEY = "ToolSpeed";
    public static final String ATTACK_DAMAGE_KEY = "AttackDamage";
    public static final String ATTACK_SPEED_KEY = "AttackSpeed";
    public static final String ENCHANTABILITY_KEY = "Enchantability";
    public static final String HARVEST_LEVEL_KEY = "HarvestLevel";
    public static final String LAST_CRAFTING_USE_KEY = "LastCraftingUse";
    public static final String MAX_AOE_COLUMN_KEY = "MaxAoEColumn";
    public static final String MAX_AOE_ROW_KEY = "MaxAoERow";
    public static final String MAX_AOE_LAYER_KEY = "MaxAoELayer";
    public static final String AOE_COLUMN_KEY = "AoEColumn";
    public static final String AOE_ROW_KEY = "AoERow";
    public static final String AOE_LAYER_KEY = "AoELayer";
    public static final String HARVEST_ICE_KEY = "HarvestIce";
    public static final String TORCH_PLACING_KEY = "TorchPlacing";
    public static final String TORCH_PLACING_CACHE_SLOT_KEY = "TorchPlacing$Slot";
    public static final String TREE_FELLING_KEY = "TreeFelling";
    public static final String DISABLE_SHIELDS_KEY = "DisableShields";
    public static final String RELOCATE_MINED_BLOCKS_KEY = "RelocateMinedBlocks";
    private static final BiMap<Character, IGTTool> symbols = HashBiMap.create();
    public static final Set<Block> PICKAXE_HARVESTABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150408_cc, (Object)Blocks.field_150365_q, (Object)Blocks.field_150347_e, (Object)Blocks.field_150319_E, (Object)Blocks.field_150484_ah, (Object)Blocks.field_150482_ag, (Object[])new Block[]{Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    public static final Set<Block> STONE_PICKAXE_HARVESTABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150339_S, (Object)Blocks.field_150366_p, (Object)Blocks.field_150368_y, (Object)Blocks.field_150369_x);
    public static final Set<Block> IRON_PICKAXE_HARVESTABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150484_ah, (Object)Blocks.field_150482_ag, (Object)Blocks.field_150412_bA, (Object)Blocks.field_150475_bE, (Object)Blocks.field_150340_R, (Object)Blocks.field_150352_o, (Object[])new Block[0]);
    public static final Set<Block> SHOVEL_HARVESTABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150435_aG, (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak, (Object)Blocks.field_150349_c, (Object)Blocks.field_150351_n, (Object)Blocks.field_150391_bh, (Object[])new Block[]{Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_192444_dS});
    public static final Set<Block> AXE_HARVESTABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150344_f, (Object)Blocks.field_150342_X, (Object)Blocks.field_150364_r, (Object)Blocks.field_150363_s, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150423_aK, (Object[])new Block[]{Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_LV = () -> MetaItems.POWER_UNIT_LV.getStackForm();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_MV = () -> MetaItems.POWER_UNIT_MV.getStackForm();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_HV = () -> MetaItems.POWER_UNIT_HV.getStackForm();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_EV = () -> MetaItems.POWER_UNIT_EV.getStackForm();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_IV = () -> MetaItems.POWER_UNIT_IV.getStackForm();
    private static final MethodHandle GET_SILK_TOUCH_DROP;

    private ToolHelper() {
    }

    public static Character getSymbolFromTool(IGTTool tool) {
        return (Character)symbols.inverse().get((Object)tool);
    }

    public static IGTTool getToolFromSymbol(Character symbol) {
        return (IGTTool)symbols.get((Object)symbol);
    }

    public static void registerToolSymbol(Character symbol, IGTTool tool) {
        symbols.put((Object)symbol, (Object)tool);
    }

    public static NBTTagCompound getToolTag(ItemStack stack) {
        stack = ToolHelper.toolbeltPassthrough(stack);
        return stack.func_190925_c(TOOL_TAG_KEY);
    }

    public static ItemStack toolbeltPassthrough(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemGTToolbelt) {
            ItemStack selected;
            ItemGTToolbelt toolbelt = (ItemGTToolbelt)item;
            if (ToolHelper.hasMaterial(stack) && !(selected = toolbelt.getSelectedTool(stack)).func_190926_b()) {
                stack = selected;
            }
        }
        return stack;
    }

    public static NBTTagCompound getBehaviorsTag(ItemStack stack) {
        stack = ToolHelper.toolbeltPassthrough(stack);
        return stack.func_190925_c(BEHAVIOURS_TAG_KEY);
    }

    public static void setBehaviorsTag(ItemStack stack, NBTTagCompound tag) {
        stack = ToolHelper.toolbeltPassthrough(stack);
        stack.func_77983_a(BEHAVIOURS_TAG_KEY, (NBTBase)tag);
    }

    public static ItemStack getAndSetToolData(IGTTool tool, gregtech.api.unification.material.Material material, int maxDurability, int harvestLevel, float toolSpeed, float attackDamage) {
        ItemStack stack = tool.getRaw();
        GTUtility.getOrCreateNbtCompound(stack).func_74768_a(HIDE_FLAGS, 2);
        NBTTagCompound toolTag = ToolHelper.getToolTag(stack);
        toolTag.func_74778_a(MATERIAL_KEY, material.getRegistryName());
        toolTag.func_74768_a(MAX_DURABILITY_KEY, maxDurability);
        toolTag.func_74768_a(HARVEST_LEVEL_KEY, harvestLevel);
        toolTag.func_74776_a(TOOL_SPEED_KEY, toolSpeed);
        toolTag.func_74776_a(ATTACK_DAMAGE_KEY, attackDamage);
        MaterialToolProperty materialToolProperty = material.getProperty(PropertyKey.TOOL);
        if (materialToolProperty != null) {
            materialToolProperty.getEnchantments().forEach((enchantment, level) -> {
                if (stack.func_77973_b().canApplyAtEnchantingTable(stack, enchantment)) {
                    stack.func_77966_a(enchantment, level.getLevel(materialToolProperty.getToolHarvestLevel()));
                }
            });
        }
        return stack;
    }

    public static void damageItemWhenCrafting(@NotNull ItemStack stack, @Nullable EntityLivingBase entity) {
        ItemGTToolbelt toolbelt;
        ItemStack selectedStack;
        Item item = stack.func_77973_b();
        if (item instanceof ItemGTToolbelt && !(selectedStack = (toolbelt = (ItemGTToolbelt)item).getSelectedTool(stack)).func_190926_b()) {
            ToolHelper.damageItemWhenCrafting(selectedStack, entity);
            return;
        }
        int damage = 2;
        if (stack.func_77973_b() instanceof IGTTool) {
            damage = ((IGTTool)stack.func_77973_b()).getToolStats().getToolDamagePerCraft(stack);
        } else if (OreDictUnifier.getOreDictionaryNames(stack).stream().anyMatch(s -> s.startsWith("tool") || s.startsWith("craftingTool"))) {
            damage = 1;
        }
        ToolHelper.damageItem(stack, entity, damage);
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable EntityLivingBase entity) {
        ToolHelper.damageItem(stack, entity, 1);
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable EntityLivingBase entity, int damage) {
        ItemGTToolbelt toolbelt;
        ItemStack selectedStack;
        Item item = stack.func_77973_b();
        if (!(item instanceof IGTTool)) {
            if (entity != null) {
                stack.func_77972_a(damage, entity);
            }
            return;
        }
        IGTTool tool = (IGTTool)item;
        item = stack.func_77973_b();
        if (item instanceof ItemGTToolbelt && !(selectedStack = (toolbelt = (ItemGTToolbelt)item).getSelectedTool(stack)).func_190926_b()) {
            ToolHelper.damageItem(selectedStack, entity, damage);
            return;
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n(UNBREAKABLE_KEY)) {
            return;
        }
        if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            Random random;
            Random random2 = random = entity == null ? GTValues.RNG : entity.func_70681_au();
            if (tool.isElectric()) {
                int electricDamage = damage * ConfigHolder.machines.energyUsageMultiplier;
                IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                if (electricItem != null) {
                    electricItem.discharge(electricDamage, tool.getElectricTier(), true, false, false);
                    if (electricItem.getCharge() > 0L && random.nextInt(100) >= ConfigHolder.tools.rngDamageElectricTools) {
                        return;
                    }
                } else {
                    throw new IllegalStateException("Electric tool does not have an attached electric item capability.");
                }
            }
            int unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
            int negated = 0;
            for (int k = 0; unbreakingLevel > 0 && k < damage; ++k) {
                if (!EnchantmentDurability.func_92097_a((ItemStack)stack, (int)unbreakingLevel, (Random)random)) continue;
                ++negated;
            }
            if ((damage -= negated) <= 0) {
                return;
            }
            int newDurability = stack.func_77952_i() + damage;
            if (entity instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193132_s.func_193158_a((EntityPlayerMP)entity, stack, newDurability);
            }
            stack.func_77964_b(newDurability);
            if (newDurability > stack.func_77958_k()) {
                StatBase stat;
                if (entity instanceof EntityPlayer && (stat = StatList.func_188059_c((Item)stack.func_77973_b())) != null) {
                    ((EntityPlayer)entity).func_71029_a(stat);
                }
                if (entity != null) {
                    entity.func_70669_a(stack);
                }
                stack.func_190918_g(1);
            }
        }
    }

    public static void onActionDone(@NotNull EntityPlayer player, @NotNull World world, @NotNull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        stack = ToolHelper.toolbeltPassthrough(stack);
        IGTTool tool = (IGTTool)stack.func_77973_b();
        ToolHelper.damageItem(stack, (EntityLivingBase)player);
        if (tool.getSound() != null) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, tool.getSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        player.func_184609_a(hand);
    }

    public static boolean isTool(ItemStack tool, String ... toolClasses) {
        if (toolClasses.length == 1) {
            return tool.func_77973_b().getToolClasses(tool).contains(toolClasses[0]);
        }
        for (String toolClass : tool.func_77973_b().getToolClasses(tool)) {
            for (String specified : toolClasses) {
                if (!toolClass.equals(specified)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUtilityItem(ItemStack utility) {
        return ToolHelper.isTool(utility) || ToolHelper.isSpraycan(utility);
    }

    public static boolean isTool(ItemStack tool) {
        return tool.func_77973_b() instanceof ItemTool || tool.func_77973_b() instanceof IGTTool;
    }

    public static boolean isSpraycan(ItemStack spraycan) {
        Item item = spraycan.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem meta = (MetaItem)item;
            for (IItemBehaviour behaviour : meta.getBehaviours(spraycan)) {
                if (!(behaviour instanceof ColorSprayBehaviour)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areTools(ItemStack tool, String ... toolClasses) {
        if (toolClasses.length == 1) {
            return tool.func_77973_b().getToolClasses(tool).contains(toolClasses[0]);
        }
        return tool.func_77973_b().getToolClasses(tool).containsAll((Collection<?>)new ObjectArraySet((Object[])toolClasses));
    }

    public static int getFortuneOrLootingLevel(ItemStack tool) {
        if ((tool = ToolHelper.toolbeltPassthrough(tool)).func_77973_b() instanceof ItemGTSword) {
            return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)tool);
        }
        if (tool.func_77973_b() instanceof IGTTool) {
            return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        }
        return 0;
    }

    public static AoESymmetrical getMaxAoEDefinition(ItemStack stack) {
        return AoESymmetrical.readMax(ToolHelper.getBehaviorsTag(stack));
    }

    public static AoESymmetrical getAoEDefinition(ItemStack stack) {
        return AoESymmetrical.read(ToolHelper.getBehaviorsTag(stack), ToolHelper.getMaxAoEDefinition(stack));
    }

    public static boolean areaOfEffectBlockBreakRoutine(ItemStack stack, EntityPlayerMP player) {
        stack = ToolHelper.toolbeltPassthrough(stack);
        int currentDurability = ToolHelper.getToolTag(stack).func_74762_e(DURABILITY_KEY);
        int maximumDurability = ToolHelper.getToolTag(stack).func_74762_e(MAX_DURABILITY_KEY);
        int remainingUses = maximumDurability - currentDurability;
        Set<BlockPos> harvestableBlocks = ToolHelper.getHarvestableBlocks(stack, (EntityPlayer)player);
        if (!harvestableBlocks.isEmpty()) {
            for (BlockPos pos : harvestableBlocks) {
                if (!ToolHelper.breakBlockRoutine(player, stack, pos)) {
                    return true;
                }
                if (stack.func_77973_b() instanceof IGTTool && !((IGTTool)stack.func_77973_b()).isElectric() && --remainingUses == 0) {
                    return true;
                }
                ItemStack tool = player.func_184614_ca();
                if ((tool = ToolHelper.toolbeltPassthrough(tool)).func_185136_b(stack)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static Set<BlockPos> iterateAoE(ItemStack stack, AoESymmetrical aoeDefinition, World world, EntityPlayer player, RayTraceResult rayTraceResult, QuintFunction<ItemStack, World, EntityPlayer, BlockPos, BlockPos, Boolean> function) {
        stack = ToolHelper.toolbeltPassthrough(stack);
        if (aoeDefinition != AoESymmetrical.none() && rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResult.field_178784_b != null) {
            int column = aoeDefinition.column;
            int row = aoeDefinition.row;
            int layer = aoeDefinition.layer;
            EnumFacing playerFacing = player.func_174811_aO();
            EnumFacing.Axis playerAxis = playerFacing.func_176740_k();
            EnumFacing.Axis sideHitAxis = rayTraceResult.field_178784_b.func_176740_k();
            EnumFacing.AxisDirection sideHitAxisDir = rayTraceResult.field_178784_b.func_176743_c();
            ObjectOpenHashSet validPositions = new ObjectOpenHashSet();
            if (sideHitAxis.func_176720_b()) {
                boolean isX = playerAxis == EnumFacing.Axis.X;
                boolean isDown = sideHitAxisDir == EnumFacing.AxisDirection.NEGATIVE;
                for (int y = 0; y <= layer; ++y) {
                    for (int x = isX ? -row : -column; x <= (isX ? row : column); ++x) {
                        for (int z = isX ? -column : -row; z <= (isX ? column : row); ++z) {
                            BlockPos pos;
                            if (x == 0 && y == 0 && z == 0 || !player.func_175151_a((pos = rayTraceResult.func_178782_a().func_177982_a(x, isDown ? y : -y, z)).func_177972_a(rayTraceResult.field_178784_b), rayTraceResult.field_178784_b, stack) || !function.apply(stack, world, player, pos, rayTraceResult.func_178782_a()).booleanValue()) continue;
                            validPositions.add(pos);
                        }
                    }
                }
            } else {
                boolean isX = sideHitAxis == EnumFacing.Axis.X;
                boolean isNegative = sideHitAxisDir == EnumFacing.AxisDirection.NEGATIVE;
                for (int x = 0; x <= layer; ++x) {
                    for (int y = row == 0 ? 0 : -1; y <= (row == 0 ? 0 : row * 2 - 1); ++y) {
                        for (int z = -column; z <= column; ++z) {
                            if (x == 0 && y == 0 && z == 0) continue;
                            BlockPos pos = rayTraceResult.func_178782_a().func_177982_a(isX ? (isNegative ? x : -x) : (isNegative ? z : -z), y, isX ? (isNegative ? z : -z) : (isNegative ? x : -x));
                            if (!function.apply(stack, world, player, pos, rayTraceResult.func_178782_a()).booleanValue()) continue;
                            validPositions.add(pos);
                        }
                    }
                }
            }
            return validPositions;
        }
        return Collections.emptySet();
    }

    public static Set<BlockPos> getHarvestableBlocks(ItemStack stack, AoESymmetrical aoeDefinition, World world, EntityPlayer player, RayTraceResult rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, ToolHelper::isBlockAoEHarvestable);
    }

    private static boolean isBlockAoEHarvestable(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos hitBlockPos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockLiquid) {
            return false;
        }
        IBlockState hitBlockState = world.func_180495_p(hitBlockPos);
        if (state.func_185887_b(world, pos) < 0.0f || state.func_185887_b(world, pos) - hitBlockState.func_185887_b(world, hitBlockPos) > 8.0f) {
            return false;
        }
        state = state.func_185899_b((IBlockAccess)world, pos);
        return stack.func_150998_b(state);
    }

    public static boolean canMineWithPick(String tool) {
        return "wrench".equals(tool) || "wirecutter".equals(tool);
    }

    public static boolean isToolEffective(IBlockState state, Set<String> toolClasses, int harvestLevel) {
        Block block = state.func_177230_c();
        String harvestTool = block.getHarvestTool(state);
        if (ToolHelper.canMineWithPick(harvestTool) && ConfigHolder.machines.requireGTToolsForBlocks && !toolClasses.contains(harvestTool)) {
            return false;
        }
        if (toolClasses.contains(harvestTool)) {
            return block.getHarvestLevel(state) <= harvestLevel;
        }
        Material material = state.func_185904_a();
        if (toolClasses.contains("pickaxe")) {
            if (Blocks.field_150343_Z == block && harvestLevel >= 3) {
                return true;
            }
            if (IRON_PICKAXE_HARVESTABLE_BLOCKS.contains(block) && harvestLevel >= 2) {
                return true;
            }
            if (STONE_PICKAXE_HARVESTABLE_BLOCKS.contains(block) && harvestLevel >= 1) {
                return true;
            }
            if (PICKAXE_HARVESTABLE_BLOCKS.contains(block)) {
                return true;
            }
            if (material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g) {
                return true;
            }
        }
        if (toolClasses.contains("shovel")) {
            if (SHOVEL_HARVESTABLE_BLOCKS.contains(block)) {
                return true;
            }
            if (block == Blocks.field_150431_aC || block == Blocks.field_150433_aE) {
                return true;
            }
        }
        if (toolClasses.contains("axe")) {
            if (AXE_HARVESTABLE_BLOCKS.contains(block)) {
                return true;
            }
            if (material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l) {
                return true;
            }
        }
        if (toolClasses.contains("sword")) {
            if (block instanceof BlockWeb) {
                return true;
            }
            if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
                return true;
            }
        }
        if (toolClasses.contains("scythe") && (material == Material.field_151584_j || material == Material.field_151582_l || material == Material.field_151570_A || material == Material.field_151585_k)) {
            return true;
        }
        if (toolClasses.contains("file") && block instanceof BlockPane && material == Material.field_151573_f) {
            return true;
        }
        if (toolClasses.contains("crowbar")) {
            return block instanceof BlockRailBase || material == Material.field_151594_q;
        }
        return false;
    }

    public static float getDestroySpeed(IBlockState state, Set<String> toolClasses) {
        if (toolClasses.contains("sword")) {
            Block block = state.func_177230_c();
            if (block instanceof BlockWeb) {
                return 15.0f;
            }
            Material material = state.func_185904_a();
            if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
                return 1.5f;
            }
        }
        return -1.0f;
    }

    public static Set<BlockPos> getHarvestableBlocks(ItemStack stack, World world, EntityPlayer player, RayTraceResult rayTraceResult) {
        return ToolHelper.getHarvestableBlocks(stack, ToolHelper.getAoEDefinition(stack), world, player, rayTraceResult);
    }

    public static Set<BlockPos> getHarvestableBlocks(ItemStack stack, EntityPlayer player) {
        AoESymmetrical aoeDefiniton = ToolHelper.getAoEDefinition(stack);
        if (aoeDefiniton == AoESymmetrical.none()) {
            return Collections.emptySet();
        }
        RayTraceResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
        return ToolHelper.getHarvestableBlocks(stack, aoeDefiniton, player.field_70170_p, player, rayTraceResult);
    }

    public static RayTraceResult getPlayerDefaultRaytrace(@NotNull EntityPlayer player) {
        Vec3d lookPos = player.func_174824_e(1.0f);
        Vec3d rotation = player.func_70676_i(1.0f);
        Vec3d realLookPos = lookPos.func_72441_c(rotation.field_72450_a * 5.0, rotation.field_72448_b * 5.0, rotation.field_72449_c * 5.0);
        return player.field_70170_p.func_72933_a(lookPos, realLookPos);
    }

    public static void treeFellingRoutine(EntityPlayerMP player, ItemStack stack, BlockPos start) {
        IBlockState state = player.field_70170_p.func_180495_p(start);
        if (state.func_177230_c().isWood((IBlockAccess)player.field_70170_p, start)) {
            TreeFellingListener.start(state, stack, start, player);
        }
    }

    public static void applyHammerDropConversion(ItemStack tool, IBlockState state, List<ItemStack> drops, int fortune, float dropChance, Random random) {
        block2: {
            OrePrefix prefix;
            Recipe hammerRecipe;
            block3: {
                List<ItemStack> dropAsList;
                ItemStack silktouchDrop;
                if (!tool.func_77973_b().getToolClasses(tool).contains("hammer") && EnchantmentHelper.func_77506_a((Enchantment)EnchantmentHardHammer.INSTANCE, (ItemStack)tool) <= 0 || (silktouchDrop = ToolHelper.getSilkTouchDrop(state)).func_190926_b() || (hammerRecipe = RecipeMaps.FORGE_HAMMER_RECIPES.findRecipe(GTValues.V[1], dropAsList = Collections.singletonList(silktouchDrop), Collections.emptyList(), false)) == null || !hammerRecipe.matches(true, dropAsList, Collections.emptyList())) break block2;
                drops.clear();
                prefix = OreDictUnifier.getPrefix(silktouchDrop);
                if (prefix != null) break block3;
                for (ItemStack output : hammerRecipe.getOutputs()) {
                    if (dropChance != 1.0f && !(random.nextFloat() <= dropChance)) continue;
                    drops.add(output.func_77946_l());
                }
                break block2;
            }
            if (!prefix.name.startsWith("ore")) break block2;
            for (ItemStack output : hammerRecipe.getOutputs()) {
                if (dropChance != 1.0f && !(random.nextFloat() <= dropChance) || OreDictUnifier.getPrefix(output) != OrePrefix.crushed) continue;
                output = output.func_77946_l();
                output.func_190917_f(random.nextInt(fortune));
                drops.add(output);
            }
        }
    }

    public static boolean breakBlockRoutine(EntityPlayerMP player, ItemStack tool, BlockPos pos) {
        boolean successful;
        if (ToolHelper.isTool(tool, "shears") && ToolHelper.shearBlockRoutine(player, tool, pos) == 0) {
            return false;
        }
        World world = player.field_70170_p;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            world.func_184138_a(pos, state, state, 3);
            return false;
        }
        world.func_180498_a((EntityPlayer)player, 2001, pos, Block.func_176210_f((IBlockState)state));
        if (player.func_184812_l_()) {
            successful = ToolHelper.removeBlockRoutine(state, world, player, pos, false);
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack copiedTool = tool.func_190926_b() ? ItemStack.field_190927_a : tool.func_77946_l();
            boolean canHarvest = block.canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            if (!tool.func_190926_b()) {
                tool.func_179548_a(world, state, pos, (EntityPlayer)player);
                if (tool.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copiedTool, (EnumHand)EnumHand.MAIN_HAND);
                }
            }
            if ((successful = ToolHelper.removeBlockRoutine(null, world, player, pos, canHarvest)) && canHarvest) {
                block.func_180657_a(world, (EntityPlayer)player, pos, state, tile, copiedTool);
            }
        }
        if (!player.func_184812_l_() && successful && exp > 0) {
            block.func_180637_b(world, pos, exp);
        }
        return successful;
    }

    public static int shearBlockRoutine(EntityPlayerMP player, ItemStack tool, BlockPos pos) {
        if (!player.func_184812_l_()) {
            IShearable shearable;
            tool = ToolHelper.toolbeltPassthrough(tool);
            World world = player.field_70170_p;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof IShearable && (shearable = (IShearable)state.func_177230_c()).isShearable(tool, (IBlockAccess)world, pos)) {
                List shearedDrops = shearable.onSheared(tool, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool));
                boolean relocateMinedBlocks = ToolHelper.getBehaviorsTag(tool).func_74767_n(RELOCATE_MINED_BLOCKS_KEY);
                Iterator iter = shearedDrops.iterator();
                while (iter.hasNext()) {
                    ItemStack stack = (ItemStack)iter.next();
                    if (relocateMinedBlocks && player.func_191521_c(stack)) {
                        iter.remove();
                        continue;
                    }
                    float f = 0.7f;
                    double xo = (double)(world.field_73012_v.nextFloat() * f) + 0.15;
                    double yo = (double)(world.field_73012_v.nextFloat() * f) + 0.15;
                    double zo = (double)(world.field_73012_v.nextFloat() * f) + 0.15;
                    EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + xo, (double)pos.func_177956_o() + yo, (double)pos.func_177952_p() + zo, stack);
                    entityItem.func_174869_p();
                    player.field_70170_p.func_72838_d((Entity)entityItem);
                }
                ToolHelper.damageItem(tool, (EntityLivingBase)player);
                player.func_71029_a(StatList.func_188055_a((Block)((Block)shearable)));
                player.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                return tool.func_190926_b() ? 0 : 1;
            }
        }
        return -1;
    }

    public static boolean removeBlockRoutine(@Nullable IBlockState state, World world, EntityPlayerMP player, BlockPos pos, boolean canHarvest) {
        boolean successful = (state = state == null ? world.func_180495_p(pos) : state).func_177230_c().removedByPlayer(state, world, pos, (EntityPlayer)player, canHarvest);
        if (successful) {
            state.func_177230_c().func_176206_d(world, pos, state);
        }
        return successful;
    }

    @NotNull
    public static ItemStack getSilkTouchDrop(@NotNull IBlockState state) {
        try {
            return GET_SILK_TOUCH_DROP.invokeExact(state.func_177230_c(), state);
        }
        catch (Throwable ignored) {
            return ItemStack.field_190927_a;
        }
    }

    public static void playToolSound(ItemStack stack, EntityPlayer player) {
        if ((stack = ToolHelper.toolbeltPassthrough(stack)).func_77973_b() instanceof IGTTool) {
            ((IGTTool)stack.func_77973_b()).playSound(player);
        }
    }

    public static boolean hasMaterial(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TOOL_TAG_KEY)) {
            return false;
        }
        return tag.func_74775_l(TOOL_TAG_KEY).func_74764_b(MATERIAL_KEY);
    }

    static {
        try {
            Method method = ObfuscationReflectionHelper.findMethod(Block.class, (String)"func_180643_i", ItemStack.class, (Class[])new Class[]{IBlockState.class});
            method.setAccessible(true);
            GET_SILK_TOUCH_DROP = MethodHandles.lookup().unreflect(method);
            method.setAccessible(false);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

