/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.HandGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import gregtech.api.GregTechAPI;
import gregtech.api.items.IDyeableItem;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ItemGTTool;
import gregtech.api.items.toolitem.ToolDefinitionBuilder;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.items.behaviors.ColorSprayBehaviour;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMaintenanceHatch;
import gregtech.core.network.packets.PacketToolbeltSelectionChange;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ItemGTToolbelt
extends ItemGTTool
implements IDyeableItem {
    private static final ThreadLocal<Integer> lastSlot = ThreadLocal.withInitial(() -> -999);
    private static final ThreadLocal<EntityPlayerMP> lastPlayer = ThreadLocal.withInitial(() -> null);
    protected static final ToolStackHandler FALLBACK = new ToolStackHandler(0);

    public ItemGTToolbelt(String domain, String id, Supplier<ItemStack> markerItem, IToolBehavior ... behaviors) {
        super(domain, id, -1, new ToolDefinitionBuilder().behaviors(behaviors).cannotAttack().attackSpeed(-2.4f).build(), null, false, new HashSet<String>(), "toolbelt", new ArrayList<String>(), markerItem);
    }

    public int getSelectedSlot(@NotNull ItemStack toolbelt) {
        return this.getHandler(toolbelt).getSelectedSlot();
    }

    public int getSlotCount(@NotNull ItemStack toolbelt) {
        return this.getHandler(toolbelt).getSlots();
    }

    @NotNull
    public ItemStack getSelectedTool(@NotNull ItemStack toolbelt) {
        return this.getHandler(toolbelt).getSelectedStack();
    }

    @NotNull
    public ItemStack getToolInSlot(@NotNull ItemStack toolbelt, int slot) {
        ToolStackHandler handler = this.getHandler(toolbelt);
        if (slot < 0 || slot >= handler.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return handler.getStackInSlot(slot);
    }

    @Override
    public ModularPanel buildUI(HandGuiData guiData, PanelSyncManager guiSyncManager) {
        Item item;
        ItemStack usedStack = guiData.getUsedItemStack();
        ToolStackHandler handler = this.getHandler(usedStack);
        ItemStack selected = handler.getSelectedStack();
        if (!selected.func_190926_b() && (item = selected.func_77973_b()) instanceof ItemUIFactory) {
            ItemUIFactory factory = (ItemUIFactory)item;
            return factory.buildUI(guiData, guiSyncManager);
        }
        int heightBonus = handler.getSlots() / 9 * 18;
        SlotGroup group = new SlotGroup("toolbelt_inventory", Math.min(handler.getSlots(), 9));
        guiSyncManager.registerSlotGroup(group);
        ArrayList<ItemSlot> slots = new ArrayList<ItemSlot>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            slots.add(new ItemSlot());
        }
        return ((ModularPanel)((ModularPanel)GTGuis.createPanel(usedStack.func_77977_a(), 176, 120 + heightBonus + 12).child((IWidget)((TextWidget)IKey.str((String)usedStack.func_82833_r()).asWidget().pos(5, 5)).height(12))).child((IWidget)((Grid)((Grid)((Grid)((Grid)new Grid().margin(0)).leftRel(0.5f)).top(19)).coverChildren()).mapTo(group.getRowSize(), slots, (index, value) -> (ItemSlot)((ItemSlot)value.slot(SyncHandlers.itemSlot((IItemHandlerModifiable)handler, (int)index).slotGroup(group).changeListener((newItem, onlyAmountChanged, client, init) -> handler.onContentsChanged(index))).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.TOOL_SLOT_OVERLAY})).debugName("slot_" + index)).debugName("toolbelt_inventory"))).bindPlayerInventory();
    }

    @Override
    @NotNull
    public List<IToolBehavior> getBehaviors(ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (selected.func_190926_b()) {
            return super.getBehaviors(stack);
        }
        Item item = selected.func_77973_b();
        if (item instanceof IGTTool) {
            IGTTool tool = (IGTTool)item;
            return tool.getBehaviors(selected);
        }
        return Collections.emptyList();
    }

    @Override
    public float func_150893_a(@NotNull ItemStack stack, @NotNull IBlockState state) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().func_150893_a(selected, state);
        }
        return this.definition$getDestroySpeed(stack, state);
    }

    @Override
    public boolean func_77644_a(@NotNull ItemStack stack, @NotNull EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().func_77644_a(selected, target, attacker);
        }
        return this.definition$hitEntity(stack, target, attacker);
    }

    @Override
    public boolean onBlockStartBreak(@NotNull ItemStack itemstack, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        ItemStack selected = this.getHandler(itemstack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().onBlockStartBreak(selected, pos, player);
        }
        return this.definition$onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public boolean func_179218_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EntityLivingBase entityLiving) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().func_179218_a(selected, worldIn, state, pos, entityLiving);
        }
        return this.definition$onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    @Override
    public boolean func_82789_a(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        ItemStack selected = this.getHandler(toRepair).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().func_82789_a(selected, repair);
        }
        return this.definition$getIsRepairable(toRepair, repair);
    }

    @Override
    @NotNull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@NotNull EntityEquipmentSlot slot, @NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().getAttributeModifiers(slot, selected);
        }
        return this.definition$getAttributeModifiers(slot, stack);
    }

    @Override
    public int getHarvestLevel(@NotNull ItemStack stack, @NotNull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().getHarvestLevel(stack, toolClass, player, blockState);
        }
        return this.definition$getHarvestLevel(stack, toolClass, player, blockState);
    }

    @Override
    @NotNull
    public Set<String> getToolClasses(@NotNull ItemStack stack) {
        return this.getHandler(stack).getToolClasses(true);
    }

    @Override
    public boolean canDisableShield(@NotNull ItemStack stack, @NotNull ItemStack shield, @NotNull EntityLivingBase entity, @NotNull EntityLivingBase attacker) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().canDisableShield(selected, shield, entity, attacker);
        }
        return this.definition$canDisableShield(stack, shield, entity, attacker);
    }

    @Override
    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().doesSneakBypassUse(selected, world, pos, player);
        }
        return this.definition$doesSneakBypassUse(stack, world, pos, player);
    }

    @Override
    public boolean onEntitySwing(@NotNull EntityLivingBase entityLiving, @NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().onEntitySwing(entityLiving, selected);
        }
        return this.definition$onEntitySwing(entityLiving, stack);
    }

    @Override
    public boolean canDestroyBlockInCreative(@NotNull World world, @NotNull BlockPos pos, @NotNull ItemStack stack, @NotNull EntityPlayer player) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().canDestroyBlockInCreative(world, pos, selected, player);
        }
        return this.definition$canDestroyBlockInCreative(world, pos, stack, player);
    }

    @Override
    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public boolean isDamaged(@NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().isDamaged(selected);
        }
        return this.definition$isDamaged(stack);
    }

    @Override
    public int getDamage(@NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().getDamage(selected);
        }
        return this.definition$getDamage(stack);
    }

    @Override
    public int getMaxDamage(@NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().getMaxDamage(selected);
        }
        return this.definition$getMaxDamage(stack);
    }

    @Override
    public void setDamage(@NotNull ItemStack stack, int damage) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            selected.func_77973_b().setDamage(selected, damage);
        } else {
            this.definition$setDamage(stack, damage);
        }
    }

    @Override
    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            double dis = selected.func_77973_b().getDurabilityForDisplay(selected);
            if (selected.func_77973_b() instanceof ItemTool) {
                dis = 1.0 - dis;
            }
            return dis;
        }
        return this.definition$getDurabilityForDisplay(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        ToolStackHandler handler = this.getHandler(stack);
        ItemStack selected = handler.getSelectedStack();
        if (!selected.func_190926_b()) {
            selected.func_77973_b().func_77624_a(selected, world, tooltip, flag);
        } else {
            if (stack.func_77952_i() > 0) {
                int damageRemaining = this.getTotalMaxDurability(stack) - stack.func_77952_i() + 1;
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.tooltip.general_uses", (Object[])new Object[]{TextFormattingUtil.formatNumbers(damageRemaining)}));
            }
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.toolbelt.size", (Object[])new Object[]{TextFormattingUtil.formatNumbers(handler.getSlots())}));
            tooltip.add("");
            if (TooltipHelper.isShiftDown()) {
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.toolbelt.tooltip", (Object[])new Object[0]));
                tooltip.add("");
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.toolbelt.paint", (Object[])new Object[0]));
                tooltip.add("");
                tooltip.add(I18n.func_135052_a((String)"item.gt.tool.toolbelt.maintenance", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.hold_shift", (Object[])new Object[0]));
            }
        }
        if (TooltipHelper.isCtrlDown()) {
            tooltip.add("");
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack tool = handler.getStackInSlot(i);
                String name = tool.func_190926_b() ? "x" : tool.func_82833_r();
                tooltip.add(I18n.func_135052_a((String)(handler.selectedSlot == i ? "item.gt.tool.toolbelt.selected" : "item.gt.tool.toolbelt.tool"), (Object[])new Object[]{i + 1, name}));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.hold_ctrl", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean canHarvestBlock(@NotNull IBlockState state, @NotNull ItemStack stack) {
        ItemStack selected = this.getHandler(stack).getSelectedStack();
        if (!selected.func_190926_b()) {
            return selected.func_77973_b().canHarvestBlock(state, selected);
        }
        return ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack));
    }

    @Override
    public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        Item item;
        ItemStack selected = this.getHandler(wrench).getSelectedStack();
        if (!selected.func_190926_b() && (item = selected.func_77973_b()) instanceof IGTTool) {
            IGTTool tool = (IGTTool)item;
            tool.wrenchUsed(player, hand, selected, rayTrace);
        } else {
            super.wrenchUsed(player, hand, wrench, rayTrace);
        }
    }

    @Override
    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
        Item item2;
        ItemStack selected = this.getHandler(item).getSelectedStack();
        if (!selected.func_190926_b() && (item2 = selected.func_77973_b()) instanceof IGTTool) {
            IGTTool tool = (IGTTool)item2;
            tool.toolUsed(selected, user, pos);
        } else {
            super.toolUsed(item, user, pos);
        }
    }

    @Override
    public void used(@NotNull EnumHand hand, @NotNull EntityPlayer player, @NotNull BlockPos pos) {
        Item item;
        ItemStack selected = this.getHandler(player.func_184586_b(hand)).getSelectedStack();
        if (!selected.func_190926_b() && (item = selected.func_77973_b()) instanceof IGTTool) {
            IGTTool tool = (IGTTool)item;
            tool.used(hand, player, pos);
        } else {
            super.used(hand, player, pos);
        }
    }

    @Override
    public boolean hasContainerItem(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack stack) {
        if (this.getHandler(stack).dealCraftDamageToSelected()) {
            return stack.func_77946_l();
        }
        return super.getContainerItem(stack);
    }

    public void setOnCraftIngredient(ItemStack stack, Ingredient ingredient) {
        int match = this.getHandler(stack).checkIngredientAgainstTools(ingredient);
        if (match != -1) {
            this.setSelectedTool(match, stack);
            PacketToolbeltSelectionChange.toClient(match, lastSlot.get(), lastPlayer.get());
        }
    }

    public boolean damageAgainstMaintenanceProblem(ItemStack stack, String toolClass, @Nullable EntityPlayer entityPlayer) {
        return this.getHandler(stack).checkMaintenanceAgainstTools(toolClass, true, entityPlayer);
    }

    public boolean supportsIngredient(ItemStack stack, Ingredient ingredient) {
        return this.getHandler(stack).checkIngredientAgainstTools(ingredient) != -1;
    }

    public boolean supportsTool(ItemStack stack, ItemStack tool) {
        return this.getHandler(stack).checkToolAgainstTools(tool) != -1;
    }

    private ToolStackHandler getHandler(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler instanceof ToolStackHandler) {
            ToolStackHandler h = (ToolStackHandler)handler;
            return h;
        }
        return FALLBACK;
    }

    @Override
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, NBTTagCompound nbt) {
        return new ToolbeltCapabilityProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void changeSelectedToolMousewheel(int direction, ItemStack stack) {
        ToolStackHandler handler = this.getHandler(stack);
        if (direction < 0) {
            handler.incrementSelectedSlot();
        } else {
            handler.decrementSelectedSlot();
        }
        PacketToolbeltSelectionChange.toServer(handler.selectedSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public void changeSelectedToolHotkey(int slot, ItemStack stack) {
        ToolStackHandler handler = this.getHandler(stack);
        if (slot < 0 || slot >= handler.getSlots()) {
            handler.selectedSlot = -1;
        } else {
            handler.selectedSlot = slot;
        }
        PacketToolbeltSelectionChange.toServer(handler.selectedSlot);
    }

    @ApiStatus.Internal
    public void setSelectedTool(int slot, ItemStack stack) {
        ToolStackHandler handler = this.getHandler(stack);
        if (slot < 0 || slot >= handler.getSlots()) {
            handler.selectedSlot = -1;
        } else {
            handler.selectedSlot = slot;
        }
    }

    @Override
    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        ItemStack tool = this.getHandler(stack).getSelectedStack();
        this.getHandler(stack).disablePassthrough();
        String name = !tool.func_190926_b() ? LocalizationUtils.format(this.func_77658_a() + ".select", this.getToolMaterial(stack).getLocalizedName(), tool.func_82833_r()) : LocalizationUtils.format(this.func_77658_a(), this.getToolMaterial(stack).getLocalizedName());
        this.getHandler(stack).enablePassthrough();
        return name;
    }

    @Override
    @NotNull
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        EnumActionResult result = IDyeableItem.super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        if (result == EnumActionResult.PASS) {
            MetaTileEntityHolder holder;
            Object object;
            ItemStack stack = player.func_184586_b(hand);
            ToolStackHandler handler = this.getHandler(stack);
            if (handler.getSelectedStack().func_190926_b() && (object = world.func_175625_s(pos)) instanceof MetaTileEntityHolder && (object = (holder = (MetaTileEntityHolder)object).getMetaTileEntity()) instanceof MetaTileEntityMaintenanceHatch) {
                MetaTileEntityMaintenanceHatch maintenance = (MetaTileEntityMaintenanceHatch)object;
                maintenance.fixMaintenanceProblemsWithToolbelt(player, this, stack);
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        }
        return result;
    }

    @Override
    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult result;
        ColorSprayBehaviour spray;
        ToolStackHandler handler = this.getHandler(player.func_184586_b(hand));
        ItemStack selected = handler.getSelectedStack();
        if (!selected.func_190926_b() && (spray = ColorSprayBehaviour.getBehavior(selected)) != null && (result = spray.useFromToolbelt(player, world, pos, hand, facing, hitX, hitY, hitZ, selected)) != EnumActionResult.PASS) {
            return result;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return this.getColor(stack);
        }
        this.getHandler(stack).disablePassthrough();
        int color = super.getColor(stack, tintIndex);
        this.getHandler(stack).enablePassthrough();
        return color;
    }

    @Override
    public int getDefaultColor(ItemStack stack) {
        return 10511680;
    }

    @Override
    public boolean shouldGetContainerItem() {
        return false;
    }

    public static boolean checkIngredientAgainstToolbelt(@NotNull ItemStack input, @NotNull OreIngredient ingredient) {
        ItemGTToolbelt toolbelt;
        Item item = input.func_77973_b();
        if (item instanceof ItemGTToolbelt && (toolbelt = (ItemGTToolbelt)item).supportsIngredient(input, (Ingredient)ingredient)) {
            toolbelt.setOnCraftIngredient(input, (Ingredient)ingredient);
            return true;
        }
        return false;
    }

    public static void setCraftingSlot(int slot, EntityPlayerMP player) {
        lastSlot.set(slot);
        lastPlayer.set(player);
    }

    public static boolean checkToolAgainstToolbelt(@NotNull ItemStack toolbelt, @NotNull ItemStack tool) {
        Item item = toolbelt.func_77973_b();
        if (item instanceof ItemGTToolbelt) {
            ItemGTToolbelt belt = (ItemGTToolbelt)item;
            if (ToolHelper.isUtilityItem(tool)) {
                return belt.supportsTool(toolbelt, tool);
            }
        }
        return false;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77978_p() != null) {
            tag.func_74782_a("NBT", (NBTBase)stack.func_77978_p());
        }
        tag.func_74782_a("Cap", (NBTBase)this.getHandler(stack).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, NBTTagCompound nbt) {
        stack.func_77982_d(nbt == null ? null : (nbt.func_74764_b("NBT") ? nbt.func_74775_l("NBT") : null));
    }

    protected static class ToolStackHandler
    extends ItemStackHandler {
        private static final Set<String> EMPTY = ImmutableSet.of();
        private @Range(from=-1L, to=128L) int selectedSlot = -1;
        protected ItemTool[] tools;
        protected IGTTool[] gtTools;
        protected final Set<String> toolClasses = new ObjectOpenHashSet();
        private boolean passthrough = true;

        public ToolStackHandler(int size) {
            this.setSize(size);
        }

        public void incrementSelectedSlot() {
            if (++this.selectedSlot >= this.getSlots()) {
                this.selectedSlot = -1;
            }
        }

        public void decrementSelectedSlot() {
            if (--this.selectedSlot < -1) {
                this.selectedSlot = this.getSlots() - 1;
            }
        }

        public int getSelectedSlot() {
            if (this.passthrough) {
                return this.selectedSlot;
            }
            return -1;
        }

        public void setSelectedSlot(int selectedSlot) {
            this.selectedSlot = Math.min(this.getSlots() - 1, Math.max(selectedSlot, -1));
        }

        public void enablePassthrough() {
            this.passthrough = true;
        }

        public void disablePassthrough() {
            this.passthrough = false;
        }

        @NotNull
        public ItemStack getSelectedStack() {
            if (this.getSelectedSlot() == -1) {
                return ItemStack.field_190927_a;
            }
            return this.getStackInSlot(this.getSelectedSlot());
        }

        public Set<String> getToolClasses(boolean defaultEmpty) {
            ItemStack selectedStack = this.getSelectedStack();
            if (!selectedStack.func_190926_b()) {
                Item item = selectedStack.func_77973_b();
                if (item instanceof ItemTool) {
                    ItemTool tool = (ItemTool)item;
                    return tool.getToolClasses(selectedStack);
                }
                item = selectedStack.func_77973_b();
                if (item instanceof IGTTool) {
                    IGTTool tool = (IGTTool)item;
                    return tool.getToolClasses(selectedStack);
                }
            }
            if (defaultEmpty) {
                return EMPTY;
            }
            return this.toolClasses;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item instanceof ItemGTToolbelt) {
                return false;
            }
            return ToolHelper.isUtilityItem(stack);
        }

        protected void onContentsChanged(int slot) {
            this.updateSlot(slot);
            this.update();
            super.onContentsChanged(slot);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            if (this.selectedSlot != -1) {
                tag.func_74774_a("SelectedSlot", (byte)this.selectedSlot);
            }
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            if (nbt.func_74764_b("SelectedSlot")) {
                this.selectedSlot = nbt.func_74771_c("SelectedSlot");
            }
        }

        public void setSize(int size) {
            super.setSize(size);
            this.gtTools = new IGTTool[size];
            this.tools = new ItemTool[size];
        }

        protected void onLoad() {
            for (int i = 0; i < this.getSlots(); ++i) {
                this.updateSlot(i);
            }
            this.update();
        }

        protected void updateSlot(int slot) {
            Object tool;
            Item item = this.getStackInSlot(slot).func_77973_b();
            this.tools[slot] = item instanceof ItemTool ? (tool = (ItemTool)item) : null;
            if (item instanceof IGTTool) {
                tool = (IGTTool)item;
                this.gtTools[slot] = tool;
            } else {
                this.gtTools[slot] = null;
            }
        }

        protected void update() {
            this.toolClasses.clear();
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.tools[i] == null) continue;
                this.toolClasses.addAll(this.tools[i].getToolClasses((ItemStack)this.stacks.get(i)));
            }
        }

        public boolean checkMaintenanceAgainstTools(String toolClass, boolean doCraftingDamage, @Nullable EntityPlayer entityPlayer) {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (!ToolHelper.isTool(stack, toolClass)) continue;
                if (doCraftingDamage) {
                    ToolHelper.damageItemWhenCrafting(stack, (EntityLivingBase)entityPlayer);
                }
                return true;
            }
            return false;
        }

        public int checkIngredientAgainstTools(Ingredient ingredient) {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (!ingredient.test((Object)stack)) continue;
                return i;
            }
            return -1;
        }

        public void dealCraftDamageToSlot(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            this.setStackInSlot(slot, stack.func_77973_b().getContainerItem(stack));
        }

        public boolean dealCraftDamageToSelected() {
            if (this.selectedSlot != -1) {
                this.dealCraftDamageToSlot(this.selectedSlot);
                return true;
            }
            return false;
        }

        public int checkToolAgainstTools(ItemStack tool) {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)tool, (boolean)false)) continue;
                return i;
            }
            return -1;
        }
    }

    protected static class ToolbeltCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        protected final IntSupplier slotCountSupplier = () -> {
            if (!ToolHelper.hasMaterial(stack)) {
                return 4;
            }
            NBTTagCompound toolTag = stack.func_190925_c("GT.Tool");
            Material material = GregTechAPI.materialManager.getMaterial(toolTag.func_74779_i("Material"));
            if (material == null) {
                return 4;
            }
            ToolProperty toolProperty = material.getProperty(PropertyKey.TOOL);
            return Math.min(8, 2 + toolProperty.getToolHarvestLevel());
        };
        @Nullable
        private ToolStackHandler handler;

        public ToolbeltCapabilityProvider(ItemStack stack) {
        }

        public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getHandler());
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.getHandler().serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.getHandler().deserializeNBT(nbt.func_74737_b());
        }

        @NotNull
        protected ToolStackHandler getHandler() {
            int size = this.slotCountSupplier.getAsInt();
            if (this.handler == null) {
                this.handler = new ToolStackHandler(size);
            } else if (this.handler.getSlots() != size) {
                this.handler.setSize(size);
            }
            return this.handler;
        }
    }
}

