/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem.stats;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemContainerItemProvider;
import gregtech.api.util.GTUtility;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFluidContainer
implements IItemContainerItemProvider,
IItemBehaviour {
    private final boolean isBucket;

    public ItemFluidContainer(boolean isBucket) {
        this.isBucket = isBucket;
    }

    public ItemFluidContainer() {
        this(false);
    }

    @Override
    public ItemStack getContainerItem(ItemStack itemStack) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (handler != null) {
            FluidStack drained = handler.drain(1000, false);
            if (drained == null || drained.amount != 1000) {
                return ItemStack.field_190927_a;
            }
            handler.drain(1000, true);
            return handler.getContainer().func_77946_l();
        }
        return itemStack;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        if (this.isBucket) {
            lines.add(I18n.func_135052_a((String)"behaviour.cell_bucket.tooltip", (Object[])new Object[0]));
        }
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isBucket) {
            return this.pass(stack);
        }
        ItemStack cellStack = GTUtility.copy(1, stack);
        IFluidHandlerItem cellHandler = FluidUtil.getFluidHandler((ItemStack)cellStack);
        if (cellHandler == null) {
            return this.pass(stack);
        }
        RayTraceResult result = ItemFluidContainer.rayTrace(world, player, true);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return this.pass(stack);
        }
        BlockPos pos = result.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return this.fail(stack);
        }
        if (!player.func_175151_a(pos, result.field_178784_b, cellStack)) {
            return this.fail(stack);
        }
        if (ItemFluidContainer.fillCell(cellStack, world, pos, result.field_178784_b, player)) {
            ItemFluidContainer.addToPlayerInventory(stack, cellHandler.getContainer(), player, hand);
            return this.success(stack);
        }
        result = ItemFluidContainer.rayTrace(world, player, false);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return this.pass(stack);
        }
        pos = result.func_178782_a();
        if (ItemFluidContainer.tryPlace(cellHandler, world, pos.func_177972_a(result.field_178784_b), result.field_178784_b, player)) {
            ItemFluidContainer.addToPlayerInventory(stack, cellHandler.getContainer(), player, hand);
            return this.success(stack);
        }
        return this.pass(stack);
    }

    private static boolean tryPlace(IFluidHandlerItem cellHandler, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        FluidStack cellFluid = cellHandler.drain(1000, false);
        if (cellFluid == null || !cellFluid.getFluid().canBePlacedInWorld()) {
            return false;
        }
        IFluidHandler blockHandler = ItemFluidContainer.getOrCreate(cellFluid, world, pos, side);
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || isDestNonSolid || isDestReplaceable)) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && cellFluid.getFluid().doesVaporize(cellFluid)) {
            cellHandler.drain(1000, true);
            cellFluid.getFluid().vaporize(player, world, pos, cellFluid);
            return true;
        }
        int filled = blockHandler.fill(cellFluid, false);
        if (filled != 1000) {
            return false;
        }
        ItemFluidContainer.playSound(cellFluid, true, player);
        boolean consume = !player.func_175149_v() && !player.func_184812_l_();
        blockHandler.fill(cellHandler.drain(1000, consume), true);
        return true;
    }

    private static boolean fillCell(ItemStack cellStack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        IFluidHandler blockHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side);
        if (blockHandler == null) {
            return false;
        }
        IFluidHandlerItem cellHandler = FluidUtil.getFluidHandler((ItemStack)cellStack);
        if (cellHandler == null) {
            return false;
        }
        FluidStack stack = blockHandler.drain(1000, false);
        int filled = cellHandler.fill(stack, false);
        if (filled != 1000) {
            return false;
        }
        ItemFluidContainer.playSound(stack, false, player);
        boolean consume = !player.func_175149_v() && !player.func_184812_l_();
        cellHandler.fill(blockHandler.drain(1000, true), consume);
        return true;
    }

    @Nullable
    private static RayTraceResult rayTrace(World worldIn, EntityPlayer player, boolean hitFluids) {
        Vec3d lookPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d lookOffset = player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
        return worldIn.func_147447_a(lookPos, lookPos.func_178787_e(lookOffset), hitFluids, !hitFluids, false);
    }

    @NotNull
    private static IFluidHandler createHandler(FluidStack stack, World world, BlockPos pos) {
        Block block = stack.getFluid().getBlock();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, pos);
        }
        return new BlockWrapper(block, world, pos);
    }

    private static IFluidHandler getOrCreate(FluidStack stack, World world, BlockPos pos, EnumFacing side) {
        IFluidHandler handler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side);
        if (handler != null) {
            return handler;
        }
        return ItemFluidContainer.createHandler(stack, world, pos);
    }

    private static void addToPlayerInventory(ItemStack playerStack, ItemStack resultStack, EntityPlayer player, EnumHand hand) {
        if (playerStack.func_190916_E() > resultStack.func_190916_E()) {
            EntityItem dropItem;
            playerStack.func_190918_g(resultStack.func_190916_E());
            if (!player.field_71071_by.func_70441_a(resultStack) && !player.field_70170_p.field_72995_K && (dropItem = player.func_70099_a(resultStack, 0.0f)) != null) {
                dropItem.func_174867_a(0);
            }
        } else {
            player.func_184611_a(hand, resultStack);
        }
    }

    private static void playSound(FluidStack fluid, boolean fill, EntityPlayer player) {
        if (fluid == null || player.field_70170_p.field_72995_K) {
            return;
        }
        SoundEvent soundEvent = fill ? fluid.getFluid().getFillSound(fluid) : fluid.getFluid().getEmptySound(fluid);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundEvent, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }
}

