/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.behavior;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverHolder;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.core.advancement.AdvancementTriggers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class CoverItemBehavior
implements IItemBehaviour {
    private final CoverDefinition definition;

    public CoverItemBehavior(@NotNull CoverDefinition definition) {
        this.definition = definition;
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, @NotNull World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return EnumActionResult.PASS;
        }
        CoverHolder coverHolder = (CoverHolder)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_COVER_HOLDER, null);
        if (coverHolder == null) {
            return EnumActionResult.PASS;
        }
        EnumFacing coverSide = CoverRayTracer.rayTraceCoverableSide(coverHolder, player);
        if (coverSide == null) {
            return EnumActionResult.PASS;
        }
        if (coverHolder.hasCover(coverSide)) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Cover cover = this.definition.createCover(coverHolder, coverSide);
        if (!coverHolder.canPlaceCoverOnSide(coverSide)) {
            return EnumActionResult.PASS;
        }
        if (!cover.canAttach(coverHolder, coverSide)) {
            return EnumActionResult.PASS;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        cover.onAttachment(coverHolder, coverSide, player, itemStack);
        coverHolder.addCover(coverSide, cover);
        AdvancementTriggers.FIRST_COVER_PLACE.trigger((EntityPlayerMP)player);
        if (!player.func_184812_l_()) {
            if (itemStack.func_190926_b()) {
                return EnumActionResult.FAIL;
            }
            itemStack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    @NotNull
    public CoverDefinition getDefinition() {
        return this.definition;
    }
}

