/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import gregtech.api.items.armor.DummyArmorLogic;
import gregtech.api.items.armor.IArmorItem;
import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.armor.ISpecialArmorLogic;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IEnchantabilityHelper;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.common.creativetab.GTCreativeTabs;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorMetaItem<T extends ArmorMetaValueItem>
extends MetaItem<T>
implements IArmorItem,
ISpecialArmor,
IEnchantabilityHelper {
    public ArmorMetaItem() {
        super((short)0);
        this.setCreativeTab(GTCreativeTabs.TAB_GREGTECH_TOOLS);
    }

    @Override
    protected T constructMetaValueItem(short metaValue, String unlocalizedName) {
        return (T)new ArmorMetaValueItem((int)metaValue, unlocalizedName);
    }

    @NotNull
    private IArmorLogic getArmorLogic(ItemStack itemStack) {
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(itemStack);
        return metaValueItem == null ? new DummyArmorLogic() : metaValueItem.getArmorLogic();
    }

    @Override
    @NotNull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@NotNull EntityEquipmentSlot slot, @NotNull ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, stack);
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        multimap.putAll(armorLogic.getAttributeModifiers(slot, stack));
        return multimap;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(armor);
        if (armorLogic instanceof ISpecialArmorLogic) {
            return ((ISpecialArmorLogic)armorLogic).getProperties(player, armor, source, damage, ArmorMetaItem.getSlotByIndex(slot));
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, @NotNull ItemStack armor, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(armor);
        if (armorLogic instanceof ISpecialArmorLogic) {
            return ((ISpecialArmorLogic)armorLogic).getArmorDisplay(player, armor, slot);
        }
        return 0;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, @NotNull ItemStack stack, DamageSource source, int damage, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        armorLogic.damageArmor(entity, stack, source, damage, ArmorMetaItem.getSlotByIndex(slot));
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(armor);
        if (armorLogic instanceof ISpecialArmorLogic) {
            return ((ISpecialArmorLogic)armorLogic).handleUnblockableDamage(entity, armor, source, damage, ArmorMetaItem.getSlotByIndex(slot));
        }
        return false;
    }

    public void onArmorTick(@NotNull World world, @NotNull EntityPlayer player, @NotNull ItemStack itemStack) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        armorLogic.onArmorTick(world, player, itemStack);
    }

    public boolean isValidArmor(@NotNull ItemStack stack, @NotNull EntityEquipmentSlot armorType, @NotNull Entity entity) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        return super.isValidArmor(stack, armorType, entity) && armorLogic.isValidArmor(stack, entity, armorType);
    }

    @Nullable
    public EntityEquipmentSlot getEquipmentSlot(@NotNull ItemStack stack) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        return armorLogic.getEquipmentSlot(stack);
    }

    @Nullable
    public String getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EntityEquipmentSlot slot, @NotNull String type) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        return armorLogic.getArmorTexture(stack, entity, slot, type);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(@NotNull EntityLivingBase entityLiving, @NotNull ItemStack itemStack, @NotNull EntityEquipmentSlot armorSlot, @NotNull ModelBiped _default) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        return armorLogic.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    @Override
    public int getArmorLayersAmount(ItemStack itemStack) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        return armorLogic.getArmorLayersAmount(itemStack);
    }

    @Override
    public int getArmorLayerColor(ItemStack itemStack, int layerIndex) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        return armorLogic.getArmorLayerColor(itemStack, layerIndex);
    }

    public void renderHelmetOverlay(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull ScaledResolution resolution, float partialTicks) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        armorLogic.renderHelmetOverlay(stack, player, resolution, partialTicks);
    }

    private static EntityEquipmentSlot getSlotByIndex(int index) {
        switch (index) {
            case 0: {
                return EntityEquipmentSlot.FEET;
            }
            case 1: {
                return EntityEquipmentSlot.LEGS;
            }
            case 2: {
                return EntityEquipmentSlot.CHEST;
            }
        }
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public boolean func_77616_k(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public int getItemEnchantability(@NotNull ItemStack stack) {
        return 50;
    }

    @Override
    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        EntityEquipmentSlot slot = this.getEquipmentSlot(stack);
        if (slot == null || enchantment.field_77351_y == null) {
            return false;
        }
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        if (!armorLogic.canBreakWithDamage(stack) && enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE) {
            return false;
        }
        switch (slot) {
            case HEAD: {
                return enchantment.field_77351_y.func_77557_a((Item)Items.field_151161_ac);
            }
            case CHEST: {
                return enchantment.field_77351_y.func_77557_a((Item)Items.field_151163_ad);
            }
            case LEGS: {
                return enchantment.field_77351_y.func_77557_a((Item)Items.field_151173_ae);
            }
            case FEET: {
                return enchantment.field_77351_y.func_77557_a((Item)Items.field_151175_af);
            }
        }
        return enchantment.isAllowedOnBooks();
    }

    public class ArmorMetaValueItem
    extends MetaItem.MetaValueItem {
        private IArmorLogic armorLogic;

        protected ArmorMetaValueItem(int metaValue, String unlocalizedName) {
            super(ArmorMetaItem.this, metaValue, unlocalizedName);
            this.armorLogic = new DummyArmorLogic();
            this.setMaxStackSize(1);
        }

        @NotNull
        public IArmorLogic getArmorLogic() {
            return this.armorLogic;
        }

        public ArmorMetaValueItem setArmorLogic(IArmorLogic armorLogic) {
            Preconditions.checkNotNull((Object)armorLogic, (Object)"Cannot set ArmorLogic to null");
            this.armorLogic = armorLogic;
            this.armorLogic.addToolComponents(this);
            return this;
        }

        @Override
        public ArmorMetaValueItem addComponents(IItemComponent ... stats) {
            super.addComponents(stats);
            return this;
        }

        @Override
        public ArmorMetaValueItem setModelAmount(int modelAmount) {
            return (ArmorMetaValueItem)super.setModelAmount(modelAmount);
        }

        @Override
        public ArmorMetaValueItem setRarity(EnumRarity rarity) {
            return (ArmorMetaValueItem)super.setRarity(rarity);
        }
    }
}

