/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public interface IDyeableItem {
    public static final String COLOR_KEY = "gt_color";

    default public boolean hasColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b(COLOR_KEY, 3);
    }

    default public int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b(COLOR_KEY, 3)) {
            return nbttagcompound.func_74762_e(COLOR_KEY);
        }
        return this.getDefaultColor(stack);
    }

    default public int getDefaultColor(ItemStack stack) {
        return 0xFFFFFF;
    }

    default public void removeColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_74764_b(COLOR_KEY)) {
            nbttagcompound.func_82580_o(COLOR_KEY);
        }
    }

    default public void setColor(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        nbttagcompound.func_74768_a(COLOR_KEY, color);
    }

    @NotNull
    default public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        IBlockState iblockstate;
        Block block;
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasColor(stack) && (block = (iblockstate = world.func_180495_p(pos)).func_177230_c()) instanceof BlockCauldron) {
            BlockCauldron cauldron = (BlockCauldron)block;
            int water = (Integer)iblockstate.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (water > 0) {
                this.removeColor(stack);
                cauldron.func_176590_a(world, pos, iblockstate, water - 1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    default public boolean shouldGetContainerItem() {
        return true;
    }
}

