/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.fluids.GTFluid;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.ingredient.IIngredientSlot;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.TooltipHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TankWidget
extends Widget
implements IIngredientSlot {
    public final IFluidTank fluidTank;
    public int fluidRenderOffset = 1;
    private boolean hideTooltip;
    private boolean alwaysShowFull;
    private boolean drawHoveringText;
    private boolean allowClickFilling;
    private boolean allowClickEmptying;
    private IGuiTexture[] backgroundTexture;
    private IGuiTexture overlayTexture;
    protected FluidStack lastFluidInTank;
    private int lastTankCapacity;
    protected boolean isClient;

    public TankWidget(IFluidTank fluidTank, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.fluidTank = fluidTank;
        this.drawHoveringText = true;
    }

    public TankWidget setClient() {
        this.isClient = true;
        this.lastFluidInTank = this.fluidTank != null ? (this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().copy() : null) : null;
        this.lastTankCapacity = this.fluidTank != null ? this.fluidTank.getCapacity() : 0;
        return this;
    }

    public TankWidget setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
        return this;
    }

    public TankWidget setDrawHoveringText(boolean drawHoveringText) {
        this.drawHoveringText = drawHoveringText;
        return this;
    }

    public TankWidget setAlwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public TankWidget setBackgroundTexture(IGuiTexture ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public TankWidget setOverlayTexture(IGuiTexture overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public TankWidget setFluidRenderOffset(int fluidRenderOffset) {
        this.fluidRenderOffset = fluidRenderOffset;
        return this;
    }

    public TankWidget setContainerClicking(boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        if (!(this.fluidTank instanceof IFluidHandler)) {
            throw new IllegalStateException("Container IO is only supported for fluid tanks that implement IFluidHandler");
        }
        this.allowClickFilling = allowClickContainerFilling;
        this.allowClickEmptying = allowClickContainerEmptying;
        return this;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidInTank;
        }
        return null;
    }

    public String getFormattedFluidAmount() {
        return String.format("%,d", this.lastFluidInTank == null ? 0 : this.lastFluidInTank.amount);
    }

    public String getFluidLocalizedName() {
        return this.lastFluidInTank == null ? "" : this.lastFluidInTank.getLocalizedName();
    }

    @Nullable
    public TextComponentTranslation getFluidTextComponent() {
        if (this.lastFluidInTank == null) {
            return null;
        }
        Fluid fluid = this.lastFluidInTank.getFluid();
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid materialFluid = (GTFluid.GTMaterialFluid)fluid;
            return materialFluid.toTextComponentTranslation();
        }
        return new TextComponentTranslation(this.lastFluidInTank.getUnlocalizedName(), new Object[0]);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.backgroundTexture != null) {
            for (IGuiTexture textureArea : this.backgroundTexture) {
                textureArea.draw(pos.x, pos.y, size.width, size.height);
            }
        }
        if (this.lastFluidInTank != null && !this.gui.isJEIHandled) {
            int drawAmount;
            GlStateManager.func_179084_k();
            FluidStack stackToDraw = this.lastFluidInTank;
            int n = drawAmount = this.alwaysShowFull ? this.lastFluidInTank.amount : this.lastTankCapacity;
            if (this.alwaysShowFull && this.lastFluidInTank.amount == 0) {
                stackToDraw = this.lastFluidInTank.copy();
                stackToDraw.amount = 1;
                drawAmount = 1;
            }
            RenderUtil.drawFluidForGui(stackToDraw, drawAmount, pos.x + this.fluidRenderOffset, pos.y + this.fluidRenderOffset, size.width - this.fluidRenderOffset, size.height - this.fluidRenderOffset);
            if (this.alwaysShowFull && !this.hideTooltip && this.drawHoveringText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                String s = TextFormattingUtil.formatLongToCompactString(this.lastFluidInTank.amount, 4) + "L";
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 21.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179147_l();
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.draw(pos.x, pos.y, size.width, size.height);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (!this.hideTooltip && !this.gui.isJEIHandled && this.isMouseOverElement(mouseX, mouseY)) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (this.lastFluidInTank != null) {
                Fluid fluid = this.lastFluidInTank.getFluid();
                tooltips.add(fluid.getLocalizedName(this.lastFluidInTank));
                tooltips.add(LocalizationUtils.format("gregtech.fluid.amount", this.lastFluidInTank.amount, this.lastTankCapacity));
                List<String> formula = FluidTooltipUtil.getFluidTooltip(this.lastFluidInTank);
                if (formula != null) {
                    for (String s : formula) {
                        if (s.isEmpty()) continue;
                        tooltips.add(s);
                    }
                }
                TankWidget.addIngotMolFluidTooltip(this.lastFluidInTank, tooltips);
            } else {
                tooltips.add(LocalizationUtils.format("gregtech.fluid.empty", new Object[0]));
                tooltips.add(LocalizationUtils.format("gregtech.fluid.amount", 0, this.lastTankCapacity));
            }
            if (this.allowClickEmptying && this.allowClickFilling) {
                tooltips.add("");
                tooltips.add(LocalizationUtils.format("gregtech.fluid.click_combined", new Object[0]));
            } else if (this.allowClickFilling) {
                tooltips.add("");
                tooltips.add(LocalizationUtils.format("gregtech.fluid.click_to_fill", new Object[0]));
            } else if (this.allowClickEmptying) {
                tooltips.add("");
                tooltips.add(LocalizationUtils.format("gregtech.fluid.click_to_empty", new Object[0]));
            }
            this.drawHoveringText(ItemStack.field_190927_a, tooltips, 300, mouseX, mouseY);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void updateScreen() {
        if (this.isClient) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
                this.lastTankCapacity = this.fluidTank.getCapacity();
            }
            if (fluidStack == null && this.lastFluidInTank != null) {
                this.lastFluidInTank = null;
            } else if (fluidStack != null) {
                if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                    this.lastFluidInTank = fluidStack.copy();
                } else if (fluidStack.amount != this.lastFluidInTank.amount) {
                    this.lastFluidInTank.amount = fluidStack.amount;
                }
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
            this.lastTankCapacity = this.fluidTank.getCapacity();
            this.writeUpdateInfo(0, buffer -> buffer.func_150787_b(this.lastTankCapacity));
        }
        if (fluidStack == null && this.lastFluidInTank != null) {
            this.lastFluidInTank = null;
            this.writeUpdateInfo(1, buffer -> {});
        } else if (fluidStack != null) {
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
                NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
                this.writeUpdateInfo(2, buffer -> buffer.func_150786_a(fluidStackTag));
            } else if (fluidStack.amount != this.lastFluidInTank.amount) {
                this.lastFluidInTank.amount = fluidStack.amount;
                this.writeUpdateInfo(3, buffer -> buffer.func_150787_b(this.lastFluidInTank.amount));
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.func_150792_a();
        } else if (id == 1) {
            this.lastFluidInTank = null;
        } else if (id == 2) {
            NBTTagCompound fluidStackTag;
            try {
                fluidStackTag = buffer.func_150793_b();
            }
            catch (IOException ignored) {
                return;
            }
            this.lastFluidInTank = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidStackTag);
        } else if (id == 3 && this.lastFluidInTank != null) {
            this.lastFluidInTank.amount = buffer.func_150792_a();
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        ItemStack clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(buffer.readBoolean())) != ItemStack.field_190927_a) {
            ((EntityPlayerMP)this.gui.entityPlayer).func_71113_k();
        }
    }

    private ItemStack tryClickContainer(boolean tryFillAll) {
        EntityPlayer player = this.gui.entityPlayer;
        ItemStack currentStack = player.field_71071_by.func_70445_o();
        if (currentStack == ItemStack.field_190927_a || currentStack.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack heldItemSizedOne = currentStack.func_77946_l();
        heldItemSizedOne.func_190920_e(1);
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)heldItemSizedOne.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandlerItem == null) {
            return ItemStack.field_190927_a;
        }
        FluidStack tankFluid = this.fluidTank.getFluid();
        FluidStack heldFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
        if (heldFluid != null && heldFluid.amount <= 0) {
            heldFluid = null;
        }
        if (tankFluid == null) {
            if (!this.allowClickEmptying) {
                return ItemStack.field_190927_a;
            }
            if (heldFluid == null) {
                return ItemStack.field_190927_a;
            }
            return this.fillTankFromStack(heldFluid, tryFillAll);
        }
        if (heldFluid != null && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            if (this.allowClickEmptying) {
                return this.fillTankFromStack(heldFluid, tryFillAll);
            }
            if (!this.allowClickFilling) {
                return ItemStack.field_190927_a;
            }
            return this.drainTankFromStack(tryFillAll);
        }
        if (!this.allowClickFilling) {
            return ItemStack.field_190927_a;
        }
        return this.drainTankFromStack(tryFillAll);
    }

    private ItemStack fillTankFromStack(@NotNull FluidStack heldFluid, boolean tryFillAll) {
        EntityPlayer player = this.gui.entityPlayer;
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == ItemStack.field_190927_a || heldItem.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.func_190920_e(1);
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid != null && !currentFluid.isFluidEqual(heldFluid)) {
            return ItemStack.field_190927_a;
        }
        int freeSpace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freeSpace <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStackEmptied = ItemStack.field_190927_a;
        int fluidAmountTaken = 0;
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)heldItemSizedOne.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler == null) {
            return ItemStack.field_190927_a;
        }
        FluidStack drained = fluidHandler.drain(freeSpace, true);
        if (drained != null && drained.amount > 0) {
            itemStackEmptied = fluidHandler.getContainer();
            fluidAmountTaken = drained.amount;
        }
        if (itemStackEmptied == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        int additional = tryFillAll ? Math.min(freeSpace / fluidAmountTaken, heldItem.func_190916_E()) : 1;
        FluidStack copiedFluidStack = heldFluid.copy();
        copiedFluidStack.amount = fluidAmountTaken * additional;
        this.fluidTank.fill(copiedFluidStack, true);
        itemStackEmptied.func_190920_e(additional);
        this.replaceCursorItemStack(itemStackEmptied);
        this.playSound(heldFluid, true);
        return itemStackEmptied;
    }

    private ItemStack drainTankFromStack(boolean tryFillAll) {
        EntityPlayer player = this.gui.entityPlayer;
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == ItemStack.field_190927_a || heldItem.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.func_190920_e(1);
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid == null) {
            return ItemStack.field_190927_a;
        }
        currentFluid = currentFluid.copy();
        int originalFluidAmount = this.fluidTank.getFluidAmount();
        IFluidHandlerItem handler = (IFluidHandlerItem)heldItemSizedOne.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack filledContainer = this.fillFluidContainer(currentFluid, heldItemSizedOne);
        if (filledContainer != ItemStack.field_190927_a) {
            int filledAmount = originalFluidAmount - currentFluid.amount;
            if (filledAmount <= 0) {
                return ItemStack.field_190927_a;
            }
            this.fluidTank.drain(filledAmount, true);
            if (tryFillAll) {
                int additional = Math.min(heldItem.func_190916_E() - 1, currentFluid.amount / filledAmount);
                this.fluidTank.drain(filledAmount * additional, true);
                filledContainer.func_190917_f(additional);
            }
            this.replaceCursorItemStack(filledContainer);
            this.playSound(currentFluid, false);
        }
        return filledContainer;
    }

    private ItemStack fillFluidContainer(FluidStack fluidStack, ItemStack itemStack) {
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandlerItem == null) {
            return ItemStack.field_190927_a;
        }
        int filledAmount = fluidHandlerItem.fill(fluidStack, true);
        if (filledAmount > 0) {
            fluidStack.amount -= filledAmount;
            return fluidHandlerItem.getContainer();
        }
        return ItemStack.field_190927_a;
    }

    private void replaceCursorItemStack(ItemStack resultStack) {
        EntityPlayer player = this.gui.entityPlayer;
        int resultStackSize = resultStack.func_77976_d();
        while (resultStack.func_190916_E() > resultStackSize) {
            player.field_71071_by.func_70445_o().func_190918_g(resultStackSize);
            TankWidget.addItemToPlayerInventory(player, resultStack.func_77979_a(resultStackSize));
        }
        if (player.field_71071_by.func_70445_o().func_190916_E() == resultStack.func_190916_E()) {
            player.field_71071_by.func_70437_b(resultStack);
        } else {
            ItemStack heldStack = player.field_71071_by.func_70445_o();
            heldStack.func_190918_g(resultStack.func_190916_E());
            player.field_71071_by.func_70437_b(heldStack);
            TankWidget.addItemToPlayerInventory(player, resultStack);
        }
    }

    private static void addItemToPlayerInventory(EntityPlayer player, ItemStack stack) {
        EntityItem dropItem;
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack) && !player.field_70170_p.field_72995_K && (dropItem = player.func_70099_a(stack, 0.0f)) != null) {
            dropItem.func_174867_a(0);
        }
    }

    private void playSound(FluidStack fluid, boolean fill) {
        if (fluid == null) {
            return;
        }
        SoundEvent soundEvent = fill ? fluid.getFluid().getFillSound(fluid) : fluid.getFluid().getEmptySound(fluid);
        EntityPlayer player = this.gui.entityPlayer;
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ItemStack currentStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            if ((this.allowClickEmptying || this.allowClickFilling) && currentStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                this.writeClientAction(1, writer -> writer.writeBoolean(button == 0));
                TankWidget.playButtonClickSound();
                return true;
            }
        }
        return false;
    }

    public static void addIngotMolFluidTooltip(FluidStack fluidStack, List<String> tooltip) {
        if (TooltipHelper.isShiftDown() && fluidStack.amount > 144) {
            int numIngots = fluidStack.amount / 144;
            int extra = fluidStack.amount % 144;
            String fluidAmount = String.format(" %,d L = %,d * %d L", fluidStack.amount, numIngots, 144);
            if (extra != 0) {
                fluidAmount = fluidAmount + String.format(" + %d L", extra);
            }
            tooltip.add(TextFormatting.GRAY + LocalizationUtils.format("gregtech.gui.amount_raw", new Object[0]) + fluidAmount);
        }
    }
}

