/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.function.impl.TimedProgressSupplier;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class ProgressWidget
extends Widget {
    public final DoubleSupplier progressSupplier;
    private MoveType moveType;
    private TextureArea emptyBarArea;
    private TextureArea[] filledBarArea;
    private double lastProgressValue;
    private List<ITextComponent> hoverText = new ArrayList<ITextComponent>();
    private Consumer<List<ITextComponent>> textSupplier;
    private boolean ignoreColor;

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
    }

    public ProgressWidget(int ticksPerCycle, int x, int y, int width, int height) {
        this(new TimedProgressSupplier(ticksPerCycle, width, false), x, y, width, height);
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea fullImage, MoveType moveType) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
        this.emptyBarArea = fullImage.getSubArea(0.0, 0.0, 1.0, 0.5);
        this.moveType = moveType;
        this.filledBarArea = moveType == MoveType.CIRCULAR ? new TextureArea[]{fullImage.getSubArea(0.0, 0.75, 0.5, 0.25), fullImage.getSubArea(0.0, 0.5, 0.5, 0.25), fullImage.getSubArea(0.5, 0.5, 0.5, 0.25), fullImage.getSubArea(0.5, 0.75, 0.5, 0.25)} : new TextureArea[]{fullImage.getSubArea(0.0, 0.5, 1.0, 0.5)};
    }

    public ProgressWidget(int ticksPerCycle, int x, int y, int width, int height, TextureArea fullImage, MoveType moveType) {
        this(new TimedProgressSupplier(ticksPerCycle, moveType == MoveType.HORIZONTAL ? width : height, false), x, y, width, height, fullImage, moveType);
    }

    public ProgressWidget setProgressBar(TextureArea emptyBarArea, TextureArea filledBarArea, MoveType moveType) {
        this.emptyBarArea = emptyBarArea;
        this.filledBarArea = new TextureArea[]{filledBarArea};
        this.moveType = moveType;
        return this;
    }

    public ProgressWidget setHoverTextConsumer(Consumer<List<ITextComponent>> supplier) {
        this.textSupplier = supplier;
        return this;
    }

    public ProgressWidget setIgnoreColor(boolean ignore) {
        this.ignoreColor = ignore;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.ignoreColor) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.emptyBarArea != null) {
            this.emptyBarArea.draw(pos.x, pos.y, size.width, size.height);
        }
        if (this.filledBarArea != null) {
            boolean smooth = ConfigHolder.client.guiConfig.smoothProgressBars;
            if (this.moveType == MoveType.HORIZONTAL) {
                double width = (double)size.width * this.lastProgressValue;
                if (!smooth) {
                    width = (int)width;
                }
                double drawnWidth = smooth ? this.lastProgressValue : width / ((double)size.width * 1.0);
                this.filledBarArea[0].drawSubArea(pos.x, pos.y, width, size.height, 0.0, 0.0, drawnWidth, 1.0);
            } else if (this.moveType == MoveType.HORIZONTAL_BACKWARDS) {
                double width = (double)size.width * this.lastProgressValue;
                if (!smooth) {
                    width = (int)width;
                }
                double drawnWidth = smooth ? this.lastProgressValue : width / ((double)size.width * 1.0);
                this.filledBarArea[0].drawSubArea((double)(pos.x + size.width) - width, pos.y, width, size.height, 1.0 - drawnWidth, 0.0, drawnWidth, 1.0);
            } else if (this.moveType == MoveType.VERTICAL) {
                double height = (double)size.height * this.lastProgressValue;
                if (!smooth) {
                    height = (int)height;
                }
                double drawnHeight = height / (double)size.height;
                this.filledBarArea[0].drawSubArea(pos.x, (double)(pos.y + size.height) - height, size.width, height, 0.0, 1.0 - drawnHeight, 1.0, drawnHeight);
            } else if (this.moveType == MoveType.VERTICAL_INVERTED) {
                double height = (double)size.height * (1.0 - this.lastProgressValue);
                if (!smooth) {
                    height = (int)height;
                }
                double drawnHeight = height / (double)size.height;
                this.filledBarArea[0].drawSubArea(pos.x, pos.y, size.width, height, 0.0, 0.0, 1.0, drawnHeight);
            } else if (this.moveType == MoveType.CIRCULAR) {
                double[] subAreas = new double[]{Math.min(1.0, Math.max(0.0, this.lastProgressValue / 0.25)), Math.min(1.0, Math.max(0.0, (this.lastProgressValue - 0.25) / 0.25)), Math.min(1.0, Math.max(0.0, (this.lastProgressValue - 0.5) / 0.25)), Math.min(1.0, Math.max(0.0, (this.lastProgressValue - 0.75) / 0.25))};
                int halfWidth = size.width / 2;
                int halfHeight = size.height / 2;
                double progressScaled = subAreas[0] * (double)halfHeight;
                if (!smooth) {
                    progressScaled = Math.round(progressScaled);
                }
                double progressScaledDrawnHeight = progressScaled / (double)halfHeight;
                this.filledBarArea[0].drawSubArea(pos.x, (double)(pos.y + size.height) - progressScaled, halfWidth, progressScaled, 0.0, 1.0 - progressScaledDrawnHeight, 1.0, progressScaledDrawnHeight);
                progressScaled = subAreas[1] * (double)halfWidth;
                if (!smooth) {
                    progressScaled = Math.round(progressScaled);
                }
                double progressScaledDrawnWidth = progressScaled / (double)halfWidth;
                this.filledBarArea[1].drawSubArea(pos.x, pos.y, progressScaled, halfHeight, 0.0, 0.0, progressScaledDrawnWidth, 1.0);
                progressScaled = subAreas[2] * (double)halfWidth;
                if (!smooth) {
                    progressScaled = Math.round(progressScaled);
                }
                progressScaledDrawnHeight = progressScaled / (double)halfHeight;
                this.filledBarArea[2].drawSubArea(pos.x + halfWidth, pos.y, halfWidth, progressScaled, 0.0, 0.0, 1.0, progressScaledDrawnHeight);
                progressScaled = subAreas[3] * (double)halfWidth;
                if (!smooth) {
                    progressScaled = Math.round(progressScaled);
                }
                progressScaledDrawnWidth = progressScaled / (double)halfWidth;
                this.filledBarArea[3].drawSubArea((double)(pos.x + size.width) - progressScaled, pos.y + halfHeight, progressScaled, halfHeight, 1.0 - progressScaledDrawnWidth, 0.0, progressScaledDrawnWidth, 1.0);
            } else if (this.moveType == MoveType.VERTICAL_DOWNWARDS) {
                double height = (double)size.height * this.lastProgressValue;
                if (!smooth) {
                    height = (int)height;
                }
                double drawnHeight = height / (double)size.height;
                this.filledBarArea[0].drawSubArea(pos.x, pos.y, size.width, height, 0.0, 0.0, 1.0, drawnHeight);
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        double actualValue = this.progressSupplier.getAsDouble();
        if (Math.abs(actualValue - this.lastProgressValue) > 0.005) {
            this.lastProgressValue = actualValue;
            this.writeUpdateInfo(0, buffer -> buffer.writeDouble(actualValue));
        }
        if (this.textSupplier != null) {
            ArrayList<ITextComponent> textBuffer = new ArrayList<ITextComponent>();
            this.textSupplier.accept(textBuffer);
            if (!this.hoverText.equals(textBuffer)) {
                this.hoverText = textBuffer;
                this.writeUpdateInfo(1, buffer -> {
                    buffer.func_150787_b(this.hoverText.size());
                    for (ITextComponent textComponent : this.hoverText) {
                        buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent));
                    }
                });
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastProgressValue = buffer.readDouble();
        } else if (id == 1) {
            this.hoverText.clear();
            int count = buffer.func_150792_a();
            for (int i = 0; i < count; ++i) {
                String jsonText = buffer.func_150789_c(Short.MAX_VALUE);
                this.hoverText.add(ITextComponent.Serializer.func_150699_a((String)jsonText));
            }
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        if (this.isMouseOverElement(mouseX, mouseY) && this.hoverText != null && !this.hoverText.isEmpty()) {
            ArrayList<String> hoverList = new ArrayList<String>();
            for (ITextComponent component : this.hoverText) {
                Collections.addAll(hoverList, component.func_150254_d());
            }
            if (!hoverList.isEmpty()) {
                this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
            }
        }
    }

    public static enum MoveType {
        VERTICAL,
        HORIZONTAL,
        VERTICAL_INVERTED,
        CIRCULAR,
        VERTICAL_DOWNWARDS,
        HORIZONTAL_BACKWARDS;

    }
}

