/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;

public class DrawableWidget
extends Widget {
    private BackgroundDrawer backgroundDrawer;
    private ForegroundDrawer foregroundDrawer;

    public DrawableWidget(Position selfPosition, Size size) {
        super(selfPosition, size);
    }

    public DrawableWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public DrawableWidget setBackgroundDrawer(BackgroundDrawer backgroundDrawer) {
        this.backgroundDrawer = backgroundDrawer;
        return this;
    }

    public DrawableWidget setForegroundDrawer(ForegroundDrawer foregroundDrawer) {
        this.foregroundDrawer = foregroundDrawer;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.backgroundDrawer != null) {
            this.backgroundDrawer.draw(mouseX, mouseY, partialTicks, context, this);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.foregroundDrawer != null) {
            this.foregroundDrawer.draw(mouseX, mouseY, this);
        }
    }

    @FunctionalInterface
    public static interface BackgroundDrawer {
        public void draw(int var1, int var2, float var3, IRenderContext var4, Widget var5);
    }

    @FunctionalInterface
    public static interface ForegroundDrawer {
        public void draw(int var1, int var2, Widget var3);
    }
}

