/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources.utils;

import gregtech.api.gui.resources.picturetexture.AnimatedPictureTexture;
import gregtech.api.gui.resources.picturetexture.OrdinaryTexture;
import gregtech.api.gui.resources.picturetexture.PictureTexture;
import gregtech.api.gui.resources.picturetexture.VideoTexture;
import gregtech.api.gui.resources.utils.GifDecoder;
import gregtech.api.gui.resources.utils.ImageUtils;
import gregtech.api.gui.resources.utils.ProcessedImageData;
import gregtech.api.gui.resources.utils.TextureCache;
import gregtech.api.util.GTLog;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class DownloadThread
extends Thread {
    public static final Logger LOGGER = GTLog.logger;
    public static final TextureCache TEXTURE_CACHE = new TextureCache();
    public static final DateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static final Object LOCK = new Object();
    public static final int MAXIMUM_ACTIVE_DOWNLOADS = 5;
    public static int activeDownloads = 0;
    public static HashMap<String, PictureTexture> loadedImages = new HashMap();
    public static Set<String> loadingImages = new HashSet<String>();
    private final String url;
    private ProcessedImageData processedImage;
    private String error;
    private boolean complete;
    private boolean isVideo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadThread(String url) {
        this.url = url;
        Object object = LOCK;
        synchronized (object) {
            loadingImages.add(url);
            ++activeDownloads;
        }
        this.setName("OPF Download \"" + url + "\"");
        this.setDaemon(true);
        this.start();
    }

    public boolean hasFinished() {
        return this.complete;
    }

    public boolean hasFailed() {
        return this.hasFinished() && this.error != null;
    }

    public boolean isVideo() {
        return this.isVideo;
    }

    public String getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exception exception = null;
        try {
            ByteArrayInputStream in;
            block15: {
                byte[] data = DownloadThread.load(this.url);
                String type = ImageUtils.readType(data);
                in = null;
                try {
                    in = new ByteArrayInputStream(data);
                    if (type.equalsIgnoreCase("gif")) {
                        GifDecoder gif = new GifDecoder();
                        int status = gif.read(in);
                        if (status == 0) {
                            this.processedImage = new ProcessedImageData(gif);
                        } else {
                            LOGGER.error("Failed to read gif: {}", (Object)status);
                        }
                        break block15;
                    }
                    try {
                        BufferedImage image = ImageIO.read(in);
                        if (image != null) {
                            this.processedImage = new ProcessedImageData(image);
                        }
                    }
                    catch (IOException e1) {
                        exception = e1;
                        LOGGER.error("Failed to parse BufferedImage from stream", (Throwable)e1);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)in);
        }
        catch (FoundVideoException e) {
            this.isVideo = true;
        }
        catch (Exception e) {
            exception = e;
            LOGGER.error("An exception occurred while loading OPFrame image", (Throwable)e);
        }
        if (!this.isVideo && this.processedImage == null) {
            this.error = exception == null ? "download.exception.gif" : (exception.getMessage() == null ? "download.exception.invalid" : (exception.getMessage().startsWith("Server returned HTTP response code: 403") ? "download.exception.forbidden" : (exception.getMessage().startsWith("Server returned HTTP response code: 404") ? "download.exception.notfound" : "download.exception.invalid")));
            TEXTURE_CACHE.deleteEntry(this.url);
        }
        this.complete = true;
        Object object = LOCK;
        synchronized (object) {
            loadingImages.remove(this.url);
            --activeDownloads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(String url) throws IOException, FoundVideoException {
        TextureCache.CacheEntry entry = TEXTURE_CACHE.getEntry(url);
        long requestTime = System.currentTimeMillis();
        URLConnection connection = new URL(url).openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:25.0) Gecko/20100101 Firefox/25.0");
        int responseCode = -1;
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            if (entry != null) {
                if (entry.getEtag() != null) {
                    httpConnection.setRequestProperty("If-None-Match", entry.getEtag());
                } else if (entry.getTime() != -1L) {
                    httpConnection.setRequestProperty("If-Modified-Since", FORMAT.format(new Date(entry.getTime())));
                }
            }
            responseCode = httpConnection.getResponseCode();
        }
        InputStream in = null;
        try {
            long lastModifiedTimestamp;
            String lastModified;
            String expires;
            in = connection.getInputStream();
            if (!connection.getContentType().startsWith("image")) {
                throw new FoundVideoException();
            }
            String etag = connection.getHeaderField("ETag");
            long expireTimestamp = -1L;
            String maxAge = connection.getHeaderField("max-age");
            if (maxAge != null && !maxAge.isEmpty()) {
                try {
                    expireTimestamp = requestTime + Long.parseLong(maxAge) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((expires = connection.getHeaderField("Expires")) != null && !expires.isEmpty()) {
                try {
                    expireTimestamp = FORMAT.parse(expires).getTime();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if ((lastModified = connection.getHeaderField("Last-Modified")) != null && !lastModified.isEmpty()) {
                try {
                    lastModifiedTimestamp = FORMAT.parse(lastModified).getTime();
                }
                catch (ParseException e) {
                    lastModifiedTimestamp = requestTime;
                }
            } else {
                lastModifiedTimestamp = requestTime;
            }
            if (entry != null) {
                File file;
                if (etag != null && !etag.isEmpty()) {
                    entry.setEtag(etag);
                }
                entry.setTime(lastModifiedTimestamp);
                if (responseCode == 304 && (file = entry.getFile()).exists()) {
                    try (FileInputStream fileStream = new FileInputStream(file);){
                        byte[] byArray = IOUtils.toByteArray((InputStream)fileStream);
                        return byArray;
                    }
                }
            }
            byte[] data = IOUtils.toByteArray((InputStream)in);
            TEXTURE_CACHE.save(url, etag, lastModifiedTimestamp, expireTimestamp, data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PictureTexture loadImage(DownloadThread thread) {
        PictureTexture texture = null;
        if (!thread.hasFailed()) {
            texture = thread.isVideo() ? new VideoTexture(thread.url) : (thread.processedImage.isAnimated() ? new AnimatedPictureTexture(thread.processedImage) : new OrdinaryTexture(thread.processedImage));
        }
        if (texture != null) {
            Object object = LOCK;
            synchronized (object) {
                loadedImages.put(thread.url, texture);
            }
        }
        return texture;
    }

    public static class FoundVideoException
    extends Exception {
    }
}

