/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.picturetexture.PictureTexture;
import gregtech.api.gui.resources.utils.DownloadThread;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class URLTexture
implements IGuiTexture {
    public final String url;
    @SideOnly(value=Side.CLIENT)
    private DownloadThread downloader;
    @SideOnly(value=Side.CLIENT)
    private PictureTexture texture;
    @SideOnly(value=Side.CLIENT)
    private boolean failed;
    @SideOnly(value=Side.CLIENT)
    private String error;

    public URLTexture(String url) {
        this.url = url;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateTick() {
        if (this.texture != null) {
            this.texture.tick();
        }
    }

    @Override
    public void draw(double x, double y, int width, int height) {
        if (this.texture != null && this.texture.hasTexture()) {
            this.texture.render((float)x, (float)y, width, height, 0.0f, 1.0f, 1.0f, false, false);
        } else if (this.failed || this.url == null || this.url.isEmpty()) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"texture.url_texture.fail", (Object[])new Object[0]), (int)x + 2, (int)(y + (double)height / 2.0 - 4.0), -65536);
        } else {
            this.loadTexture();
            int s = (int)Math.floorMod(System.currentTimeMillis() / 200L, 24L);
            Widget.drawSector((float)(x + (double)width / 2.0), (float)(y + (double)height / 2.0), (float)((double)Math.min(width, height) / 4.0), -7019839, 24, s, s + 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void loadTexture() {
        if (this.texture == null && !this.failed) {
            if (this.downloader == null && DownloadThread.activeDownloads < 5) {
                PictureTexture loadedTexture = DownloadThread.loadedImages.get(this.url);
                if (loadedTexture == null) {
                    Object object = DownloadThread.LOCK;
                    synchronized (object) {
                        if (!DownloadThread.loadingImages.contains(this.url)) {
                            this.downloader = new DownloadThread(this.url);
                            return;
                        }
                    }
                } else {
                    this.texture = loadedTexture;
                }
            }
            if (this.downloader != null && this.downloader.hasFinished()) {
                if (this.downloader.hasFailed()) {
                    this.failed = true;
                    this.error = this.downloader.getError();
                    DownloadThread.LOGGER.error("Could not load image of " + this.url + " : " + this.error);
                } else {
                    this.texture = DownloadThread.loadImage(this.downloader);
                }
                this.downloader = null;
            }
        }
    }
}

