/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import gregtech.api.gui.resources.IGuiTexture;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextTexture
implements IGuiTexture {
    public String text;
    public int color;
    public int width;
    public boolean dropShadow;
    public TextType type;
    @SideOnly(value=Side.CLIENT)
    private List<String> texts;
    private final boolean isClient = FMLCommonHandler.instance().getSide().isClient();

    public TextTexture(String text, int color) {
        this.color = color;
        this.type = TextType.NORMAL;
        if (this.isClient) {
            this.text = I18n.func_135052_a((String)text, (Object[])new Object[0]);
            this.texts = Collections.singletonList(this.text);
        }
    }

    public TextTexture() {
        this.color = 0xFFFFFF;
        this.type = TextType.NORMAL;
        this.text = "";
        if (this.isClient) {
            this.texts = Collections.singletonList(this.text);
        }
    }

    public TextTexture setColor(int color) {
        this.color = color;
        return this;
    }

    public TextTexture setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public TextTexture setWidth(int width) {
        this.width = width;
        return this;
    }

    public TextTexture setText(String text) {
        if (!this.text.equals(text)) {
            this.text = text;
            if (this.isClient) {
                this.texts = this.width > 0 ? Minecraft.func_71410_x().field_71466_p.func_78271_c(text, this.width) : Collections.singletonList(text);
            }
        }
        return this;
    }

    public TextTexture setType(TextType type) {
        this.type = type;
        return this;
    }

    @Override
    public void draw(double x, double y, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textH = fontRenderer.field_78288_b;
        if (this.type == TextType.NORMAL) {
            textH *= this.texts.size();
            for (int i = 0; i < this.texts.size(); ++i) {
                String resultText = this.texts.get(i);
                int textW = fontRenderer.func_78256_a(resultText);
                float _x = (float)(x + (double)((float)(width - textW) / 2.0f));
                float _y = (float)(y + (double)((float)(height - textH) / 2.0f) + (double)(i * fontRenderer.field_78288_b));
                fontRenderer.func_175065_a(resultText, _x, _y, this.color, this.dropShadow);
            }
        } else if (this.type == TextType.HIDE) {
            String resultText = this.texts.get(0) + (this.texts.size() > 1 ? ".." : "");
            int textW = fontRenderer.func_78256_a(resultText);
            float _x = (float)(x + (double)((float)(width - textW) / 2.0f));
            float _y = (float)(y + (double)((float)(height - textH) / 2.0f));
            fontRenderer.func_175065_a(resultText, _x, _y, this.color, this.dropShadow);
        } else if (this.type == TextType.ROLL) {
            int i = (int)(Minecraft.func_71386_F() / 1000L % (long)this.texts.size());
            String resultText = this.texts.get(i);
            int textW = fontRenderer.func_78256_a(resultText);
            float _x = (float)(x + (double)((float)(width - textW) / 2.0f));
            float _y = (float)(y + (double)((float)(height - textH) / 2.0f));
            fontRenderer.func_175065_a(resultText, _x, _y, this.color, this.dropShadow);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum TextType {
        NORMAL,
        HIDE,
        ROLL;

    }
}

