/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.GregTechAPI;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.impl.ModularUIGui;
import gregtech.core.network.packets.PacketUIOpen;
import gregtech.core.network.packets.PacketUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UIFactory<E extends IUIHolder> {
    public final void openUI(E holder, EntityPlayerMP player) {
        if (player instanceof FakePlayer) {
            return;
        }
        ModularUI uiTemplate = this.createUITemplate(holder, (EntityPlayer)player);
        if (uiTemplate == null) {
            return;
        }
        uiTemplate.initWidgets();
        player.func_71117_bO();
        player.func_71128_l();
        int currentWindowId = player.field_71139_cq;
        PacketBuffer serializedHolder = new PacketBuffer(Unpooled.buffer());
        this.writeHolderToSyncData(serializedHolder, holder);
        int uiFactoryId = GregTechAPI.UI_FACTORY_REGISTRY.func_148757_b(this);
        ModularUIContainer container = new ModularUIContainer(uiTemplate);
        container.field_75152_c = currentWindowId;
        container.accumulateWidgetUpdateData = true;
        uiTemplate.guiWidgets.values().forEach(Widget::detectAndSendChanges);
        container.accumulateWidgetUpdateData = false;
        ArrayList<PacketUIWidgetUpdate> updateData = new ArrayList<PacketUIWidgetUpdate>(container.accumulatedUpdates);
        container.accumulatedUpdates.clear();
        PacketUIOpen packet = new PacketUIOpen(uiFactoryId, serializedHolder, currentWindowId, updateData);
        GregTechAPI.networkHandler.sendTo(packet, player);
        container.func_75132_a((IContainerListener)player);
        player.field_71070_bA = container;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, (Container)container));
    }

    @SideOnly(value=Side.CLIENT)
    public final void initClientUI(PacketBuffer serializedHolder, int windowId, List<PacketUIWidgetUpdate> initialWidgetUpdates) {
        E holder = this.readHolderFromSyncData(serializedHolder);
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP entityPlayer = minecraft.field_71439_g;
        ModularUI uiTemplate = this.createUITemplate(holder, (EntityPlayer)entityPlayer);
        uiTemplate.initWidgets();
        ModularUIGui modularUIGui = new ModularUIGui(uiTemplate);
        modularUIGui.field_147002_h.field_75152_c = windowId;
        for (PacketUIWidgetUpdate packet : initialWidgetUpdates) {
            modularUIGui.handleWidgetUpdate(packet);
        }
        minecraft.func_152344_a(() -> {
            minecraft.func_147108_a((GuiScreen)modularUIGui);
            minecraft.field_71439_g.field_71070_bA.field_75152_c = windowId;
        });
    }

    protected abstract ModularUI createUITemplate(E var1, EntityPlayer var2);

    @SideOnly(value=Side.CLIENT)
    protected abstract E readHolderFromSyncData(PacketBuffer var1);

    protected abstract void writeHolderToSyncData(PacketBuffer var1, E var2);
}

