/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids.store;

import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.store.FluidStorageKey;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTUtility;
import org.jetbrains.annotations.NotNull;

public final class FluidStorageKeys {
    public static final FluidStorageKey LIQUID = new FluidStorageKey(GTUtility.gregtechId("liquid"), MaterialIconType.liquid, m -> FluidStorageKeys.prefixedRegistryName("liquid.", LIQUID, m), m -> m.hasProperty(PropertyKey.DUST) ? "gregtech.fluid.liquid_generic" : "gregtech.fluid.generic", FluidState.LIQUID);
    public static final FluidStorageKey GAS = new FluidStorageKey(GTUtility.gregtechId("gas"), MaterialIconType.gas, m -> FluidStorageKeys.prefixedRegistryName("gas.", GAS, m), m -> {
        if (m.hasProperty(PropertyKey.DUST)) {
            return "gregtech.fluid.gas_vapor";
        }
        FluidProperty property = m.getProperty(PropertyKey.FLUID);
        if (m.isElement() || property == null || property.getPrimaryKey() != GAS) {
            return "gregtech.fluid.gas_generic";
        }
        return "gregtech.fluid.generic";
    }, FluidState.GAS);
    public static final FluidStorageKey PLASMA = new FluidStorageKey(GTUtility.gregtechId("plasma"), MaterialIconType.plasma, m -> "plasma." + m.getName(), m -> "gregtech.fluid.plasma", FluidState.PLASMA, -1);

    private FluidStorageKeys() {
    }

    @NotNull
    public static String prefixedRegistryName(@NotNull String prefix, @NotNull FluidStorageKey key, @NotNull Material material) {
        FluidProperty property = material.getProperty(PropertyKey.FLUID);
        if (property != null && property.getPrimaryKey() != key) {
            return prefix + material.getName();
        }
        return material.getName();
    }
}

