/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids.attribute;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class FluidAttribute {
    private final ResourceLocation resourceLocation;
    private final Consumer<List<String>> fluidTooltip;
    private final Consumer<List<String>> containerTooltip;
    private final int hashCode;

    public FluidAttribute(@NotNull ResourceLocation resourceLocation, @NotNull @NotNull Consumer<List<@NotNull String>> fluidTooltip, @NotNull @NotNull Consumer<List<@NotNull String>> containerTooltip) {
        this.resourceLocation = resourceLocation;
        this.fluidTooltip = fluidTooltip;
        this.containerTooltip = containerTooltip;
        this.hashCode = resourceLocation.hashCode();
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void appendFluidTooltips(@NotNull @NotNull List<@NotNull String> tooltip) {
        this.fluidTooltip.accept(tooltip);
    }

    public void appendContainerTooltips(@NotNull @NotNull List<@NotNull String> tooltip) {
        this.containerTooltip.accept(tooltip);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidAttribute that = (FluidAttribute)o;
        return this.resourceLocation.equals((Object)that.getResourceLocation());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    public String toString() {
        return "FluidAttribute{" + this.resourceLocation + '}';
    }
}

