/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.api.unification.material.Material;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GTFluid
extends Fluid
implements AttributedFluid {
    private final Collection<FluidAttribute> attributes = new ObjectLinkedOpenHashSet();
    private final FluidState state;

    public GTFluid(@NotNull String fluidName, ResourceLocation still, ResourceLocation flowing, @NotNull FluidState state) {
        super(fluidName, still, flowing);
        this.setGaseous(state != FluidState.LIQUID);
        this.state = state;
    }

    @Override
    @NotNull
    public FluidState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<FluidAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void addAttribute(@NotNull FluidAttribute attribute) {
        this.attributes.add(attribute);
    }

    public static class GTMaterialFluid
    extends GTFluid {
        private final Material material;
        private final String translationKey;

        public GTMaterialFluid(@NotNull String fluidName, ResourceLocation still, ResourceLocation flowing, @NotNull FluidState state, @Nullable String translationKey, @NotNull Material material) {
            super(fluidName, still, flowing, state);
            this.material = material;
            this.translationKey = translationKey;
        }

        @NotNull
        public Material getMaterial() {
            return this.material;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.10")
        @NotNull
        public TextComponentTranslation toTextComponentTranslation() {
            String customMaterialTranslation = "fluid." + this.material.getUnlocalizedName();
            TextComponentTranslation localizedName = I18n.func_94522_b((String)customMaterialTranslation) ? new TextComponentTranslation(customMaterialTranslation, new Object[0]) : new TextComponentTranslation(this.material.getUnlocalizedName(), new Object[0]);
            if (this.translationKey != null) {
                return new TextComponentTranslation(this.translationKey, new Object[]{localizedName});
            }
            return localizedName;
        }

        @NotNull
        public IKey getLocalizedKey() {
            String customMaterialTranslation = "fluid." + this.material.getUnlocalizedName();
            IKey localizedName = I18n.func_94522_b((String)customMaterialTranslation) ? IKey.lang((String)customMaterialTranslation) : IKey.lang((String)this.material.getUnlocalizedName());
            if (this.translationKey != null) {
                return IKey.lang((String)this.translationKey, (Object[])new Object[]{localizedName});
            }
            return localizedName;
        }

        @SideOnly(value=Side.CLIENT)
        public String getLocalizedName(FluidStack stack) {
            return this.getLocalizedKey().get();
        }
    }
}

