/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.creativetab;

import gregtech.api.util.GTLog;
import java.util.function.Supplier;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BaseCreativeTab
extends CreativeTabs {
    private final boolean hasSearchBar;
    private final Supplier<ItemStack> iconSupplier;

    public BaseCreativeTab(String tabName, Supplier<ItemStack> iconSupplier, boolean hasSearchBar) {
        super(tabName);
        this.iconSupplier = iconSupplier;
        this.hasSearchBar = hasSearchBar;
        if (hasSearchBar) {
            this.func_78025_a("item_search.png");
        }
    }

    @NotNull
    public ItemStack func_78016_d() {
        if (this.iconSupplier == null) {
            GTLog.logger.error("Icon supplier was null for CreativeTab {}", (Object)this.func_78013_b());
            return new ItemStack(Blocks.field_150348_b);
        }
        ItemStack stack = this.iconSupplier.get();
        if (stack == null) {
            GTLog.logger.error("Icon supplier return null for CreativeTab {}", (Object)this.func_78013_b());
            return new ItemStack(Blocks.field_150348_b);
        }
        if (stack.func_190926_b()) {
            GTLog.logger.error("Icon built from iconSupplied is EMPTY for CreativeTab {}", (Object)this.func_78013_b());
            return new ItemStack(Blocks.field_150348_b);
        }
        return stack;
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }
}

