/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverUIFactory;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.GregTechGuiScreen;
import gregtech.api.mui.factory.CoverGuiFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;

public interface CoverWithUI
extends Cover,
IUIHolder,
IGuiHolder<SidedPosGuiData> {
    public static final int UI_TITLE_COLOR = -14540254;
    public static final int UI_TEXT_COLOR = -11184811;

    @ApiStatus.Experimental
    default public boolean usesMui2() {
        return false;
    }

    default public void openUI(EntityPlayerMP player) {
        if (this.usesMui2()) {
            CoverGuiFactory.open((EntityPlayer)player, this);
        } else {
            CoverUIFactory.INSTANCE.openUI(this, player);
        }
    }

    @Deprecated
    default public ModularUI createUI(EntityPlayer player) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.NonExtendable
    default public ModularScreen createScreen(SidedPosGuiData guiData, ModularPanel mainPanel) {
        return new GregTechGuiScreen(mainPanel, this.getUITheme());
    }

    default public GTGuiTheme getUITheme() {
        return GTGuiTheme.COVER;
    }

    default public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return null;
    }

    @Override
    default public boolean isValid() {
        return this.getCoverableView().isValid();
    }

    @Override
    default public boolean isRemote() {
        return this.getCoverableView().getWorld().field_72995_K;
    }

    @Override
    default public void markAsDirty() {
        this.getCoverableView().markDirty();
    }

    public static Flow createTitleRow(ItemStack stack) {
        return (Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().pos(4, 4)).height(16)).coverChildrenWidth()).child((IWidget)((Widget)new ItemDrawable(stack).asWidget().size(16)).marginRight(4))).child((IWidget)IKey.str((String)stack.func_82833_r()).color(Integer.valueOf(-14540254)).asWidget().heightRel(1.0f));
    }

    default public ParentWidget<?> createSettingsRow() {
        return (ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().height(16)).widthRel(1.0f)).marginBottom(2);
    }

    default public int getIncrementValue(MouseData data) {
        int adjust = 1;
        if (data.shift) {
            adjust *= 4;
        }
        if (data.ctrl) {
            adjust *= 16;
        }
        if (data.alt) {
            adjust *= 64;
        }
        return adjust;
    }

    default public IKey createAdjustOverlay(boolean increment) {
        StringBuilder builder = new StringBuilder();
        builder.append(increment ? (char)'+' : '-');
        builder.append(this.getIncrementValue(MouseData.create((int)-1)));
        float scale = 1.0f;
        if (builder.length() == 3) {
            scale = 0.8f;
        } else if (builder.length() == 4) {
            scale = 0.6f;
        } else if (builder.length() > 4) {
            scale = 0.5f;
        }
        return IKey.str((String)builder.toString()).color(Integer.valueOf(Color.WHITE.main)).scale(scale);
    }

    default public <T extends Enum<T>> BoolValue.Dynamic boolValueOf(EnumSyncValue<T> syncValue, T value) {
        return new BoolValue.Dynamic(() -> syncValue.getValue() == value, $ -> syncValue.setValue((Object)value));
    }

    default public BoolValue.Dynamic boolValueOf(IntSyncValue syncValue, int value) {
        return new BoolValue.Dynamic(() -> syncValue.getValue() == value, $ -> syncValue.setValue((Object)value));
    }

    public static class EnumRowBuilder<T extends Enum<T>> {
        private EnumSyncValue<T> syncValue;
        private final Class<T> enumValue;
        private String lang;
        private IDrawable[] background;
        private IDrawable selectedBackground;
        private IDrawable[] overlay;

        public EnumRowBuilder(Class<T> enumValue) {
            this.enumValue = enumValue;
        }

        public EnumRowBuilder<T> value(EnumSyncValue<T> syncValue) {
            this.syncValue = syncValue;
            return this;
        }

        public EnumRowBuilder<T> lang(String lang) {
            this.lang = lang;
            return this;
        }

        public EnumRowBuilder<T> background(IDrawable ... background) {
            this.background = background;
            return this;
        }

        public EnumRowBuilder<T> selectedBackground(IDrawable selectedBackground) {
            this.selectedBackground = selectedBackground;
            return this;
        }

        public EnumRowBuilder<T> overlay(IDrawable ... overlay) {
            this.overlay = overlay;
            return this;
        }

        public EnumRowBuilder<T> overlay(int size, IDrawable ... overlay) {
            this.overlay = new IDrawable[overlay.length];
            for (int i = 0; i < overlay.length; ++i) {
                this.overlay[i] = overlay[i].asIcon().size(size);
            }
            return this;
        }

        private BoolValue.Dynamic boolValueOf(EnumSyncValue<T> syncValue, T value) {
            return new BoolValue.Dynamic(() -> syncValue.getValue() == value, $ -> syncValue.setValue(value));
        }

        public Flow build() {
            Flow row = (Flow)((Flow)((Flow)Flow.row().marginBottom(2)).coverChildrenHeight()).widthRel(1.0f);
            if (this.enumValue != null && this.syncValue != null) {
                for (Enum enumVal : (Enum[])this.enumValue.getEnumConstants()) {
                    ToggleButton button = ((ToggleButton)((ToggleButton)new ToggleButton().size(18)).marginRight(2)).value((IBoolValue)this.boolValueOf(this.syncValue, enumVal));
                    if (this.background != null && this.background.length > 0) {
                        button.background(this.background);
                    } else {
                        button.background(new IDrawable[]{GTGuiTextures.MC_BUTTON});
                    }
                    if (this.selectedBackground != null) {
                        button.selectedBackground(new IDrawable[]{this.selectedBackground});
                    } else {
                        button.selectedBackground(new IDrawable[]{GTGuiTextures.MC_BUTTON_DISABLED});
                    }
                    if (this.overlay != null) {
                        button.overlay(new IDrawable[]{this.overlay[enumVal.ordinal()]});
                    }
                    if (enumVal instanceof IStringSerializable) {
                        IStringSerializable serializable = (IStringSerializable)enumVal;
                        button.addTooltipLine((IDrawable)IKey.lang((String)serializable.func_176610_l()));
                    }
                    row.child((IWidget)button);
                }
            }
            if (this.lang != null && !this.lang.isEmpty()) {
                row.child((IWidget)((TextWidget)IKey.lang((String)this.lang).asWidget().align(Alignment.CenterRight)).height(18));
            }
            return row;
        }
    }
}

